<?php

function mf_nodo_gitem(array $datos)
{

	$xml='';
    foreach($datos as $idx => $gitem)
    {

		
		$xml .= '<gItem>';
        // C02:Nmero secuencial del tem
        $xml .= crea_nodo_simple($gitem, 'dSecItem');
        // C03:Descripcin del producto o servicio
        $xml .= crea_nodo_simple($gitem, 'dDescProd');
        // C04:Cdigo interno del tem
        $xml .= crea_nodo_simple($gitem, 'dCodProd');
        // C05:Unidad de medida del cdigo interno
        $xml .= crea_nodo_simple($gitem, 'cUnidad');
        // C06:Cantidad del producto o servicio en la unidad de medida del cdigo interno
        $xml .= crea_nodo_simple($gitem, 'dCantCodInt');
        // C07:Fecha de fabricacin/elaboracin
        $xml .= crea_nodo_simple($gitem, 'dFechaFab');
        // C08:Fecha de caducidad
        $xml .= crea_nodo_simple($gitem, 'dFechaCad');
        // C09:Cdigo del tem en la Codificacin Panamea de Bienes y Servicios Abreviada
        $xml .= crea_nodo_simple($gitem, 'dCodCPBSabr');
        // C10:Cdigo del tem en la Codificacin Panamea de Bienes y Servicios
        $xml .= crea_nodo_simple($gitem, 'dCodCPBScmp');
        // C11:Unidad de medida en la Codificacin Panamea de Bienes y Servicios
        $xml .= crea_nodo_simple($gitem, 'cUnidadCPBS');
        // C19:Informaciones de inters del emitente con respeto a un tem de la FE
        $xml .= crea_nodo_simple($gitem, 'dInfEmFE');

        // C20:Grupo de precios del tem
        $xml .= crea_nodo_rama($gitem, 'gPrecios', array('dPrUnit', 'dPrUnitDesc', 'dPrItem', 'dPrAcarItem', 'dPrSegItem', 'dValTotItem'));

        $xml .= crea_nodo_rama($gitem, 'gCodItem', array('dGTINCom', 'dCantGTINCom', 'dGTINInv', 'dCantComInvent'));

        // C40:Grupo de ITBMS del tem
        $xml .= crea_nodo_rama($gitem, 'gITBMSItem', array('dTasaITBMS', 'dValITBMS'));

        // C50:Grupo de ISC del tem
        $xml .= crea_nodo_rama($gitem, 'gISCItem', array('dTasaISC', 'dValISC'));


		
		$xml.= crea_nodo_gOTIItem($gitem);

        // E05: Grupo de detalle de vehculos nuevos
        $xml .= crea_nodo_rama($gitem, 'gVehicNuevo', array(
            'iModOpVN',
            'dModOpVNDesc',
            'dChasi',
            'dColorCod',
            'dColorNomb',
            'dPotVeh',
            'dCilin',
            'dPesoNet',
            'dPesoBruto',
            'dNSerie',
            'iCombust',
            'iCombustDesc',
            'dNroMotor',
            'dCapTracc',
            'dEntreEj',
            'dAnoMod',
            'dAnoFab',
            'dTipoPintura',
            'dTipoPinturaDesc',
            'dTipoVehic',
            'cEspVehic',
            'iCondVehic',
            'dLotac',
        ));

        // E10: Grupo de detalle de medicinas y materias primas farmacuticas
        $xml .= crea_nodo_rama($gitem, 'gMedicina', array('dNroLote', 'dCtLote'));
        
        // E10: Grupo de detalle de medicinas y materias primas farmacuticas
        $xml .= crea_nodo_rama($gitem, 'gPedComIr', array('dNroPed', 'dSecItemPed', 'dInfEmPedIt'));
		$xml .= '</gItem>';
    }

    

    return $xml;
}


function crea_nodo_gOTIItem(array $datos)
{
	$xml='';
	$cnt=count($datos['gOTIItem']);
	if($cnt>0)
	{
		foreach($datos['gOTIItem'] AS $datogOTIItem)
		{
			$dCodOTI=$datogOTIItem['dCodOTI'];
			$dValOTI=$datogOTIItem['dValOTI'];
			$xml.="<gOTIItem><dCodOTI>$dCodOTI</dCodOTI><dValOTI>$dValOTI</dValOTI></gOTIItem>";
		}		
	}
	
	return $xml;
}