<?php
ini_set('display_errors', 0);
$PageSecurity = 1;

include('includes/session.php');
$Title = _('Timbrar dividendos');
include('includes/header.php');
//require_once 'sdk2-RC9/sdk2.php';
//require_once 'SDK2-R10g/sdk2.php';
require_once 'SDK2-R10i/sdk2.php';

date_default_timezone_set('America/Mexico_City');

echo '<br><br><h1 align="center">Formato para timbrar dividendos</h1><br><br>';

if (isset($_POST['Timbrar'])) {

    $folio = idate("U");

    $datos['cfdi'] = 'SAT/facturasTimbradas/retencion_' . ltrim($folio, '0') . '.xml';
    $datos['remueve_acentos'] = 'SI';
    $datos['retencion'] = 'SI';

//Datps de prueba    
//    $datos['PAC']['usuario'] = 'DEMO700101XXX';
//    $datos['PAC']['pass'] = 'DEMO700101XXX';
//    $datos['PAC']['produccion'] = 'NO'; //   [SI|NO]

//    $datos['conf']['cer'] = 'SAT/00001000000502496966.cer.pem';
//    $datos['conf']['key'] = 'SAT/BNO090907GY9_20191217_233010.key.pem';
//    $datos['conf']['pass'] = 'qaz1029plm';

//datos reales    
    $datos['PAC']['usuario'] = 'BNO090907GY9';
    $datos['PAC']['pass'] = 'BNO090907111';
    $datos['PAC']['produccion'] = 'SI'; //   [SI|NO]
    
    $datos['conf']['cer'] = 'SAT/00001000000502496966.cer.pem';
    $datos['conf']['key'] = 'SAT/BNO090907GY9_20191217_233010.key.pem';
    $datos['conf']['pass'] = 'qaz1029plm';

//OPCIONAL, UTILIZAR LA LIBRERIA PHP DE OPENSSL, DEFAULT SI
    $datos['php_openssl'] = 'SI';

    $datos['factura']['FolioInt'] = $folio;
    $datos['factura']['FechaExp'] = date('Y-m-d\TH:i:sP', time() - 120);
    $datos['factura']['CveRetenc'] = '14';
    $datos['factura']['DescRetenc'] = '14 Dividendos o utilidades distribuidas';

//datos prueba demisor
//    $datos['emisor']['RFCEmisor'] = 'AAA010101AAA';
//    $datos['emisor']['NomDenRazSocE'] = 'ACCEM Servicios Empresariales';
//$datos['emisor']['CURPE'] = 'GAAR930830HNLMNL02';
//datos reales emisor
    $datos['emisor']['RFCEmisor'] = $_SESSION['CompanyRecord']['gstno'];
    $datos['emisor']['NomDenRazSocE'] = $_SESSION['CompanyRecord']['coyname'];

    $datos['receptor']['Nacionalidad'] = 'Nacional';
    $datos['receptor']['Nacional']['RFCRecep'] = $_POST['RFCR'];
    $datos['receptor']['Nacional']['NomDesRazSocR'] = $_POST['NomR'];
    $datos['receptor']['Nacional']['CURPR'] = $_POST['CURPR'];

//$datos['receptor']['Extranjero']['NumRegIdTrib'] = '';
//$datos['receptor']['Extranjero']['NomDenRazSocR'] = '';

    $datos['periodo']['MesIni'] = $_POST['MesIni'];
    $datos['periodo']['MesFin'] = $_POST['MesFin'];
    $datos['periodo']['Ejerc'] = $_POST['Ejercicio'];


    $datos['totales']['montoTotOperacion'] = $_POST['montoTotOperacion'];
    $datos['totales']['montoTotGrav'] = $_POST['montoTotGrav'];
    $datos['totales']['montoTotExent'] = $_POST['montoTotExent'];
    $datos['totales']['montoTotRet'] = $_POST['montoTotRet'];

    $datos['totales']['ImpRetenidos'][0]['BaseRet'] = $_POST['BaseRet'];
    $datos['totales']['ImpRetenidos'][0]['Impuesto'] = $_POST['Impuesto'];
    $datos['totales']['ImpRetenidos'][0]['montoRet'] = $_POST['montoRet'];
    $datos['totales']['ImpRetenidos'][0]['TipoPagoRet'] = 'Pago definitivo';

//dividendos
    $datos['dividendos']['DividOUtil']['CveTipDivOUtil'] = $_POST['CveTipDivOUtil'];
    $datos['dividendos']['DividOUtil']['MontISRAcredRetMexico'] = $_POST['MontISRAcredRetMexico'];
    $datos['dividendos']['DividOUtil']['MontISRAcredRetExtranjero'] = $_POST['MontISRAcredRetExtranjero'];
//$datos['dividendos']['DividOUtil']['MontRetExtDivExt']='300.00';
    $datos['dividendos']['DividOUtil']['TipoSocDistrDiv'] = 'Sociedad Nacional';
    $datos['dividendos']['DividOUtil']['MontISRAcredNal']=$_POST['MontISRAcredNa'];
    $datos['dividendos']['DividOUtil']['MontDivAcumNal']=$_POST['MontDivAcumNal'];
    $datos['dividendos']['DividOUtil']['MontDivAcumExt']=$_POST['MontDivAcumExt'];
//    print_r(array_values($datos));
    
//imprimir array
    print("<pre>" . print_r($datos, true) . "</pre>");


    $res = cfdi_retenicion_generar_xml($datos, $produccion = 'NO');

    if ($res['cfdi'] == '') {
        echo "<h1>Respuesta Generar XML y Timbrado</h1>";
        foreach ($res AS $variable => $valor) {
            $valor = htmlentities($valor);
            $valor = str_replace('&lt;br/&gt;', '<br/>', $valor);
            echo "<b>[$variable]=</b>$valor<hr>";
        }
        exit();
    } else {
        
        echo "<h1>Respuesta </h1>";
//foreach($res AS $variable=>$valor)
//{
//    $valor=htmlentities($valor);
//    $valor=str_replace('&lt;br/&gt;','<br/>',$valor);
//    echo "<b>[$variable]=</b>$valor<hr>";
//}

//        $cfdi = $res['cfdi'];
//        file_put_contents($datos['cfdi'], base64_decode($cfdi));

        echo '<h1 align="center">el recibo de dividendos ' . $_POST['FolioInt'] . ' ha sido timbrado.</h1>';
        echo '<a href="' . $_SERVER['PHP_SELF'] . '"><h1 align="center">Regresar</h1></a>';
        echo '<a href="' . $datos['cfdi'] . '" type="text/html"><h1 align="center">Abrir archivo ' . $datos['cfdi'] . '</h1></a>';
    }
} else {
    echo '<form action="' . htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8') . '" method="post">';
    echo '<input type="hidden" name="FormID" value="' . $_SESSION['FormID'] . '" />';

    echo '<table cellpadding="0" class="selection">';

    echo '<tr><td colspan="2">' . _('RFC del receptor') . ':</td><td><input type="text" name="RFCR" size="20" maxlength="25" required/></td></tr>';
    echo '<tr><td colspan="2">' . _('Nombre receptor') . ':</td><td><input type="text" name="NomR" size="30" maxlength="50" required/></td></tr>';
    echo '<tr><td colspan="2">' . _('CURP Receptor') . ':</td><td><input type="text" name="CURPR" size="20" maxlength="25" required/></td></tr>';



    echo '<tr><td colspan="2">' . _('Mes inicial') . ':</td><td><select name="MesIni">';
    for ($i = 1; $i < 13; $i++) {
        echo '<option value=' . $i . '>' . $i . '</option>';
    }
    echo '</select></td></tr>';
    echo '<tr><td colspan="2">' . _('Mes final') . ':</td><td><select name="MesFin">';
    for ($i = 1; $i < 13; $i++) {
        echo '<option value=' . $i . '>' . $i . '</option>';
    }
    echo '</select></td></tr>';
    echo '<tr><td colspan="2">' . _('Ejercicio (año)') . ':</td><td><input type="text" name="Ejercicio" size="4" maxlength="4" required /></td></tr>';

    echo '<tr><td colspan="2">' . _('Monto total de la operación') . ':</td><td><input class="number" name="montoTotOperacion" size="7" maxlength="12" required /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto total gravable') . ':</td><td><input class="number" name="montoTotGrav" size="7" maxlength="12" required /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto total de exento') . ':</td><td><input class="number" name="montoTotExent" size="7" maxlength="12" required /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto total retenido') . ':</td><td><input class="number" name="montoTotRet" size="7" maxlength="12" required /></td></tr>';

    echo '<tr><td colspan="2">' . _('Base de la retención') . ':</td><td><input class="number" name="BaseRet" size="7" maxlength="12" ></td></tr>';

    echo '<tr><td colspan="2">' . _('Impuesto') . ':</td><td><select name="Impuesto">';
    echo '<option value=01>ISR</option>';
    echo '<option value=02>IVA</option>';
    echo '<option value=03>IEPS</option>';
    echo '</select></td></tr>';

    echo '<tr><td colspan="2">' . _('Importe del impuesto retenido') . ':</td><td><input class="number" name="montoRet" size="7" maxlength="12" required /></td></tr>';
   
    echo '<tr><td colspan="2">' . _('Tipo dividendos o utilidades') . ':</td><td><select name="CveTipDivOUtil">';
    echo '<option value=01>Proviene de CUFIN</option>';
    echo '<option value=02>No proviene de CUFIN</option>';
    echo '<option value=03>Reembolso o reducción de capital</option>';
    echo '<option value=04>Liquidación de la persona moral</option>';
    echo '<option value=05>CUFINRE</option>';
    echo '<option value=06>Proviene de CUFIN al 31 de diciembre 2013</option>';
    echo '</select></td></tr>';
    echo '<tr><td colspan="2">' . _('Importe o retención del dividendo o utilidad en territorio nacional') . ':</td><td><input class="number" name="MontISRAcredRetMexico" size="7" maxlength="12" /></td></tr>';
    echo '<tr><td colspan="2">' . _('Importe o retención del dividendo o utilidad en territorio extranjero') . ':</td><td><input class="number" name="MontISRAcredRetExtranjero" size="7" maxlength="12" /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto del ISR acreditable nacional') . ':</td><td><input class="number" name="MontISRAcredNal" size="7" maxlength="12" /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto del dividendo acumulable nacional') . ':</td><td><input class="number" name="MontDivAcumNal" size="7" maxlength="12" /></td></tr>';
    echo '<tr><td colspan="2">' . _('Monto del dividendo acumulable extranjero') . ':</td><td><input class="number" name="MontDivAcumExt" size="7" maxlength="12" /></td></tr>';

    
    
    echo '</table>';
    echo '<br><div class="centre"><input type="submit" name="Timbrar" value="' . _('Timbrar') . '" /></div>';
    echo '</form>';
}

include('includes/footer.php');
?>



