<?php

$PageSecurity = 1;
//error_reporting(E_ALL & ~E_NOTICE);
//ini_set('display_errors', 0);

include('includes/session.php');
include('Numbers/Words.php');
include('includes/class.pdf.php');
$Title = _('Nota de cargo');
ob_start();
include('includes/header.php');

If (isset($_GET['TransNo'])) {
    $sql = "SELECT salesorders.customerref,
			salesorders.comments,
			salesorders.orddate,
			salesorders.deliverto,
			salesorders.deladd1,
			salesorders.deladd2,
			salesorders.deladd3,
			salesorders.deladd4,
			salesorders.deladd5,
			salesorders.deladd6,
			salesorders.debtorno,
			salesorders.branchcode,
			salesorders.deliverydate,
                        salesorders.orderno,
			debtorsmaster.name,
			debtorsmaster.address1,
			debtorsmaster.address2,
			debtorsmaster.address3,
			debtorsmaster.address4,
			debtorsmaster.address5,
			debtorsmaster.address6,
                        debtorsmaster.taxref,
                        debtorsmaster.currcode,
                        debtorsmasteraux.numcta,
                        debtorsmasteraux.metpgo,
                        debtorsmasteraux.forpgo,
                        debtorsmasteraux.usocfd,
			shippers.shippername,
			salesorders.printedpackingslip,
			salesorders.datepackingslipprinted,
			locations.locationname,
                        currencies.currency,
                        currencies.currabrev
		FROM salesorders 
                INNER JOIN debtorsmaster ON salesorders.debtorno=debtorsmaster.debtorno
		INNER JOIN shippers ON salesorders.shipvia=shippers.shipper_id
		INNER JOIN locations ON salesorders.fromstkloc=locations.loccode
		INNER JOIN locationusers ON locationusers.loccode=locations.loccode AND locationusers.userid='" . $_SESSION['UserID'] . "' AND locationusers.canview=1
                LEFT JOIN debtorsmasteraux ON debtorsmaster.debtorno = debtorsmasteraux.debtorno
                INNER JOIN currencies ON debtorsmaster.currcode=currencies.currabrev
		WHERE salesorders.orderno='" . $_GET['TransNo'] . "'";

    $result = DB_query($sql, $ErrMsg);
    $myrow = DB_fetch_array($result);

    $Page_Width = 612;
    $Page_Height = 792;
    $Top_Margin = 0;
    $Bottom_Margin = 30;
    $Left_Margin = 30;
    $Right_Margin = 25;
    $PageSize = array(0, 0, $Page_Width, $Page_Height);

    ob_end_clean();
    $pdf = new Cpdf($PageSize);
    $pdf->addInfo('Creator', 'webERP http://www.weberp.org');
    $pdf->addInfo('Author', 'webERP ' . $Version);

    $pdf->addInfo('Title', _('Sales Invoice') . ' ' . $FromTransNo . ' to ' . $_POST['ToTransNo']);
    $pdf->addInfo('Subject', _('Invoices from') . ' ' . $FromTransNo . ' ' . _('to') . ' ' . $_POST['ToTransNo']);

    $pdf->setAutoPageBreak(0);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->AddPage();
    $pdf->cMargin = 0;

    $FirstPage = true;
    $line_height = 16;

    $FontSize = 10;
    $PageNumber = 1;
    
    $pdf->SetFont('helvetica', 'N', 20);
    $pdf->SetDrawColor(255, 90, 0);
    $pdf->SetLineWidth(2);

    include('includes/CFDINotaPageHeader.inc');

    $sql = "SELECT stkcode,
							stockmaster.description,
							stockmaster.volume,
							stockmaster.grossweight,
							stockmaster.decimalplaces,
							stockmaster.mbflag,
							stockmaster.units,
							stockmaster.discountcategory,
							stockmaster.controlled,
							stockmaster.serialised,
                                                        stockmaster.categoryid,
							unitprice,
							quantity,
							discountpercent,
							actualdispatchdate,
							qtyinvoiced,
							itemdue,
							poline,
							narrative
						FROM salesorderdetails INNER JOIN stockmaster
						ON salesorderdetails.stkcode = stockmaster.stockid
						WHERE orderno ='" . $_GET['TransNo'] . "'";

    $result = DB_query($sql, $db);
    $Total = 0;

    while ($myrow2 = DB_fetch_array($result)) {
        $sql_fracc = 'SELECT c_ClaveProdServ FROM stockcategory_aux WHERE categoryid = "' . $myrow2["categoryid"] . '"';
        $res_fracc = DB_query($sql_fracc, $db);
        $row_fracc = DB_fetch_array($res_fracc);

        $LeftOvers = $pdf->addTextWrap($Left_Margin+6, $YPos, 50, $FontSize, $myrow2['quantity'] . ' ' . $myrow2['units'], 'right');

        $LeftOvers = $pdf->addTextWrap($Left_Margin + 60, $YPos, 60, $FontSize, $row_fracc['c_ClaveProdServ'], 'centre');
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 125, $YPos, 260, $FontSize, $myrow2['description'], 'left');
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 380, $YPos, 96, $FontSize, number_format($myrow2['unitprice'], 2), 'right');
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos, 120, $FontSize, number_format($myrow2['unitprice'] * $myrow2['quantity'], 2), 'right');

        $Total += ($myrow2['quantity'] * $myrow2['unitprice']);
        $YPos -= ($line_height);
    }

    $YPos -= $line_height;

    //imprimir lineas
    $pdf->line($Left_Margin + 60, $TopOfColHeadings + 4, $Left_Margin + 60, $Bottom_Margin + (14 * $line_height));
    $pdf->line($Left_Margin + 120, $TopOfColHeadings + 4, $Left_Margin + 120, $Bottom_Margin + (14 * $line_height));
    $pdf->line($Left_Margin + 400, $TopOfColHeadings + 4, $Left_Margin + 400, $Bottom_Margin + (14 * $line_height));
    $pdf->line($Left_Margin + 475, $TopOfColHeadings + 4, $Left_Margin + 475, $Bottom_Margin + (14 * $line_height));
    $pdf->line($Left_Margin, $Bottom_Margin + (14 * $line_height), $Page_Width - $Right_Margin - 8, $Bottom_Margin + (14 * $line_height));
    $YPos = $Bottom_Margin + (13 * $line_height);

    //datos
    $YPos = $Bottom_Margin + (13 * $line_height);

    $pdf->addText($Page_Width - $Right_Margin - 220, $YPos + 12, $FontSize, _('Sub Total'));
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos + 2, 120, $FontSize, number_format($Total, 2), 'right');

    $pdf->addText($Page_Width - $Right_Margin - 220, $YPos - (2 * $line_height) + 31, $FontSize, _('I.V.A.'));
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos - (2 * $line_height) + 21, 120, $FontSize, number_format(($Total*.16), 2), 'right');

    $pdf->line($Page_Width - $Right_Margin - 222, $YPos - (2 * $line_height) + 15, $Page_Width - $Right_Margin - 8, $YPos - (2 * $line_height) + 15);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos - (2 * $line_height), 120, $FontSize, $signo . $DisplayTotal, 'right');
    $pdf->line($Page_Width - $Right_Margin - 222, $YPos + $line_height, $Page_Width - $Right_Margin - 222, $Bottom_Margin + (11 * $line_height) - 10);

    $Total = $Total*1.16;
    $YPos+=10;
    $pdf->addText($Page_Width - $Right_Margin - 220, $YPos - ($line_height * 3) + 16, $FontSize, _('TOTAL'));
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos + 5 - (3 * $line_height), 120, $FontSize, number_format($Total, 2), 'right');

    $nw = new Numbers_Words();
    $AmountWords = ucfirst($nw->toWords(abs(intval($Total)), 'es_MX'));

    $AmountWords .= ' ' . $myrow['currabrev'] . ' ' . substr(number_format(abs($Total - intval($Total)), 2), 2) . ('/100');
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 15, 340, $FontSize, '' . $AmountWords, 'left');
    if (strlen($LeftOvers) > 0) {
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 15 - 12, 350, $FontSize, $LeftOvers, 'left');
    }






    $pdf->OutputD('NotaCargo_' . $myrow['orderno'] . '.pdf');
    $pdf->__destruct();
    exit;
} else {

    echo '<br><br><h1 align="center">Seleccione un pedido para generar nota de cargo</h1><br><br>';
    $SQL = "SELECT salesorders.orderno,
                    debtorsmaster.name,
                    custbranch.brname,
                    salesorders.customerref,
                    salesorders.orddate,
                    salesorders.deliverydate,
                    salesorders.deliverto,
                    salesorders.printedpackingslip,
                    salesorders.poplaced,
                    SUM(salesorderdetails.unitprice*(salesorderdetails.quantity-salesorderdetails.qtyinvoiced)*(1-salesorderdetails.discountpercent)/currencies.rate) AS ordervalue
                FROM salesorders INNER JOIN salesorderdetails
                    ON salesorders.orderno = salesorderdetails.orderno
                    INNER JOIN debtorsmaster
                    ON salesorders.debtorno = debtorsmaster.debtorno
                    INNER JOIN custbranch
                    ON debtorsmaster.debtorno = custbranch.debtorno
                    AND salesorders.branchcode = custbranch.branchcode
                    INNER JOIN currencies
                    ON debtorsmaster.currcode = currencies.currabrev
                    WHERE salesorderdetails.completed=0 AND salesorders.quotation =0
                GROUP BY salesorders.orderno,
                    debtorsmaster.name,
                    custbranch.brname,
                    salesorders.customerref,
                    salesorders.orddate,
                    salesorders.deliverydate,
                    salesorders.deliverto,
                    salesorders.printedpackingslip,
                    salesorders.poplaced
                ORDER BY salesorders.orderno";

    $SalesOrdersResult = DB_query($SQL, $ErrMsg);

    $TableHeader = '<tr>
                <th class="ascending" >' . _('Pedido') . '</th>
                <th>' . _('Imprimir') . '</th>
                <th class="ascending" >' . _('Customer') . '</th>
                <th class="ascending" >' . _('Branch') . '</th>
                <th class="ascending" >' . _('Cust Order') . ' #</th>
                <th class="ascending" >' . _('Order Date') . '</th>
                <th class="ascending" >' . _('Req Del Date') . '</th>
                <th class="ascending" >' . _('Delivery To') . '</th>
                <th class="ascending" >' . _('Order Total') . '<br />' . $_SESSION['CompanyRecord']['currencydefault'] . '</th>';

    echo '<table cellpadding="2" width="95%" class="selection">';
    echo $TableHeader;

    while ($myrow = DB_fetch_array($SalesOrdersResult)) {

        if ($k == 1) {
            echo '<tr class="EvenTableRows">';
            $k = 0;
        } else {
            echo '<tr class="OddTableRows">';
            $k++;
        }

        printf('<td>%s</td>
                <td><a target="_blank" href="%s">' . $PrintText . ' <img src="' . $RootPath . '/css/' . $Theme . '/images/pdf.png" title="' . _('Click for PDF') . '" alt="" /></a></td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td class="number">%s</td>
                </tr>', $myrow['orderno'], $RootPath . '/nota_cargo.php?TransNo=' . $myrow['orderno'], $myrow['name'], $myrow['brname'], $myrow['customerref'], ConvertSQLDate($myrow['orddate']), ConvertSQLDate($myrow['deliverydate']), html_entity_decode($myrow['deliverto'], ENT_QUOTES, 'UTF-8'), locale_number_format($myrow['ordervalue'], $_SESSION['CompanyRecord']['decimalplaces']));
    }
    echo '</table><br><br><br>';
}

include('includes/footer.php');
