<?php
//líneas 131-133,193-195,232-243//
/* $Id: PrintCustTrans.php 5399 2012-05-26 10:46:05Z daintree $ */
$PageSecurity = 1;

//ini_set('display_errors', 0);
//error_reporting(0);
ini_set("session.auto_start", 0);

include('includes/session.php');
include('Numbers/Words.php');
include('includes/phpqrcode/qrlib.php');

if (isset($_GET['FromTransNo'])) {
    $FromTransNo = trim($_GET['FromTransNo']);
} elseif (isset($_POST['FromTransNo'])) {
    $FromTransNo = filter_number_format($_POST['FromTransNo']);
} else {
    $FromTransNo = '';
}

if (isset($_GET['InvOrCredit'])) {
    $InvOrCredit = $_GET['InvOrCredit'];
} elseif (isset($_POST['InvOrCredit'])) {
    $InvOrCredit = $_POST['InvOrCredit'];
}

if (isset($_GET['PrintPDF'])) {
    $PrintPDF = TRUE;
} elseif (isset($_POST['PrintPDF'])) {
    $PrintPDF = TRUE;
}

if (!isset($_POST['ToTransNo'])
        OR trim($_POST['ToTransNo']) == ''
        OR filter_number_format($_POST['ToTransNo']) < $FromTransNo) {

    $_POST['ToTransNo'] = $FromTransNo;
}

//Si ya fué cancelada, no imprimir nada.
$sql_canceladas = "SELECT transno,type FROM debtortrans WHERE transno like '" . $FromTransNo . "'";
$result_canceladas = DB_query($sql_canceladas, $db, '', '', false, false);  
if (DB_num_rows($result_canceladas) > 1) {
    while ($myrow = DB_fetch_array($result_canceladas)) {
        if ($myrow['type'] == 15) {
            $FactNum = ltrim(substr($FromTransNo, 1, 6), '0');
            if (!file_exists('SAT/facturasTimbradas/canceladas/c_' . $FactNum . '.pdf')) {
                echo '<br><br><h1 align="center">La factura numero ' . $FromTransNo . ' esta cancelada</h1>';
                exit;
            } else {
                header('Location: SAT/facturasTimbradas/canceladas/c_' . $FactNum . '.pdf');
            }
        }
    }
}

$FirstTrans = $FromTransNo; /* Need to start a new page only on subsequent transactions */

if (isset($PrintPDF) OR isset($_GET['PrintPDF'])
        AND $PrintPDF
        AND isset($FromTransNo)
        AND isset($InvOrCredit)
        AND $FromTransNo != '') {

    include ('includes/class.pdf.php');

    /* This invoice is hard coded for A4 Landscape invoices or credit notes so can't use PDFStarter.inc */

    $Page_Width = 612;
    $Page_Height = 792;
    $Top_Margin = 0;
    $Bottom_Margin = 30;
    $Left_Margin = 30;
    $Right_Margin = 25;

    $PageSize = array(0, 0, $Page_Width, $Page_Height);

    $pdf = new Cpdf($PageSize);
    $pdf->addInfo('Creator', 'webERP http://www.weberp.org');
    $pdf->addInfo('Author', 'webERP ' . $Version);
    
    $pdf->addTTFfont('includes/tcpdf/tools/DINPro-Regular_13937.ttf', 'TrueTypeUnicode', '', 32);
    
    
//    $pdf->defaultFont('DINPro.otf');
//    $pdf->selectFont('fonts/DINPro.otf');
//    $pdf->AddFont('fonts/DINPro.otf');
//    $pdf->SetFont('fonts/DINPro.otf');

    if ($InvOrCredit == 'Invoice') {
        $pdf->addInfo('Title', _('Sales Invoice') . ' ' . $FromTransNo . ' to ' . $_POST['ToTransNo']);
        $pdf->addInfo('Subject', _('Invoices from') . ' ' . $FromTransNo . ' ' . _('to') . ' ' . $_POST['ToTransNo']);
    } else {
        $pdf->addInfo('Title', _('Sales Credit Note'));
        $pdf->addInfo('Subject', _('Credit Notes from') . ' ' . $FromTransNo . ' ' . _('to') . ' ' . $_POST['ToTransNo']);
    }

    $pdf->setAutoPageBreak(0);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->AddPage();
    $pdf->cMargin = 0;
    /* END Brought from class.pdf.php constructor */

    $FirstPage = true;
    $line_height = 16;

    while ($FromTransNo <= filter_number_format($_POST['ToTransNo'])) {

        /* retrieve the invoice details from the database to print
          notice that salesorder record must be present to print the invoice purging of sales orders will
          nobble the invoice reprints */

        if ($InvOrCredit == 'Invoice') {
            $sql = "SELECT debtortrans.ovamount,
							debtortrans.ovdiscount,
							debtortrans.ovfreight,
							debtortrans.ovgst,
							debtortrans.rate,
							debtortrans.inputdate,
							debtortrans.invtext,
							debtortrans.consignment,
                                                        gltransaux.UUID,
                                                        gltransaux.FechaTimbrado,
                                                        gltransaux.selloCFD,
                                                        gltransaux.noCertificadoSAT,
                                                        gltransaux.selloSAT,
                                                        gltransaux.cerEmisor,
                                                        gltransaux.fechaFactura,
							debtorsmaster.name,
							debtorsmaster.address1,
							debtorsmaster.address2,
							debtorsmaster.address3,
							debtorsmaster.address4,
							debtorsmaster.address5,
							debtorsmaster.address6,
							debtorsmaster.currcode,
							debtorsmaster.invaddrbranch,
							debtorsmaster.taxref,
							debtorsmasteraux.numcta,
                                                        debtorsmasteraux.metpgo,
                                                        debtorsmasteraux.forpgo,
							paymentterms.terms,
							salesorders.deliverto,
							salesorders.deladd1,
							salesorders.deladd2,
							salesorders.deladd3,
							salesorders.deladd4,
							salesorders.deladd5,
							salesorders.deladd6,
							salesorders.customerref,
							salesorders.orderno,
							salesorders.orddate,
							locations.locationname,
							shippers.shippername,
							custbranch.brname,
							custbranch.braddress1,
							custbranch.braddress2,
							custbranch.braddress3,
							custbranch.braddress4,
							custbranch.braddress5,
							custbranch.braddress6,
							custbranch.brpostaddr1,
							custbranch.brpostaddr2,
							custbranch.brpostaddr3,
							custbranch.brpostaddr4,
							custbranch.brpostaddr5,
							custbranch.brpostaddr6,
							salesman.salesmanname,
							debtortrans.debtorno,
							debtortrans.branchcode,
							currencies.decimalplaces,
				currencies.currency,
                                currencies.currabrev,
				gltransaux.sello,
				gltransaux.cadena,
                                gltransaux.CadenaOriginalTFD,
                                c_FormaPago.Descripción
						FROM debtortrans INNER JOIN debtorsmaster
						ON debtortrans.debtorno=debtorsmaster.debtorno
						INNER JOIN custbranch
						ON debtortrans.debtorno=custbranch.debtorno
						AND debtortrans.branchcode=custbranch.branchcode
						INNER JOIN salesorders
						ON debtortrans.order_ = salesorders.orderno
						INNER JOIN shippers
						ON debtortrans.shipvia=shippers.shipper_id
						INNER JOIN salesman
						ON custbranch.salesman=salesman.salesmancode
						INNER JOIN locations
						ON salesorders.fromstkloc=locations.loccode
						INNER JOIN paymentterms
						ON debtorsmaster.paymentterms=paymentterms.termsindicator
						INNER JOIN currencies
						ON debtorsmaster.currcode=currencies.currabrev
                                                INNER JOIN gltransaux
                                                ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
                                                LEFT JOIN debtorsmasteraux
                                                ON debtorsmaster.debtorno = debtorsmasteraux.debtorno
                                                LEFT JOIN c_FormaPago
                                                ON debtorsmasteraux.metpgo = c_FormaPago.c_FormaPago
						WHERE debtortrans.type=10
						AND debtortrans.transno='" . $FromTransNo . "'";

            if (isset($_POST['PrintEDI']) AND $_POST['PrintEDI'] == 'No') {
                $sql = $sql . " AND debtorsmaster.ediinvoices=0";
            }
             //leer xml de SAT
            $file = 'SAT/facturasTimbradas/fac_A' . ltrim(ltrim($FromTransNo, '1'),'0') . '.xml';
            $texto = file_get_contents('SAT/facturasTimbradas/fac_A' . ltrim(ltrim($FromTransNo, '1'),'0') . '.xml');
            $xml = new DOMDocument();
            $ok = $xml->loadXML($texto);
            if (!$ok) {
                display_xml_errors();
                die();
            }
            $xp = new DOMXpath($xml);
            if (!$xml->getElementsByTagName("StampErrors")->item(0)) {
                $data['fecha'] = getpath("//@Fecha");
                $data['cerEmisor'] = getpath("//@NoCertificado");
                $data['FechaTimbrado'] = getpath("//@FechaTimbrado");
                $data['selloCFD'] = getpath("//@SelloCFD");
                $data['UUID'] = getpath("//@UUID");
                $data['noCertificadoSAT'] = getpath("//@NoCertificadoSAT");
                $data['selloSAT'] = getpath("//@SelloSAT");
                $data['FechaTimbrado'] = getpath("//@FechaTimbrado");
                $data['Total'] = getpath("//@Total");
                $data['RFC'] = getpath("//@Rfc");
                $data['FormaPago'] = getpath("//@FormaPago");
                $data['MetodoPago'] = getpath("//@MetodoPago");
                $data['UsoCFDI'] = getpath("//@UsoCFDI");
                $data['TipoCambio'] = getpath("//@TipoCambio");       
                $CadenaOriginalTFD = '||1.0|' . $data['UUID'] . '|' . $data['FechaTimbrado'] . '|' . $data['selloCFD'] . '|' . $data['noCertificadoSAT'] . '||';

        } else {
            $data['ErrorCode'] = getpath("//@ErrorCode");
            $data['ErrorType'] = getpath("//@ErrorType");
            $data['Description'] = $xml->getElementsByTagName("Description")->item(0)->nodeValue;

            echo "<h2 align='center'>Error al timbrar la factura número " . $arr['folio'] . "</h2><br>";
            echo '<h2 align="center">Código de error:' . $data["ErrorCode"] . '<br>  Tipo de error:' . $data["ErrorType"] . '</h2><br>
                     <div align="center"><p align="center" style="width:50%;">Descripción:' . $data["Description"] . '</p></div>';
            echo '<a href="' . $_SERVER['PHP_SELF'] . '"><h1 align="center">Regresar</h1></a>';
            die();
        }
           
            
        } else {
            $sql = "SELECT debtortrans.trandate,
							debtortrans.ovamount,
							debtortrans.ovdiscount,
							debtortrans.ovfreight,
							debtortrans.ovgst,
							debtortrans.rate,
							debtortrans.inputdate,
							debtortrans.invtext,
                                                        gltransaux.UUID,
                                                        gltransaux.FechaTimbrado,
                                                        gltransaux.selloCFD,
                                                        gltransaux.noCertificadoSAT,
                                                        gltransaux.selloSAT,
							debtorsmaster.invaddrbranch,
							debtorsmaster.name,
							debtorsmaster.address1,
							debtorsmaster.address2,
							debtorsmaster.address3,
							debtorsmaster.address4,
							debtorsmaster.address5,
							debtorsmaster.address6,
							debtorsmaster.currcode,
							debtorsmaster.taxref,
							debtorsmasteraux.numcta,
                                                        debtorsmasteraux.metpgo,
                                                        debtorsmasteraux.forpgo,
							custbranch.brname,
							custbranch.braddress1,
							custbranch.braddress2,
							custbranch.braddress3,
							custbranch.braddress4,
							custbranch.braddress5,
							custbranch.braddress6,
							custbranch.brpostaddr1,
							custbranch.brpostaddr2,
							custbranch.brpostaddr3,
							custbranch.brpostaddr4,
							custbranch.brpostaddr5,
							custbranch.brpostaddr6,
							salesman.salesmanname,
							debtortrans.debtorno,
							debtortrans.branchcode,
							paymentterms.terms,
							currencies.decimalplaces,
				currencies.currency,
                                currencies.currabrev,
				gltransaux.sello,
				gltransaux.cadena,
                                gltransaux.CadenaOriginalTFD,
                                c_FormaPago.Descripción
						FROM debtortrans INNER JOIN debtorsmaster
						ON debtortrans.debtorno=debtorsmaster.debtorno
						INNER JOIN custbranch
						ON debtortrans.debtorno=custbranch.debtorno
						AND debtortrans.branchcode=custbranch.branchcode
						INNER JOIN salesman
						ON custbranch.salesman=salesman.salesmancode
						INNER JOIN paymentterms
						ON debtorsmaster.paymentterms=paymentterms.termsindicator
						INNER JOIN currencies
						ON debtorsmaster.currcode=currencies.currabrev
                                                INNER JOIN gltransaux
                                                ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
                                                LEFT JOIN debtorsmasteraux
                                                ON debtorsmaster.debtorno = debtorsmasteraux.debtorno
                                                LEFT JOIN c_FormaPago
                                                ON debtorsmasteraux.metpgo = c_FormaPago.c_FormaPago
						WHERE debtortrans.type=11
						AND debtortrans.transno='" . $FromTransNo . "'";

            if (isset($_POST['PrintEDI']) AND $_POST['PrintEDI'] == 'No') {
                $sql = $sql . " AND debtorsmaster.ediinvoices=0";
            }
        } // end else

        $result = DB_query($sql, $db, '', '', false, false);

        if (DB_error_no($db) != 0) {
            $Title = _('Transaction Print Error Report');
            include ('includes/header.php');
            prnMsg(_('There was a problem retrieving the invoice or credit note details for note number') . ' ' . $InvoiceToPrint . ' ' . _('from the database') . '. ' . _('To print an invoice, the sales order record, the customer transaction record and the branch record for the customer must not have been purged') . '. ' . _('To print a credit note only requires the customer, transaction, salesman and branch records be available'), 'error');
            if ($debug == 1) {
                prnMsg(_('The SQL used to get this information that failed was') . '<br />' . $sql, 'error');
            }
            include ('includes/footer.php');
            exit;
        }
        if (DB_num_rows($result) == 1) {
            $myrow = DB_fetch_array($result);
            $ExchRate = $myrow['rate'];
            if ($InvOrCredit == 'Invoice') {

                //si no está sellada la factura, no imprimir
                if (($myrow['UUID'] == NULL) or ( $myrow['sello'] == 'NULL')) {
                    echo '<br><br><h1 align="center">La factura ' . substr($FromTransNo, 1, 6) . ' no ha sido sellada</h1>';
                    echo '<a href="' . $_SERVER['PHP_SELF'] . '"><h2 align="center">Regresar</h2></a>';
                    die();
                }

                /* primero ver si tiene movimientos de lotes controlados */
                $sql = 'SELECT 	stockserialmoves.serialno,stockmoves.stkmoveno
			FROM 	stockmoves,stockserialmoves
			WHERE 	stockmoves.transno=' . $FromTransNo . '
			AND 	stockmoves.stkmoveno=stockserialmoves.stockmoveno';

                $result = DB_query($sql, $db);
                if (DB_num_rows($result) > 0) {
                    for ($i = 0; $i <= DB_num_rows($result); $i++) {
                        $lotes[$i] = DB_fetch_array($result);
                    }
                }

                $sql = "SELECT stockmoves.stockid,
								stockmaster.description,
								-stockmoves.qty as quantity,
								stockmoves.discountpercent,
								((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . "* -stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces,
					stockmaster.categoryid
							FROM stockmoves INNER JOIN stockmaster
							ON stockmoves.stockid = stockmaster.stockid
							WHERE stockmoves.type=10
							AND stockmoves.transno=" . $FromTransNo . "
							AND stockmoves.show_on_inv_crds=1";
            } else {
                /* only credit notes to be retrieved */
                $sql = "SELECT stockmoves.stockid,
								stockmaster.description,
								stockmoves.qty as quantity,
								stockmoves.discountpercent,
								((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . " * stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces,
					stockmaster.categoryid
							FROM stockmoves INNER JOIN stockmaster
							ON stockmoves.stockid = stockmaster.stockid
							WHERE stockmoves.type=11
							AND stockmoves.transno=" . $FromTransNo . "
							AND stockmoves.show_on_inv_crds=1";
            } // end else

            $result = DB_query($sql, $db);
            if (DB_error_no($db) != 0) {
                $Title = _('Transaction Print Error Re$foliosport');
                include ('includes/header.php');
                echo '<br />' . _('There was a problem retrieving the invoice or credit note stock movement details for invoice number') . ' ' . $FromTransNo . ' ' . _('from the database');
                if ($debug == 1) {
                    echo '<br />' . _('The SQL used to get this information that failed was') . '<br />' . $sql;
                }
                include('includes/footer.php');
                exit;
            }

            if (DB_num_rows($result) > 0) {

                //datos folio
                if (strlen($FromTransNo) > 6) {
                    $numero = substr($FromTransNo, 1, 6);
                } else {
                    $numero = $FromTransNo;
                }

//                $sql_folio = 'SELECT * FROM folios WHERE serie = "A" AND folioIni <= ' . $numero . ' AND folioFin >= ' . $numero . '';
//                $res_folio = DB_query($sql_folio, $db);
//                if ($folios = DB_fetch_array($res_folio)) {
//                    $noAprobacion = $folios['noAprobacion'];
//                    $anoAprobacion = $folios['anoAprobacion'];
//                    $noCertificado = $folios['noCertificado'];
//                    $file_sat_key = 'SAT/' . $folios['keyfile'] . '';
//                    $file_sat_cer = 'SAT/' . $folios['cerfile'] . '';
//                } else {
//                    echo '<h1 align="center">No existe la aprobacion de este numero de folio</h1>';
//                    exit();
//                }

                $FontSize = 10;
                $PageNumber = 1;

                include('includes/CFDITransPageHeader.php');
                $FirstPage = False;
                while ($myrow2 = DB_fetch_array($result)) {
                    $sql_fracc = 'SELECT c_ClaveProdServ FROM stockcategory_aux WHERE categoryid = "'.$myrow2["categoryid"].'"';
                    $res_fracc = DB_query($sql_fracc, $db);
                    $row_fracc = DB_fetch_array($res_fracc);
                    
                    switch ($myrow2['decimalplaces']) {
                        case 0:
                            $DisplayQty = number_format($myrow2['quantity'], 0);
                            $DisplayPrice = number_format($myrow2['fxprice'], 2);
                            break;
                        case 1:
                            $DisplayQty = number_format($myrow2['quantity'], 1);
                            $DisplayPrice = number_format($myrow2['fxprice'], 2);
                            break;
                        case 2:
                            $DisplayQty = number_format($myrow2['quantity'], 2);
                            $DisplayPrice = number_format($myrow2['fxprice'], 2);
                            break;
                        case 3:
                            $DisplayQty = number_format($myrow2['quantity'], 3);
                            $DisplayPrice = number_format($myrow2['fxprice'], $myrow['decimalplaces']);
                            break;
                    }

                    $DisplayNet = number_format($myrow2['fxnet'], 2);

                    if ($myrow2['discountpercent'] == 0) {
                        $DisplayDiscount = '';
                    } else {
                        $DisplayDiscount = number_format($myrow2['discountpercent'] * 100, 2) . '%';
                    }

                    $LeftOvers = $pdf->addTextWrap($Left_Margin, $YPos, 60, $FontSize, $DisplayQty . ' ' . $myrow2['units'], 'right');

                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 60, $YPos, 60, $FontSize, $row_fracc['c_ClaveProdServ'], 'centre');
                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 125, $YPos, 260, $FontSize, $myrow2['description'],'left');
                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 375, $YPos, 96, $FontSize, $DisplayPrice, 'right');
                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos, 120, $FontSize, $DisplayNet, 'right');


//					$LeftOvers = $pdf->addTextWrap($Left_Margin+3,$YPos,95,$FontSize,$myrow2['stockid']);
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+100,$YPos,123,$FontSize,$myrow2['description']);
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+353,$YPos,96,$FontSize,$DisplayPrice,'right');
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+453,$YPos,95,$FontSize,$DisplayQty,'right');
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+553,$YPos,35,$FontSize,$myrow2['units'],'centre');
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+590,$YPos,50,$FontSize,$DisplayDiscount,'right');
//					$LeftOvers = $pdf->addTextWrap($Left_Margin+642,$YPos,120,$FontSize,$DisplayNet,'right');

                    $YPos -= ($line_height);

                    $lines = explode('\r\n', htmlspecialchars_decode($myrow2['narrative']));
                    for ($i = 0; $i < sizeOf($lines); $i++) {
                        while (mb_strlen($lines[$i]) > 1) {
                            if ($YPos - $line_height <= $Bottom_Margin) {
                                /* head up a new invoice/credit note page */
                                /* draw the vertical column lines right to the bottom */
                                PrintLinesToBottom();
                                include ('includes/CFDITransPageHeader.php');
                            } //end if need a new page headed up

                            /* increment a line down for the next line item */
                            if (mb_strlen($lines[$i]) > 1) {
                                $lines[$i] = $pdf->addTextWrap($Left_Margin + 100, $YPos, 245, $FontSize, stripslashes($lines[$i]),'left');
                            }
                            $YPos -= ($line_height);
                        }
                    } //end for loop around lines of narrative to display
                    if ($YPos <= $Bottom_Margin) {

                        /* head up a new invoice/credit note page */
                        /* draw the vertical column lines right to the bottom */
                        PrintLinesToBottom();
                        include ('includes/CFDITransPageHeader.php');
                    } //end if need a new page headed up
                } //end while there invoice are line items to print out
            } /* end if there are stock movements to show on the invoice or credit note */

            $YPos -= $line_height;
            $pdf->SetLineWidth(1);
            /* check to see enough space left to print the 4 lines for the totals/footer */
            if (($YPos - $Bottom_Margin) < (2 * $line_height)) {
                PrintLinesToBottom();
                include ('includes/CFDITransPageHeader.php');
            }
            /* Print a column vertical line  with enough space for the footer */
            /* draw the vertical column lines to 4 lines shy of the bottom to leave space for invoice footer info ie totals etc */

            $pdf->line($Left_Margin + 60, $TopOfColHeadings + 4, $Left_Margin + 60, $Bottom_Margin + (14 * $line_height));

            /* Print a column vertical line */
            $pdf->line($Left_Margin + 120, $TopOfColHeadings + 4, $Left_Margin + 120, $Bottom_Margin + (14 * $line_height));

            /* Print a column vertical line */
            $pdf->line($Left_Margin + 400, $TopOfColHeadings + 4, $Left_Margin + 400, $Bottom_Margin + (14 * $line_height));

            /* Print a column vertical line */
            $pdf->line($Left_Margin + 475, $TopOfColHeadings + 4, $Left_Margin + 475, $Bottom_Margin + (14 * $line_height));

            /* Print a column vertical line */
//		$pdf->line($Left_Margin+587, $TopOfColHeadings+12,$Left_Margin+587,$Bottom_Margin+(4*$line_height));
//		$pdf->line($Left_Margin+640, $TopOfColHeadings+12,$Left_Margin+640,$Bottom_Margin+(4*$line_height));

            $pdf->SetLineWidth(2);
            /* Rule off at bottom of the vertical lines */
            $pdf->line($Left_Margin, $Bottom_Margin + (14 * $line_height), $Page_Width - $Right_Margin - 8, $Bottom_Margin + (14 * $line_height));


            /* Now print out the footer and totals */
            $pdf->SetLineWidth(1);
            if ($InvOrCredit == 'Invoice') {

                $DisplaySubTot = number_format($myrow['ovamount'], 2);
                $DisplayFreight = number_format($myrow['ovfreight'], 2);
                $DisplayTax = number_format($myrow['ovgst'], 2);
                $DisplayTotal = number_format($myrow['ovfreight'] + $myrow['ovgst'] + $myrow['ovamount'], 2);
            } else {

                $DisplaySubTot = number_format(-$myrow['ovamount'], 2);
                $DisplayFreight = number_format(-$myrow['ovfreight'], 2);
                $DisplayTax = number_format(-$myrow['ovgst'], 2);
                $DisplayTotal = number_format(-$myrow['ovfreight'] - $myrow['ovgst'] - $myrow['ovamount'], 2);
            }
            /* Print out the invoice text entered */
            $YPos = $Bottom_Margin + (13 * $line_height);

            /* Print out the payment terms */
//			$pdf->addTextWrap($Left_Margin+5,$YPos+3,280,$FontSize,_('Payment Terms') . ': ' . $myrow['terms']);
            //      $pdf->addText($Page_Width-$Right_Margin-392, $YPos - ($line_height*3)+22,$FontSize, _('Bank Code:***** Bank Account:*****'));
            //	$FontSize=10;

            $FontSize = 8;
           $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos + 55 , 275, $FontSize, $myrow['invtext']);
            if (strlen($LeftOvers) > 0) {
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos + 55 - 12, 275, $FontSize, $LeftOvers);
                if (strlen($LeftOvers) > 0) {
                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos + 55 - 24, 275, $FontSize, $LeftOvers);
                    /* If there is some of the InvText leftover after 3 lines 200 wide then it is not printed :( */
                }
            }
            $FontSize = 10;
            if ($myrow['currabrev'] == 'EUR') {
                $signo = '€ ';
            } else {
                $signo = '$ ';
            }

            $pdf->SetFont('helvetica', 'B', 20);
            $pdf->addText($Page_Width - $Right_Margin - 220, $YPos + 12, $FontSize, _('Sub Total:'));
            $pdf->addText($Page_Width - $Right_Margin - 220, $YPos - (2 * $line_height) + 31, $FontSize, _('I.V.A.:'));
            $pdf->SetFont('helvetica', 'N', 20);
            
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos + 2, 120, $FontSize, $signo . $DisplaySubTot, 'right');

//		$pdf->addText($Page_Width-$Right_Margin-220, $YPos-$line_height+5,$FontSize, _('Freight'));
//		$LeftOvers = $pdf->addTextWrap($Left_Margin+425,$YPos-$line_height+5,120,$FontSize,$DisplayFreight, 'right');


            $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos - (2 * $line_height) + 21, 120, $FontSize, $signo . $DisplayTax, 'right');

            /* rule off for total */
            $pdf->line($Page_Width - $Right_Margin - 222, $YPos - (2 * $line_height) + 15, $Page_Width - $Right_Margin - 8, $YPos - (2 * $line_height) + 15);
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos - (2 * $line_height), 120, $FontSize, $signo . $DisplayTotal, 'right');

            /* vertical to separate totals from comments and ROMALPA */
            $pdf->line($Page_Width - $Right_Margin - 222, $YPos + $line_height, $Page_Width - $Right_Margin - 222, $Bottom_Margin + (11 * $line_height) - 10);

            $YPos+=10;
            if ($InvOrCredit == 'Invoice') {
                $pdf->SetFont('helvetica', 'B', 20);
                $pdf->addText($Page_Width - $Right_Margin - 220, $YPos - ($line_height * 3) + 16, $FontSize, _('TOTAL INVOICE'));
                $pdf->SetFont('helvetica', 'N', 20);
                $FontSize = 9;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 425, $YPos - ($line_height * 3), 245, $FontSize, $_SESSION['RomalpaClause']);
                while (strlen($LeftOvers) > 0 AND $YPos > $Bottom_Margin) {
                    $YPos-=14;
                    $LeftOvers = $pdf->addTextWrap($Left_Margin + 300, $YPos, 245, $FontSize, $LeftOvers);
                }

                /* Add Images for Visa / Mastercard / Paypal */
                if (file_exists('companies/' . $_SESSION['DatabaseName'] . '/payment.jpg')) {
                    $pdf->addJpegFromFile('companies/' . $_SESSION['DatabaseName'] . '/payment.jpg', $Page_Width / 2 - 280, $YPos - 20, 0, 40);
                }
                $pdf->addText($Page_Width - $Right_Margin - 472, $YPos - ($line_height * 3) + 32, $FontSize, '');
                $FontSize = 10;
            } else {
                $pdf->addText($Page_Width - $Right_Margin - 220, $YPos - ($line_height * 2) - 10, $FontSize, _('TOTAL CREDIT'));
            }
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 642, 35, 120, $FontSize, $DisplayTotal, 'right');

            /* en lugar de condiciones, ponere cantidad con letra */
            $TotalFactura = $myrow['ovfreight'] + $myrow['ovgst'] + $myrow['ovamount'];

            $pdf->SetFont('helvetica', 'B', 20);
            $pdf->addTextWrap($Left_Margin + 5, $YPos - 5, 280, $FontSize, 'Importe con letra:','left');
            $pdf->SetFont('helvetica', 'N', 20);

            $nw = new Numbers_Words();
            $AmountWords = ucfirst($nw->toWords(abs(intval($TotalFactura)), 'es_MX'));

            $AmountWords .= ' ' . $myrow['currabrev'] . ' ' . substr(number_format(abs($TotalFactura - intval($TotalFactura)), 2), 2) . ('/100');
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 20, 340, $FontSize, '' . $AmountWords,'left');
            if (strlen($LeftOvers) > 0) {
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 20 - 12, 350, $FontSize, $LeftOvers,'left');
            }
            $tipocambio = number_format((float)(1/$myrow['rate']), 4, '.', '');
            $pdf->addTextWrap($Left_Margin + 5, $YPos - 45, 280, $FontSize-2, '(Tipo de cambio:  '.$tipocambio.')','left');
        } /* end of check to see that there was an invoice record to print */

        $y = 0;
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 80, 300, $FontSize, 'Cadena original del complemento de certificación digital del SAT: ');
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 87, 535, $FontSize - 4, $myrow["CadenaOriginalTFD"]);
        while (strlen($LeftOvers) > 0) {
            $y+=7;
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 87 - $y, 550, $FontSize - 4, $LeftOvers);
        }

        if ($myrow['UUID'] != '') {
            $pdf->addText($Left_Margin + 150, $YPos - 53, $FontSize, 'Este documento es una representación impresa de un CFDI ');

            //  Generar código QR
            $cadena_qr = 'https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx';
            $cadena_qr.= '?&id=' . $myrow['UUID'] . '';
            $cadena_qr.= '&re=' . $_SESSION['CompanyRecord']['gstno'] .'';
            $cadena_qr.= '&rr=' . $myrow['taxref'] . '';
            $cadena_qr.= '&tt=' . number_format(($myrow['ovgst']) + ($myrow['ovamount']), 6, '.', '') . '';
            $cadena_qr.= '&fe=' . substr($data['selloCFD'],-8) . '';

            QRcode::png($cadena_qr, 'SAT/temp.png', QR_ECLEVEL_L, 3);

            $pdf->Image('SAT/temp.png', $x = $Left_Margin, $y = $Page_Height - 97, 125, 125);

            $FromTransNo++;
            $y = 0;
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 120, 350, $FontSize, 'Sello Digital del CFDI:','left');
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 220, $YPos - 120, 370, $FontSize - 4, $myrow['sello']);
            while (strlen($LeftOvers) > 0) {
                $y+=10;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 120 - $y, 430, $FontSize - 4, $LeftOvers);
            }

            $y = 0;
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 155, 350, $FontSize, 'Sello del SAT:','left');
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 190, $YPos - 155, 340, $FontSize - 4, $myrow['selloSAT']);
            while (strlen($LeftOvers) > 0) {
                $y+=10;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 155 - $y, 430, $FontSize - 4, $LeftOvers);
            }
//¡OJO! hay que poner en la base de datos en debtortrans el no de certificado sacado del xml cuando se timbra para la próxima revisión.
            $cadena_final = 'Este es un Comprobante Fiscal Digital Version 4.0 de tipo ingreso. El Emisor utilizo el Certificado No. ' . $myrow["cerEmisor"] . ' del CSD ';
            $cadena_final.= ' y fue timbrado el dia ' . $myrow["FechaTimbrado"] . '';
            $cadena_final.= ' usando el certificado del SAT No.' . $myrow["noCertificadoSAT"] . '';

            $y = 0;
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 195, 430, $FontSize, $cadena_final);
            while (strlen($LeftOvers) > 0) {
                $y+=10;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 120, $YPos - 195 - $y, 430, $FontSize, $LeftOvers);
            }
        } else {
            $pdf->addText($Left_Margin + 150, $YPos - 53, $FontSize, 'Este documento es la impresión de un comprobante fiscal digital');

            $LeftOvers = $pdf->addTextWrap($Left_Margin + 75, $YPos - 85, 470, $FontSize - 4, $myrow["cadena"]);
            while (strlen($LeftOvers) > 0) {
                $y+=10;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 85 - $y, 550, $FontSize - 4, $LeftOvers);
            }

            $FromTransNo++;
            $y = 0;
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 120, 350, $FontSize, 'Sello digital:');
            $LeftOvers = $pdf->addTextWrap($Left_Margin + 75, $YPos - 120, 470, $FontSize - 3, $myrow['sello']);
            while (strlen($LeftOvers) > 0) {
                $y+=10;
                $LeftOvers = $pdf->addTextWrap($Left_Margin + 75, $YPos - 120 - $y, 470, $FontSize - 3, $LeftOvers);
            }
        }
    } /* end loop to print invoices */

    // Have to get the TransNo again, GET[FromTransNo] is updated on each pass of loop
    if (isset($_GET['FromTransNo'])) {
        $FromTransNo = trim($_GET['FromTransNo']);
    } elseif (isset($_POST['FromTransNo'])) {
        $FromTransNo = filter_number_format($_POST['FromTransNo']);
    }


    if (isset($_GET['Email'])) { //email the invoice to address supplied
        include('includes/header.php');

        include ('includes/htmlMimeMail.php');
        $FileName = $_SESSION['reports_dir'] . '/' . $_SESSION['DatabaseName'] . '_' . $InvOrCredit . '_' . $_GET['FromTransNo'] . '.pdf';
        $pdf->Output($FileName, 'F');
        $mail = new htmlMimeMail();

        $Attachment = $mail->getFile($FileName);
        $mail->setText(_('Please find attached') . ' ' . $InvOrCredit . ' ' . $_GET['FromTransNo']);
        $mail->SetSubject($InvOrCredit . ' ' . $_GET['FromTransNo']);
        $mail->addAttachment($Attachment, $FileName, 'application/pdf');
        $mail->setFrom($_SESSION['CompanyRecord']['coyname'] . ' <' . $_SESSION['CompanyRecord']['email'] . '>');
        $result = $mail->send(array($_GET['Email']));

        unlink($FileName); //delete the temporary file

        $Title = _('Emailing') . ' ' . $InvOrCredit . ' ' . _('Number') . ' ' . $FromTransNo;
        include('includes/header.php');
        echo '<p>' . $InvOrCredit . ' ' . _('number') . ' ' . $FromTransNo . ' ' . _('has been emailed to') . ' ' . $_GET['Email'];
        include('includes/footer.php');
        exit;
    } else { //its not an email just print the invoice to PDF
        $pdf->OutputD($_SESSION['DatabaseName'] . '_' . $InvOrCredit . '_' . $FromTransNo . '.pdf');
    }
    $pdf->__destruct();
} else { /* The option to print PDF was not hit */

    $Title = _('Select Invoices/Credit Notes To Print');
    include('includes/header.php');

    if (!isset($FromTransNo) OR $FromTransNo == '') {

        /* if FromTransNo is not set then show a form to allow input of either a single invoice number or a range of invoices to be printed. Also get the last invoice number created to show the user where the current range is up to */
        echo '<form action="' . htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8') . '" method="post">';
        echo '<div>';
        echo '<input type="hidden" name="FormID" value="' . $_SESSION['FormID'] . '" />';

        echo '<div class="centre"><p class="page_title_text"><img src="' . $rootpath . '/css/' . $theme . '/images/printer.png" title="' . _('Print') . '" alt="" />' . ' ' . _('Print Invoices or Credit Notes (Landscape Mode)') . '</p></div>';
        echo '<table class="table1">
				<tr><td>' . _('Print Invoices or Credit Notes') . '</td><td><select name="InvOrCredit">';
        if ($InvOrCredit == 'Invoice' OR ! isset($InvOrCredit)) {

            echo '<option selected="selected" value="Invoice">' . _('Invoices') . '</option>';
            echo '<option value="Credit">' . _('Credit Notes') . '</option>';
        } else {
            echo '<option selected="selected" value="Credit">' . _('Credit Notes') . '</option>';
            echo '<option value="Invoice">' . _('Invoices') . '</option>';
        }

        echo '</select></td></tr>';
        echo '<tr><td>' . _('Print EDI Transactions') . '</td><td><select name="PrintEDI">';

        if ($InvOrCredit == 'Invoice' OR ! isset($InvOrCredit)) {

            echo '<option selected="selected" value="No">' . _('Do not Print PDF EDI Transactions') . '</option>';
            echo '<option value="Yes">' . _('Print PDF EDI Transactions Too') . '</option>';
        } else {

            echo '<option value="No">' . _('Do not Print PDF EDI Transactions') . '</option>';
            echo '<option selected="selected" value="Yes">' . _('Print PDF EDI Transactions Too') . '</option>';
        }

        echo '</select></td></tr>';
        echo '<tr><td>' . _('Start invoice/credit note number to print') . '</td>
				<td><input type="text" class="number" maxlength="7" size="7" name="FromTransNo" /></td></tr>';
        echo '<tr><td>' . _('End invoice/credit note number to print') . '</td>
				<td><input type="text" class="number" maxlength="7" size="7" name="ToTransNo" /></td></tr>
			</table>';
        echo '<div class="centre"><input type="submit" name="Print" value="' . _('Print') . '" /><br />';
        echo '<input type="submit" name="PrintPDF" value="' . _('Print PDF') . '" /></div>';

        $sql = "SELECT typeno FROM systypes WHERE typeid=10";

        $result = DB_query($sql, $db);
        $myrow = DB_fetch_row($result);

        echo '<div class="page_help_text"><b>' . _('The last invoice created was number') . ' ' . $myrow[0] . '</b><br />' . _('If only a single invoice is required') . ', ' . _('enter the invoice number to print in the Start transaction number to print field and leave the End transaction number to print field blank') . '. ' . _('Only use the end invoice to print field if you wish to print a sequential range of invoices') . '';

        $sql = "SELECT typeno FROM systypes WHERE typeid=11";

        $result = DB_query($sql, $db);
        $myrow = DB_fetch_row($result);

        echo '<br /><b>' . _('The last credit note created was number') . ' ' . $myrow[0] . '</b>
              <br />' . _('A sequential range can be printed using the same method as for invoices above') . '. ' . _('A single credit note can be printed by only entering a start transaction number') .
        '</div>';
        echo '</div>
              </form>';
    } else {

        while ($FromTransNo <= filter_number_format($_POST['ToTransNo'])) {

            /* retrieve the invoice details from the database to print
              notice that salesorder record must be present to print the invoice purging of sales orders will
              nobble the invoice reprints */

            if ($InvOrCredit == 'Invoice') {

                $sql = "SELECT debtortrans.trandate,
								debtortrans.ovamount,
								debtortrans.ovdiscount,
								debtortrans.ovfreight,
								debtortrans.ovgst,
								debtortrans.rate,
								debtortrans.invtext,
								debtortrans.consignment,
                                                                gltransaux.UUID,
                                                                gltransaux.FechaTimbrado,
                                                                gltransaux.selloCFD,
                                                                gltransaux.noCertificadoSAT,
                                                                gltransaux.cerEmisor,
                                                                gltransaux.selloSAT,
								debtorsmaster.name,
								debtorsmaster.address1,
								debtorsmaster.address2,
								debtorsmaster.address3,
								debtorsmaster.address4,
								debtorsmaster.address5,
								debtorsmaster.address6,
								debtorsmaster.currcode,
								salesorders.deliverto,
								salesorders.deladd1,
								salesorders.deladd2,
								salesorders.deladd3,
								salesorders.deladd4,
								salesorders.deladd5,
								salesorders.deladd6,
								salesorders.customerref,
								salesorders.orderno,
								salesorders.orddate,
								shippers.shippername,
								custbranch.brname,
								custbranch.braddress1,
								custbranch.braddress2,
								custbranch.braddress3,
								custbranch.braddress4,
								custbranch.braddress5,
								custbranch.braddress6,
								salesman.salesmanname,
								debtortrans.debtorno,
								currencies.decimalplaces
							FROM debtortrans INNER JOIN debtorsmaster
							ON debtortrans.debtorno=debtorsmaster.debtorno
							INNER JOIN custbranch
							ON debtortrans.debtorno=custbranch.debtorno
							AND debtortrans.branchcode=custbranch.branchcode
							INNER JOIN salesorders
							ON debtortrans.order_ = salesorders.orderno
							INNER JOIN shippers
							ON debtortrans.shipvia=shippers.shipper_id
							INNER JOIN salesman
							ON custbranch.salesman=salesman.salesmancode
							INNER JOIN locations
							ON salesorders.fromstkloc=locations.loccode
							INNER JOIN paymentterms
							ON debtorsmaster.paymentterms=paymentterms.termsindicator
							INNER JOIN currencies
							ON debtorsmaster.currcode=currencies.currabrev
                                                        INNER JOIN gltransaux
                                                        ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
							WHERE debtortrans.type=10
							AND debtortrans.transno='" . $FromTransNo . "'";
            } else {

                $sql = "SELECT debtortrans.trandate,
								debtortrans.ovamount,
								debtortrans.ovdiscount,
								debtortrans.ovfreight,
								debtortrans.ovgst,
								debtortrans.rate,
								debtortrans.invtext,
                                                                gltransaux.UUID,
                                                                gltransaux.FechaTimbrado,
                                                                gltransaux.selloCFD,
                                                                gltransaux.noCertificadoSAT,
                                                                gltransaux.selloSAT,                                                                
								debtorsmaster.name,
								debtorsmaster.address1,
								debtorsmaster.address2,
								debtorsmaster.address3,
								debtorsmaster.address4,
								debtorsmaster.address5,
								debtorsmaster.address6,
								debtorsmaster.currcode,
								custbranch.brname,
								custbranch.braddress1,
								custbranch.braddress2,
								custbranch.braddress3,
								custbranch.braddress4,
								custbranch.braddress5,
								custbranch.braddress6,
								salesman.salesmanname,
								debtortrans.debtorno,
								currencies.decimalplaces
							FROM debtortrans INNER JOIN debtorsmaster
							ON debtortrans.debtorno=debtorsmaster.debtorno
							INNER JOIN custbranch
							ON debtortrans.debtorno=custbranch.debtorno
							AND debtortrans.branchcode=custbranch.branchcode
							INNER JOIN salesman
							ON custbranch.salesman=salesman.salesmancode
							INNER JOIN paymentterms
							ON debtorsmaster.paymentterms=paymentterms.termsindicator
							INNER JOIN currencies
							ON debtorsmaster.currcode=currencies.currabrev
                                                        INNER JOIN gltransaux
                                                        ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
							WHERE debtortrans.type=11
							AND debtortrans.transno='" . $FromTransNo . "'";
            }

            $result = DB_query($sql, $db);
            if (DB_num_rows($result) == 0 OR DB_error_no($db) != 0) {
                echo '<p>' . _('There was a problem retrieving the invoice or credit note details for note number') . ' ' . $InvoiceToPrint . ' ' . _('from the database') . '. ' . _('To print an invoice, the sales order record, the customer transaction record and the branch record for the customer must not have been purged') . '. ' . _('To print a credit note only requires the customer, transaction, salesman and branch records be available');
                if ($debug == 1) {
                    echo _('The SQL used to get this information that failed was') . '<br />' . $sql;
                }
                break;
                include('includes/footer.php');
                exit;
            } elseif (DB_num_rows($result) == 1) {

                $myrow = DB_fetch_array($result);
                /* Then there's an invoice (or credit note) to print. So print out the invoice header and GST Number from the company record */
                if (count($_SESSION['AllowedPageSecurityTokens']) == 1
                        AND in_array(1, $_SESSION['AllowedPageSecurityTokens'])
                        AND $myrow['debtorno'] != $_SESSION['CustomerID']) {

                    echo '<p class="bad">' . _('This transaction is addressed to another customer and cannot be displayed for privacy reasons') . '. ' . _('Please select only transactions relevant to your company');
                    exit;
                }

                $ExchRate = $myrow['rate'];
                $PageNumber = 1;

                echo '<table class="table1">
						<tr><td valign="top" style="width:10%"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
						<td style="background-color:#BBBBBB">';

                if ($InvOrCredit == 'Invoice') {
                    echo '<h2>' . _('TAX INVOICE') . ' ';
                } else {
                    echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                }
                echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('Tax Authority Ref') . '. ' . $_SESSION['CompanyRecord']['gstno'] . '</td>
					</tr>
					</table>';

                /* Now print out the logo and company name and address */
                echo '<table class="table1">
						<tr><td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';

                echo '</td><td style="width:50%" class="number">';

                /* Now the customer charged to details in a sub table within a cell of the main table */

                echo '<table class="table1">
						<tr>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Charge To') . ':</b></td>
						</tr>
						<tr>
							<td style="background-color:#EEEEEE">';
                echo $myrow['name'] .
                '<br />' . $myrow['address1'] .
                '<br />' . $myrow['address2'] .
                '<br />' . $myrow['address3'] .
                '<br />' . $myrow['address4'] .
                '<br />' . $myrow['address5'] .
                '<br />' . $myrow['address6'];
                echo '</td>
					</tr>
					</table>';
                /* end of the small table showing charge to account details */
                echo _('Page') . ': ' . $PageNumber;
                echo '</td>
					</tr>
					</table>';
                /* end of the main table showing the company name and charge to details */

                if ($InvOrCredit == 'Invoice') {

                    echo '<table class="table1">
				   			<tr>
				   				<td align="left" style="background-color:#BBBBBB"><b>' . _('Charge Branch') . ':</b></td>
								<td align="left" style="background-color:#BBBBBB"><b>' . _('Delivered To') . ':</b></td>
							</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . $myrow['brname'] .
                    '<br />' . $myrow['braddress1'] .
                    '<br />' . $myrow['braddress2'] .
                    '<br />' . $myrow['braddress3'] .
                    '<br />' . $myrow['braddress4'] .
                    '<br />' . $myrow['braddress5'] .
                    '<br />' . $myrow['braddress6'] . '</td>';

                    echo '<td style="background-color:#EEEEEE">' . $myrow['deliverto'] .
                    '<br />' . $myrow['deladd1'] .
                    '<br />' . $myrow['deladd2'] .
                    '<br />' . $myrow['deladd3'] .
                    '<br />' . $myrow['deladd4'] .
                    '<br />' . $myrow['deladd5'] .
                    '<br />' . $myrow['deladd6'] . '</td>
							</tr>
						</table>
						<hr />';

                    echo '<table class="table1">
				   		<tr>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Your Order Ref') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Our Order No') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Order Date') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Invoice Date') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Sales Person') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Shipper') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Consignment Ref') . '</b></td>
						</tr>';
                    echo '<tr>
							<td style="background-color:#EEEEEE">' . $myrow['customerref'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['orderno'] . '</td>
							<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['orddate']) . '</td>
							<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['trandate']) . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['salesmanname'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['shippername'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['consignment'] . '</td>
						</tr>
					</table>';

                    $sql = "SELECT stockmoves.stockid,
						   		stockmaster.description,
								-stockmoves.qty as quantity,
								stockmoves.discountpercent,
								((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . "* -stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces
							FROM stockmoves,
								stockmaster
							WHERE stockmoves.stockid = stockmaster.stockid
							AND stockmoves.type=10
							AND stockmoves.transno='" . $FromTransNo . "'
							AND stockmoves.show_on_inv_crds=1";
                } else { /* then its a credit note */

                    echo '<table width="50%"><tr>
				   		<td align="left" style="background-color:#BBBBBB"><b>' . _('Branch') . ':</b></td>
						</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . $myrow['brname'] .
                    '<br />' . $myrow['braddress1'] .
                    '<br />' . $myrow['braddress2'] .
                    '<br />' . $myrow['braddress3'] .
                    '<br />' . $myrow['braddress4'] .
                    '<br />' . $myrow['braddress5'] .
                    '<br />' . $myrow['braddress6'] . '</td>
					</tr></table>';
                    echo '<hr /><table class="table1"><tr>
				   		<td align="left" style="background-color:#BBBBBB"><b>' . _('Date') . '</b></td>
						<td align="left" style="background-color:#BBBBBB"><b>' . _('Sales Person') . '</b></td>
					</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['trandate']) . '</td>
						<td style="background-color:#EEEEEE">' . $myrow['salesmanname'] . '</td>
					</tr></table>';

                    $sql = "SELECT stockmoves.stockid,
						   		stockmaster.description,
								stockmoves.qty as quantity,
								stockmoves.discountpercent, ((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . " * stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces
							FROM stockmoves,
								stockmaster
							WHERE stockmoves.stockid = stockmaster.stockid
							AND stockmoves.type=11
							AND stockmoves.transno='" . $FromTransNo . "'
							AND stockmoves.show_on_inv_crds=1";
                }

                echo '<hr />';
                echo '<div class="centre"><h4>' . _('All amounts stated in') . ' ' . $myrow['currcode'] . '</h4></div>';

                $result = DB_query($sql, $db);
                if (DB_error_no($db) != 0) {
                    echo '<br />' . _('There was a problem retrieving the invoice or credit note stock movement details for invoice number') . ' ' . $FromTransNo . ' ' . _('from the database');
                    if ($debug == 1) {
                        echo '<br />' . _('The SQL used to get this information that failed was') . '<br />' . $sql;
                    }
                    exit;
                }

                if (DB_num_rows($result) > 0) {
                    echo '<table class="table1">
						<tr><th>' . _('Item Code') . '</th>
							<th>' . _('Item Description') . '</th>
							<th>' . _('Quantity') . '</th>
							<th>' . _('Unit') . '</th>
							<th>' . _('Price') . '</th>
							<th>' . _('Discount') . '</th>
							<th>' . _('Net') . '</th>
						</tr>';

                    $LineCounter = 17;
                    $k = 0; //row colour counter

                    while ($myrow2 = DB_fetch_array($result)) {

                        if ($k == 1) {
                            $RowStarter = '<tr class="EvenTableRows">';
                            $k = 0;
                        } else {
                            $RowStarter = '<tr class="OddTableRows">';
                            $k = 1;
                        }

                        echo $RowStarter;

                        $DisplayPrice = locale_number_format($myrow2['fxprice'], $myrow['decimalplaces']);
                        $DisplayQty = locale_number_format($myrow2['quantity'], $myrow2['decimalplaces']);
                        $DisplayNet = locale_number_format($myrow2['fxnet'], $myrow['decimalplaces']);

                        if ($myrow2['discountpercent'] == 0) {
                            $DisplayDiscount = '';
                        } else {
                            $DisplayDiscount = locale_number_format($myrow2['discountpercent'] * 100, 2) . '%';
                        }

                        printf('<td>%s</td>
									<td>%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									</tr>', $myrow2['stockid'], $myrow2['description'], $DisplayQty, $myrow2['units'], $DisplayPrice, $DisplayDiscount, $DisplayNet);

                        if (mb_strlen($myrow2['narrative']) > 1) {
                            echo $RowStarter . '<td></td><td colspan="6">' . $myrow2['narrative'] . '</td></tr>';
                            $LineCounter++;
                        }

                        $LineCounter++;

                        if ($LineCounter == ($_SESSION['PageLength'] - 2)) {

                            /* head up a new invoice/credit note page */

                            $PageNumber++;
                            echo '</table>
								<table class="table1">
								<tr><td valign="top"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
									<td style="background-color:#BBBBBB">';

                            if ($InvOrCredit == 'Invoice') {
                                echo '<h2>' . _('TAX INVOICE') . ' ';
                            } else {
                                echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                            }
                            echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('GST Number') . ' - ' . $_SESSION['CompanyRecord']['gstno'] . '</td></tr></table>';

                            /* Now print out company name and address */
                            echo '<table class="table1"><tr>
						    	<td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                            echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                            echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                            echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                            echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';
                            echo '</td><td class="number">' . _('Page') . ': ' . $PageNumber . '</td></tr></table>';
                            echo '<table class="table1">
									<tr>
								    	<th>' . _('Item Code') . '</th>
										<th>' . _('Item Description') . '</th>
										<th>' . _('Quantity') . '</th>
										<th>' . _('Unit') . '</th>
										<th>' . _('Price') . '</th>
										<th>' . _('Discount') . '</th>
										<th>' . _('Net') . '</th>
									</tr>';

                            $LineCounter = 10;
                        } //end if need a new page headed up
                    } //end while there are line items to print out
                    echo '</table>';
                } /* end if there are stock movements to show on the invoice or credit note */

                /* check to see enough space left to print the totals/footer */
                $LinesRequiredForText = floor(mb_strlen($myrow['invtext']) / 140);

                if ($LineCounter >= ($_SESSION['PageLength'] - 8 - $LinesRequiredForText)) {

                    /* head up a new invoice/credit note page */
                    $PageNumber++;
                    echo '<table class="table1">
							<tr><td valign="top"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
							<td style="background-color:#BBBBBB">';

                    if ($InvOrCredit == 'Invoice') {
                        echo '<h2>' . _('TAX INVOICE') . ' ';
                    } else {
                        echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                    }
                    echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('GST Number') . ' - ' . $_SESSION['CompanyRecord']['gstno'] . '</td></tr><table>';

                    /* Print out the logo and company name and address */
                    echo '<table class="table1">
							<tr><td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                    echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                    echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                    echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                    echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';
                    echo '</td><td class="number">' . _('Page') . ': ' . $PageNumber . '</td></tr></table>';
                    echo '<table class="table1">
							<tr>
								<th>' . _('Item Code') . '</th>
								<th>' . _('Item Description') . '</th>
								<th>' . _('Quantity') . '</th>
								<th>' . _('Unit') . '</th>
								<th>' . _('Price') . '</th>
								<th>' . _('Discount') . '</th>
								<th>' . _('Net') . '</th>
							</tr>';

                    $LineCounter = 10;
                }

                /* Space out the footer to the bottom of the page */

                echo '<br /><br />' . $myrow['invtext'];

                $LineCounter = $LineCounter + 2 + $LinesRequiredForText;
                while ($LineCounter < ($_SESSION['PageLength'] - 6)) {
                    echo '<br />';
                    $LineCounter++;
                }

                /* Now print out the footer and totals */

                if ($InvOrCredit == 'Invoice') {

                    $DisplaySubTot = locale_number_format($myrow['ovamount'], $myrow['decimalplaces']);
                    $DisplayFreight = locale_number_format($myrow['ovfreight'], $myrow['decimalplaces']);
                    $DisplayTax = locale_number_format($myrow['ovgst'], $myrow['decimalplaces']);
                    $DisplayTotal = locale_number_format($myrow['ovfreight'] + $myrow['ovgst'] + $myrow['ovamount'], $myrow['decimalplaces']);
                } else {
                    $DisplaySubTot = locale_number_format(-$myrow['ovamount'], $myrow['decimalplaces']);
                    $DisplayFreight = locale_number_format(-$myrow['ovfreight'], $myrow['decimalplaces']);
                    $DisplayTax = locale_number_format(-$myrow['ovgst'], $myrow['decimalplaces']);
                    $DisplayTotal = locale_number_format(-$myrow['ovfreight'] - $myrow['ovgst'] - $myrow['ovamount'], $myrow['decimalplaces']);
                }

                /* Print out the invoice text entered */
                echo '<table class="table1"><tr>
					<td class="number">' . _('Sub Total') . '</td>
					<td class="number" style="background-color:#EEEEEE;width:15%">' . $DisplaySubTot . '</td></tr>';
                echo '<tr><td class="number">' . _('Freight') . '</td>
					<td class="number" style="background-color:#EEEEEE">' . $DisplayFreight . '</td></tr>';
                echo '<tr><td class="number">' . _('Tax') . '</td>
					<td class="number" style="background-color:#EEEEEE">' . $DisplayTax . '</td></tr>';
                if ($InvOrCredit == 'Invoice') {
                    echo '<tr>
							<td class="number"><b>' . _('TOTAL INVOICE') . '</b></td>
							<td class="number" style="background-color:#EEEEEE"><b>' . $DisplayTotal . '</b></td>
						</tr>';
                } else {
                    echo '<tr>
							<td class="number" style="color:red"><b>' . _('TOTAL CREDIT') . '</b></td>
				     		<td class="number" style="background-color:#EEEEEE;color:red"><b>' . $DisplayTotal . '</b></td>
				     	</tr>';
                }
                echo '</table>';
            } /* end of check to see that there was an invoice record to print */
            $FromTransNo++;
        } /* end loop to print invoices */
    } /* end of if FromTransNo exists */
    include('includes/footer.php');
} /* end of else not PrintPDF */

function PrintLinesToBottom() {

    global $pdf;
    global $PageNumber;
    global $TopOfColHeadings;
    global $Left_Margin;
    global $Bottom_Margin;
    global $line_height;

    /* draw the vertical column lines right to the bottom */
    $pdf->line($Left_Margin + 97, $TopOfColHeadings + 12, $Left_Margin + 97, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 350, $TopOfColHeadings + 12, $Left_Margin + 350, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 450, $TopOfColHeadings + 12, $Left_Margin + 450, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 550, $TopOfColHeadings + 12, $Left_Margin + 550, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 587, $TopOfColHeadings + 12, $Left_Margin + 587, $Bottom_Margin);

    $pdf->line($Left_Margin + 640, $TopOfColHeadings + 12, $Left_Margin + 640, $Bottom_Margin);

    $PageNumber++;
}

function getpath($qry) {
    global $xp;
    $prm = array();
    $nodelist = $xp->query($qry);
    foreach ($nodelist as $tmpnode) {
        $prm[] = trim($tmpnode->nodeValue);
    }
    $ret = (sizeof($prm) <= 1) ? $prm[0] : $prm;
    return($ret);
}

function fix_fdoc_arre($fdoc) {
    if (strpos($fdoc, "/") !== FALSE) { // tiene diagonales viene dd/mm/yyyy hh:mm
        list($f, $h) = explode(" ", $fdoc);
        list($d, $m, $y) = explode("/", $f);
        $fdoc = "$y-$m-$d $h";
    }
    return ($fdoc);
}

?>
