<?php

//líneas 131-133,193-195,232-243//
/* $Id: PrintCustTrans.php 5399 2012-05-26 10:46:05Z daintree $ */
$PageSecurity = 1;

//ini_set('display_errors', 0);
//error_reporting(0);
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('includes/session.php');
include('Numbers/Words.php');
include('includes/phpqrcode/qrlib.php');

if (isset($PrintPDF) OR isset($_POST['PrintPDF'])) {

    include ('includes/class.pdf.php');

    $FromTransNo = '';

    $Page_Width = 612;
    $Page_Height = 792;
    $Top_Margin = 0;
    $Bottom_Margin = 30;
    $Left_Margin = 30;
    $Right_Margin = 25;

    $PageSize = array(0, 0, $Page_Width, $Page_Height);

    $pdf = new Cpdf($PageSize);
    $pdf->addInfo('Creator', 'webERP http://www.weberp.org');
    $pdf->addInfo('Author', 'webERP ' . $Version);

    $pdf->setAutoPageBreak(0);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->AddPage();
    $pdf->cMargin = 0;
    /* END Brought from class.pdf.php constructor */

    $FirstPage = true;
    $line_height = 16;

    if (file_exists ('SAT/facturasTimbradas/pago_' . $_POST['pagonum'] . '.xml')){
        $file = 'SAT/facturasTimbradas/pago_' . $_POST['pagonum'] . '.xml';
    }else{
        echo '<br><br><h1 align="center">El pago no ha sido timbrado</h1><br>';
        die();
    }
    $texto = file_get_contents('SAT/facturasTimbradas/pago_' . $_POST['pagonum'] . '.xml');
    $xml = new DOMDocument();
    $ok = $xml->loadXML($texto);
    if (!$ok) {
        //display_xml_errors();
        die();
    }
    $xp = new DOMXpath($xml);
    if (!$xml->getElementsByTagName("StampErrors")->item(0)) {
        $data['fecha'] = getpath("//@Fecha");
        $data['cerEmisor'] = getpath("//@NoCertificado");
        $data['FechaTimbrado'] = getpath("//@FechaTimbrado");
        $data['selloCFD'] = getpath("//@SelloCFD");
        $data['UUID'] = getpath("//@UUID");
        $data['noCertificadoSAT'] = getpath("//@NoCertificadoSAT");
        $data['NoCertificado'] = getpath("//@NoCertificado");
        $data['selloSAT'] = getpath("//@SelloSAT");
        $data['FechaTimbrado'] = getpath("//@FechaTimbrado");
        $data['Total'] = getpath("//@Total");
        $data['RFC'] = getpath("//@Rfc");
        $data['FormaPago'] = getpath("//@FormaPago");
        $data['MetodoPago'] = getpath("//@MetodoPago");
        $data['UsoCFDI'] = getpath("//@UsoCFDI");
        $data['TipoCambio'] = getpath("//@TipoCambio");
        $data['NombreRec'] = getpath("//@Nombre");
        $data['UsoCFDI'] = getpath("//@UsoCFDI");
        $data['ClaveProdServ'] = getpath("//@ClaveProdServ");
        $data['Cantidad'] = getpath("//@Cantidad");
        $data['ClaveUnidad'] = getpath("//@ClaveUnidad");
        $data['Descripcion'] = getpath("//@Descripcion");
        $data['ValorUnitario'] = getpath("//@ValorUnitario");
        $data['Importe'] = getpath("//@Importe");
        $data['Folio'] = getpath("//@Folio");
        $data['FechaPago'] = getpath("//@FechaPago");
        $data['FormaDePagoP'] = getpath("//@FormaDePagoP");
        $data['MonedaP'] = getpath("//@MonedaP");
        $data['TipoCambioP'] = getpath("//@TipoCambioP");
        $data['Monto'] = getpath("//@Monto");
        $data['NomBancoOrdExt'] = getpath("//@NomBancoOrdExt");
        $data['IdDocumento'] = getpath("//@IdDocumento");
        $data['MonedaDR'] = getpath("//@MonedaDR");
        $data['MetodoDePagoDR'] = getpath("//@MetodoDePagoDR");
        $data['NumParcialidad'] = getpath("//@NumParcialidad");
        $data['ImpSaldoAnt'] = getpath("//@ImpSaldoAnt");
        $data['ImpPagado'] = getpath("//@ImpPagado");
        $data['ImpSaldoInsoluto'] = getpath("//@ImpSaldoInsoluto");
        $CadenaOriginalTFD = '||1.0|' . $data['UUID'] . '|' . $data['FechaTimbrado'] . '|' . $data['selloCFD'] . '|' . $data['noCertificadoSAT'] . '||';
    } else {
        $data['ErrorCode'] = getpath("//@ErrorCode");
        $data['ErrorType'] = getpath("//@ErrorType");
        $data['Description'] = $xml->getElementsByTagName("Description")->item(0)->nodeValue;

        echo "<h2 align='center'>Error al timbrar la factura número " . $arr['folio'] . "</h2><br>";
        echo '<h2 align="center">Código de error:' . $data["ErrorCode"] . '<br>  Tipo de error:' . $data["ErrorType"] . '</h2><br>
                     <div align="center"><p align="center" style="width:50%;">Descripción:' . $data["Description"] . '</p></div>';
        echo '<a href="' . $_SERVER['PHP_SELF'] . '"><h1 align="center">Regresar</h1></a>';
        die();
    }


    include('includes/PagoTransPageHeader.inc');

    if (!is_array($data['IdDocumento'])) {
        $sql_formaP = 'SELECT c_FormaPago,Descripción FROM c_FormaPago WHERE c_FormaPago like "' . $data['FormaDePagoP'] . '"';
        $sql_monedaP = 'SELECT c_Moneda,Descripcion FROM c_Moneda WHERE c_Moneda LIKE "' . $data['MonedaP'] . '"';
    } else {
        $sql_formaP = 'SELECT c_FormaPago,Descripción FROM c_FormaPago WHERE c_FormaPago like "' . $data['FormaDePagoP'][0] . '"';
        $sql_monedaP = 'SELECT c_Moneda,Descripcion FROM c_Moneda WHERE c_Moneda LIKE "' . $data['MonedaP'][0] . '"';
    }
//echo $sql_monedaP;
    $res_formaP = DB_query($sql_formaP, $db);
    $ren_formaP = DB_fetch_array($res_formaP);
    $res_monedaP = DB_query($sql_monedaP, $db);
    $ren_monedaP = DB_fetch_array($res_monedaP);

    $pdf->Ln(5);
    $pdf->SetFont('Helvetica', '', 8);
    if (is_array($data['FechaPago'])){
        $pdf->cell(180, 0, 'Fecha de pago: ' . substr($data['FechaPago'][0],0,10).' '.substr($data['FechaPago'][0],11,5), 0, 0, 'L', false);
    }else {
        $pdf->cell(180, 0, 'Fecha de pago: ' . substr($data['FechaPago'],0,10).' '.substr($data['FechaPago'],11,5), 0, 0, 'L', false);
    }
    $pdf->cell(180, 0, 'Forma de pago: ' . $ren_formaP['Descripción'], 0, 0, 'C', false);
    $pdf->cell(200, 0, 'Moneda pago: ' . $ren_monedaP['Descripcion'], 0, 1, 'C', false);
    
    if ($data['TipoCambioP'][0]!= ''){
        $pdf->cell(180, 0, 'Tipo de cambio: ' . $data['TipoCambioP'][0], 0, 0, 'L', false);
    }else{
        $pdf->cell(180, 0, '', 0, 0, 'L', false);
    }
    
    if (is_array($data['Monto'])) {
        $pdf->cell(180, 0, 'Monto:  ' . locale_number_format($data['Monto'][0],2), 0, 0, 'C', false);
        if ($data['NomBancoOrdExt'][0]!=''){
            $pdf->cell(200, 0, 'Banco extranjero: ' . $data['NomBancoOrdExt'][0], 0, 0, 'C', false);
        }
        $pdf->Ln(8);
    } else {
        $pdf->cell(180, 0, 'Monto: ' . locale_number_format($data['Monto'],2), 0, 0, 'C', false);
        if ($data['NomBancoOrdExt']!=''){
            $pdf->cell(200, 0, 'Banco extranjero: ' . $data['NomBancoOrdExt'], 0, 0, 'C', false);
        }
        $pdf->Ln(8);
    }
        
    $pdf->Ln(5);
    $pdf->SetFont('Helvetica', 'B', 10);
    $pdf->cell(0, 0, 'Documento relacionado', 1, 1, 'L', true);
    $pdf->SetFont('Helvetica', 'B', 6);
    $pdf->cell(174, 0, 'Folio', 1, 0, 'C', true);
    $pdf->cell(55, 0, 'Moneda', 1, 0, 'C', true);
    $pdf->cell(55, 0, 'Met. pago', 1, 0, 'C', true);
    $pdf->cell(40, 0, 'Parcialidad', 1, 0, 'C', true);
    $pdf->cell(75, 0, 'Saldo ante', 1, 0, 'C', true);
    $pdf->cell(75, 0, 'Pagado', 1, 0, 'C', true);
    $pdf->cell(65, 0, 'Saldo', 1, 1, 'C', true);
    
    $pdf->Ln(5);
    $pdf->SetFont('Helvetica', '', 8);
    if (is_array($data['IdDocumento'])) {
        for ($i=0; $i<count($data['IdDocumento']); $i++) {
            $pdf->cell(174, 0,$data['IdDocumento'][$i], 0, 0, 'C', false);
            $pdf->cell(55, 0,$data['MonedaDR'][$i], 0, 0, 'C', false);
            $pdf->cell(55, 0,$data['MetodoDePagoDR'][$i], 0, 0, 'C', false);
            $pdf->cell(40, 0,$data['NumParcialidad'][$i], 0, 0, 'C', false);
            $pdf->cell(75, 0,locale_number_format($data['ImpSaldoAnt'][$i],2), 0, 0, 'R', false);
            $pdf->cell(75, 0,locale_number_format($data['ImpPagado'][$i],2), 0, 0, 'R', false);
            $pdf->cell(65, 0,locale_number_format($data['ImpSaldoInsoluto'][$i],2), 0, 1, 'R', false);
            $pos = $pdf->GetY();
            if ($pos>670){
                $pdf->Ln(50);
                $pdf->cell(500, 0,'Continúa en la siguiente página', 0, 0, 'C', false);
                $pdf->AddPage();
            }
        }       
    }else{
            $pdf->cell(174, 0,$data['IdDocumento'], 0, 0, 'C', false);
            $pdf->cell(55, 0,$data['MonedaDR'], 0, 0, 'C', false);
            $pdf->cell(55, 0,$data['MetodoDePagoDR'], 0, 0, 'C', false);
            $pdf->cell(40, 0,$data['NumParcialidad'], 0, 0, 'C', false);
            $pdf->cell(75, 0,locale_number_format($data['ImpSaldoAnt'],2), 0, 0, 'C', false);
            $pdf->cell(75, 0,locale_number_format($data['ImpPagado'],2), 0, 0, 'C', false);
            $pdf->cell(65, 0,locale_number_format($data['ImpSaldoInsoluto'],2), 0, 1, 'C', false);
    }
    
    $YPos = 180;
    $pdf -> Line(20, 155, 550, 155);
    $FontSize = 12;
    
    $pdf->SetFont('Helvetica', 'B', 8);
    $pdf->addText($Left_Margin + 35, $YPos - 27, $FontSize - 4, 'No. de serie del CSD:');
    $pdf->addText($Left_Margin + 280, $YPos - 27, $FontSize - 4, 'No. de serie del certificado SAT: ');
    $pdf->SetFont('Helvetica', '', 8);
    $pdf->addText($Left_Margin + 120, $YPos - 27, $FontSize - 4, $data['noCertificadoSAT']);
    $pdf->addText($Left_Margin + 410, $YPos - 27, $FontSize - 4, $data['NoCertificado']);
    
    $y = 0;
    $pdf->SetFont('Helvetica', 'B', 8);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 45, 100, $FontSize - 3, 'Sello digital del CFDI:');
    $pdf->SetFont('Helvetica', '', 6);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 52, 500, $FontSize - 4, $data['selloCFD']);
    while (strlen($LeftOvers) > 0) {
        $y+=7;
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 52 - $y, 500, $FontSize - 4, $LeftOvers);
    }

    $y = 0;
    $pdf->SetFont('Helvetica', 'B', 8);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 80, 300, $FontSize - 3, 'Sello digital del SAT:');
    $pdf->SetFont('Helvetica', '', 6);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 87, 500, $FontSize - 4, $data['selloSAT']);
    while (strlen($LeftOvers) > 0) {
        $y+=7;
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 87 - $y, 500, $FontSize - 4, $LeftOvers);
    }

    $y = 0;
    $pdf->SetFont('Helvetica', 'B', 8);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 5, $YPos - 115, 300, $FontSize - 3, 'Cadena original del complemento de certificación digital del SAT: ');
    $pdf->SetFont('Helvetica', '', 6);
    $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 122, 500, $FontSize - 4, $CadenaOriginalTFD);
    while (strlen($LeftOvers) > 0) {
        $y+=7;
        $LeftOvers = $pdf->addTextWrap($Left_Margin + 15, $YPos - 122 - $y, 500, $FontSize - 4, $LeftOvers);
    }

    $pdf->SetFont('Helvetica', 'B', 8);
    $pdf->addText($Left_Margin + 130, $YPos - 150, $FontSize - 4, 'Este documento es una representación impresa de un CFDI ');





    if (isset($_GET['Email'])) { //email the invoice to address supplied
        include('includes/header.php');

        include ('includes/htmlMimeMail.php');
        $FileName = $_SESSION['reports_dir'] . '/' . $_SESSION['DatabaseName'] . '_' . $InvOrCredit . '_' . $_GET['FromTransNo'] . '.pdf';
        $pdf->Output($FileName, 'F');
        $mail = new htmlMimeMail();

        $Attachment = $mail->getFile($FileName);
        $mail->setText(_('Please find attached') . ' ' . $InvOrCredit . ' ' . $_GET['FromTransNo']);
        $mail->SetSubject($InvOrCredit . ' ' . $_GET['FromTransNo']);
        $mail->addAttachment($Attachment, $FileName, 'application/pdf');
        $mail->setFrom($_SESSION['CompanyRecord']['coyname'] . ' <' . $_SESSION['CompanyRecord']['email'] . '>');
        $result = $mail->send(array($_GET['Email']));

        unlink($FileName); //delete the temporary file

        $Title = _('Emailing') . ' ' . $InvOrCredit . ' ' . _('Number') . ' ' . $FromTransNo;
        include('includes/header.php');
        echo '<p>' . $InvOrCredit . ' ' . _('number') . ' ' . $FromTransNo . ' ' . _('has been emailed to') . ' ' . $_GET['Email'];
        include('includes/footer.php');
        exit;
    } else { //its not an email just print the invoice to PDF
        $pdf->OutputD('pago_' . $_POST['pagonum'] . '.pdf');
    }
    $pdf->__destruct();
} else { /* The option to print PDF was not hit */

    $Title = _('Select Invoices/Credit Notes To Print');
    include('includes/header.php');

    if (!isset($FromTransNo) OR $FromTransNo == '') {

        /* if FromTransNo is not set then show a form to allow input of either a single invoice number or a range of invoices to be printed. Also get the last invoice number created to show the user where the current range is up to */
        echo '<form action="' . htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8') . '" method="post">';
        echo '<div>';
        echo '<input type="hidden" name="FormID" value="' . $_SESSION['FormID'] . '" />';

        echo '<div class="centre"><h1 class="page_title_text"><img src="' . $rootpath . '/css/' . $theme . '/images/printer.png" title="' . _('Print') . '" alt="" />' . ' ' . _('Imprimir recibos de pago') . '</h1></div>';
        echo '<br><br><table>';

//				<tr><td>' . _('Imprimir recibos de pago') . '</td><td><select name="InvOrCredit">';
//        if ($InvOrCredit == 'Invoice' OR ! isset($InvOrCredit)) {
//
//            echo '<option selected="selected" value="Invoice">' . _('Invoices') . '</option>';
//            echo '<option value="Credit">' . _('Credit Notes') . '</option>';
//        } else {
//            echo '<option selected="selected" value="Credit">' . _('Credit Notes') . '</option>';
//            echo '<option value="Invoice">' . _('Invoices') . '</option>';
//        }
//        echo '</select></td></tr>';
//        echo '<tr><td>' . _('Print EDI Transactions') . '</td><td><select name="PrintEDI">';
//
//        if ($InvOrCredit == 'Invoice' OR ! isset($InvOrCredit)) {
//
//            echo '<option selected="selected" value="No">' . _('Do not Print PDF EDI Transactions') . '</option>';
//            echo '<option value="Yes">' . _('Print PDF EDI Transactions Too') . '</option>';
//        } else {
//
//            echo '<option value="No">' . _('Do not Print PDF EDI Transactions') . '</option>';
//            echo '<option selected="selected" value="Yes">' . _('Print PDF EDI Transactions Too') . '</option>';
//        }
//        echo '<tr></tr><tr></tr>';
        echo '<tr><td>' . _('Imprimir pago número: ') . '</td>
				<td><input type="text" class="number" maxlength="7" size="7" name="pagonum" /></td></tr>';
//        echo '<tr><td>' . _('End invoice/credit note number to print') . '</td>
//				<td><input type="text" class="number" maxlength="7" size="7" name="ToTransNo" /></td></tr>
        echo '</table>';
//        echo '<div class="centre"><input type="submit" name="Print" value="' . _('Print') . '" /><br />';
        echo '<br><input type="submit" name="PrintPDF" value="' . _('Print PDF') . '" /></div><br><br>';

        $sql = "SELECT typeno FROM systypes WHERE typeid=12";

        $result = DB_query($sql, $db);
        $myrow = DB_fetch_row($result);

        echo '<div class="page_help_text"><b>' . _('El último pago capturado fué el número: ') . ' ' . $myrow[0] . '</b><br />';

//        $sql = "SELECT typeno FROM systypes WHERE typeid=11";
//
//        $result = DB_query($sql, $db);
//        $myrow = DB_fetch_row($result);
//        echo '<br /><b>' . _('The last credit note created was number') . ' ' . $myrow[0] . '</b>
//              <br />' . _('A sequential range can be printed using the same method as for invoices above') . '. ' . _('A single credit note can be printed by only entering a start transaction number') .
//        '</div>';
        echo '</div>
              </form>';
    } else {

        while ($FromTransNo <= filter_number_format($_POST['ToTransNo'])) {

            /* retrieve the invoice details from the database to print
              notice that salesorder record must be present to print the invoice purging of sales orders will
              nobble the invoice reprints */

            if ($InvOrCredit == 'Invoice') {

                $sql = "SELECT debtortrans.ovamount,
							debtortrans.ovdiscount,
							debtortrans.ovfreight,
							debtortrans.ovgst,
							debtortrans.rate,
							debtortrans.inputdate,
							debtortrans.invtext,
							debtortrans.consignment,
                                                        gltransaux.UUID,
                                                        gltransaux.FechaTimbrado,
                                                        gltransaux.selloCFD,
                                                        gltransaux.noCertificadoSAT,
                                                        gltransaux.selloSAT,
                                                        gltransaux.cerEmisor,
                                                        gltransaux.fechaFactura,
							debtorsmaster.name,
							debtorsmaster.address1,
							debtorsmaster.address2,
							debtorsmaster.address3,
							debtorsmaster.address4,
							debtorsmaster.address5,
							debtorsmaster.address6,
							debtorsmaster.currcode,
							debtorsmaster.invaddrbranch,
							debtorsmaster.taxref,
							debtorsmasteraux.numcta,
                                                        debtorsmasteraux.metpgo,
                                                        debtorsmasteraux.forpgo,
							paymentterms.terms,
							salesorders.deliverto,
							salesorders.deladd1,
							salesorders.deladd2,
							salesorders.deladd3,
							salesorders.deladd4,
							salesorders.deladd5,
							salesorders.deladd6,
							salesorders.customerref,
							salesorders.orderno,
							salesorders.orddate,
							locations.locationname,
							shippers.shippername,
							custbranch.brname,
							custbranch.braddress1,
							custbranch.braddress2,
							custbranch.braddress3,
							custbranch.braddress4,
							custbranch.braddress5,
							custbranch.braddress6,
							custbranch.brpostaddr1,
							custbranch.brpostaddr2,
							custbranch.brpostaddr3,
							custbranch.brpostaddr4,
							custbranch.brpostaddr5,
							custbranch.brpostaddr6,
							salesman.salesmanname,
							debtortrans.debtorno,
							debtortrans.branchcode,
							currencies.decimalplaces,
				currencies.currency,
                                currencies.currabrev,
				gltransaux.sello,
				gltransaux.cadena,
                                gltransaux.CadenaOriginalTFD,
                                c_FormaPago.Descripción
						FROM debtortrans INNER JOIN debtorsmaster
						ON debtortrans.debtorno=debtorsmaster.debtorno
						INNER JOIN custbranch
						ON debtortrans.debtorno=custbranch.debtorno
						AND debtortrans.branchcode=custbranch.branchcode
						INNER JOIN salesorders
						ON debtortrans.order_ = salesorders.orderno
						INNER JOIN shippers
						ON debtortrans.shipvia=shippers.shipper_id
						INNER JOIN salesman
						ON custbranch.salesman=salesman.salesmancode
						INNER JOIN locations
						ON salesorders.fromstkloc=locations.loccode
						INNER JOIN paymentterms
						ON debtorsmaster.paymentterms=paymentterms.termsindicator
						INNER JOIN currencies
						ON debtorsmaster.currcode=currencies.currabrev
                                                INNER JOIN gltransaux
                                                ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
                                                LEFT JOIN debtorsmasteraux
                                                ON debtorsmaster.debtorno = debtorsmasteraux.debtorno
                                                LEFT JOIN c_FormaPago
                                                ON debtorsmasteraux.metpgo = c_FormaPago.c_FormaPago
						WHERE debtortrans.type=10
						AND debtortrans.transno='" . $FromTransNo . "'";
            } else {

                $sql = "SELECT debtortrans.trandate,
								debtortrans.ovamount,
								debtortrans.ovdiscount,
								debtortrans.ovfreight,
								debtortrans.ovgst,
								debtortrans.rate,
								debtortrans.invtext,
                                                                gltransaux.UUID,
                                                                gltransaux.FechaTimbrado,
                                                                gltransaux.selloCFD,
                                                                gltransaux.noCertificadoSAT,
                                                                gltransaux.selloSAT,                                                                
								debtorsmaster.name,
								debtorsmaster.address1,
								debtorsmaster.address2,
								debtorsmaster.address3,
								debtorsmaster.address4,
								debtorsmaster.address5,
								debtorsmaster.address6,
								debtorsmaster.currcode,
								custbranch.brname,
								custbranch.braddress1,
								custbranch.braddress2,
								custbranch.braddress3,
								custbranch.braddress4,
								custbranch.braddress5,
								custbranch.braddress6,
								salesman.salesmanname,
								debtortrans.debtorno,
								currencies.decimalplaces
							FROM debtortrans INNER JOIN debtorsmaster
							ON debtortrans.debtorno=debtorsmaster.debtorno
							INNER JOIN custbranch
							ON debtortrans.debtorno=custbranch.debtorno
							AND debtortrans.branchcode=custbranch.branchcode
							INNER JOIN salesman
							ON custbranch.salesman=salesman.salesmancode
							INNER JOIN paymentterms
							ON debtorsmaster.paymentterms=paymentterms.termsindicator
							INNER JOIN currencies
							ON debtorsmaster.currcode=currencies.currabrev
                                                        INNER JOIN gltransaux
                                                        ON debtortrans.transno = gltransaux.transno AND debtortrans.type = gltransaux.type
							WHERE debtortrans.type=11
							AND debtortrans.transno='" . $FromTransNo . "'";
            }

            $result = DB_query($sql, $db);
            if (DB_num_rows($result) == 0 OR DB_error_no($db) != 0) {
                echo '<p>' . _('There was a problem retrieving the invoice or credit note details for note number') . ' ' . $InvoiceToPrint . ' ' . _('from the database') . '. ' . _('To print an invoice, the sales order record, the customer transaction record and the branch record for the customer must not have been purged') . '. ' . _('To print a credit note only requires the customer, transaction, salesman and branch records be available');
                if ($debug == 1) {
                    echo _('The SQL used to get this information that failed was') . '<br />' . $sql;
                }
                break;
                include('includes/footer.php');
                exit;
            } elseif (DB_num_rows($result) == 1) {

                $myrow = DB_fetch_array($result);
                /* Then there's an invoice (or credit note) to print. So print out the invoice header and GST Number from the company record */
                if (count($_SESSION['AllowedPageSecurityTokens']) == 1
                        AND in_array(1, $_SESSION['AllowedPageSecurityTokens'])
                        AND $myrow['debtorno'] != $_SESSION['CustomerID']) {

                    echo '<p class="bad">' . _('This transaction is addressed to another customer and cannot be displayed for privacy reasons') . '. ' . _('Please select only transactions relevant to your company');
                    exit;
                }

                $ExchRate = $myrow['rate'];
                $PageNumber = 1;

                echo '<table class="table1">
						<tr><td valign="top" style="width:10%"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
						<td style="background-color:#BBBBBB">';

                if ($InvOrCredit == 'Invoice') {
                    echo '<h2>' . _('TAX INVOICE') . ' ';
                } else {
                    echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                }
                echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('Tax Authority Ref') . '. ' . $_SESSION['CompanyRecord']['gstno'] . '</td>
					</tr>
					</table>';

                /* Now print out the logo and company name and address */
                echo '<table class="table1">
						<tr><td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';

                echo '</td><td style="width:50%" class="number">';

                /* Now the customer charged to details in a sub table within a cell of the main table */

                echo '<table class="table1">
						<tr>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Charge To') . ':</b></td>
						</tr>
						<tr>
							<td style="background-color:#EEEEEE">';
                echo $myrow['name'] .
                '<br />' . $myrow['address1'] .
                '<br />' . $myrow['address2'] .
                '<br />' . $myrow['address3'] .
                '<br />' . $myrow['address4'] .
                '<br />' . $myrow['address5'] .
                '<br />' . $myrow['address6'];
                echo '</td>
					</tr>
					</table>';
                /* end of the small table showing charge to account details */
                echo _('Page') . ': ' . $PageNumber;
                echo '</td>
					</tr>
					</table>';
                /* end of the main table showing the company name and charge to details */

                if ($InvOrCredit == 'Invoice') {

                    echo '<table class="table1">
				   			<tr>
				   				<td align="left" style="background-color:#BBBBBB"><b>' . _('Charge Branch') . ':</b></td>
								<td align="left" style="background-color:#BBBBBB"><b>' . _('Delivered To') . ':</b></td>
							</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . $myrow['brname'] .
                    '<br />' . $myrow['braddress1'] .
                    '<br />' . $myrow['braddress2'] .
                    '<br />' . $myrow['braddress3'] .
                    '<br />' . $myrow['braddress4'] .
                    '<br />' . $myrow['braddress5'] .
                    '<br />' . $myrow['braddress6'] . '</td>';

                    echo '<td style="background-color:#EEEEEE">' . $myrow['deliverto'] .
                    '<br />' . $myrow['deladd1'] .
                    '<br />' . $myrow['deladd2'] .
                    '<br />' . $myrow['deladd3'] .
                    '<br />' . $myrow['deladd4'] .
                    '<br />' . $myrow['deladd5'] .
                    '<br />' . $myrow['deladd6'] . '</td>
							</tr>
						</table>
						<hr />';

                    echo '<table class="table1">
				   		<tr>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Your Order Ref') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Our Order No') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Order Date') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Invoice Date') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Sales Person') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Shipper') . '</b></td>
							<td align="left" style="background-color:#BBBBBB"><b>' . _('Consignment Ref') . '</b></td>
						</tr>';
                    echo '<tr>
							<td style="background-color:#EEEEEE">' . $myrow['customerref'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['orderno'] . '</td>
							<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['orddate']) . '</td>
							<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['trandate']) . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['salesmanname'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['shippername'] . '</td>
							<td style="background-color:#EEEEEE">' . $myrow['consignment'] . '</td>
						</tr>
					</table>';

                    $sql = "SELECT stockmoves.stockid,
						   		stockmaster.description,
								-stockmoves.qty as quantity,
								stockmoves.discountpercent,
								((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . "* -stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces
							FROM stockmoves,
								stockmaster
							WHERE stockmoves.stockid = stockmaster.stockid
							AND stockmoves.type=10
							AND stockmoves.transno='" . $FromTransNo . "'
							AND stockmoves.show_on_inv_crds=1";
                } else { /* then its a credit note */

                    echo '<table width="50%"><tr>
				   		<td align="left" style="background-color:#BBBBBB"><b>' . _('Branch') . ':</b></td>
						</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . $myrow['brname'] .
                    '<br />' . $myrow['braddress1'] .
                    '<br />' . $myrow['braddress2'] .
                    '<br />' . $myrow['braddress3'] .
                    '<br />' . $myrow['braddress4'] .
                    '<br />' . $myrow['braddress5'] .
                    '<br />' . $myrow['braddress6'] . '</td>
					</tr></table>';
                    echo '<hr /><table class="table1"><tr>
				   		<td align="left" style="background-color:#BBBBBB"><b>' . _('Date') . '</b></td>
						<td align="left" style="background-color:#BBBBBB"><b>' . _('Sales Person') . '</b></td>
					</tr>';
                    echo '<tr>
				   		<td style="background-color:#EEEEEE">' . ConvertSQLDate($myrow['trandate']) . '</td>
						<td style="background-color:#EEEEEE">' . $myrow['salesmanname'] . '</td>
					</tr></table>';

                    $sql = "SELECT stockmoves.stockid,
						   		stockmaster.description,
								stockmoves.qty as quantity,
								stockmoves.discountpercent, ((1 - stockmoves.discountpercent) * stockmoves.price * " . $ExchRate . " * stockmoves.qty) AS fxnet,
								(stockmoves.price * " . $ExchRate . ") AS fxprice,
								stockmoves.narrative,
								stockmaster.units,
								stockmaster.decimalplaces
							FROM stockmoves,
								stockmaster
							WHERE stockmoves.stockid = stockmaster.stockid
							AND stockmoves.type=11
							AND stockmoves.transno='" . $FromTransNo . "'
							AND stockmoves.show_on_inv_crds=1";
                }

                echo '<hr />';
                echo '<div class="centre"><h4>' . _('All amounts stated in') . ' ' . $myrow['currcode'] . '</h4></div>';

                $result = DB_query($sql, $db);
                if (DB_error_no($db) != 0) {
                    echo '<br />' . _('There was a problem retrieving the invoice or credit note stock movement details for invoice number') . ' ' . $FromTransNo . ' ' . _('from the database');
                    if ($debug == 1) {
                        echo '<br />' . _('The SQL used to get this information that failed was') . '<br />' . $sql;
                    }
                    exit;
                }

                if (DB_num_rows($result) > 0) {
                    echo '<table class="table1">
						<tr><th>' . _('Item Code') . '</th>
							<th>' . _('Item Description') . '</th>
							<th>' . _('Quantity') . '</th>
							<th>' . _('Unit') . '</th>
							<th>' . _('Price') . '</th>
							<th>' . _('Discount') . '</th>
							<th>' . _('Net') . '</th>
						</tr>';

                    $LineCounter = 17;
                    $k = 0; //row colour counter

                    while ($myrow2 = DB_fetch_array($result)) {

                        if ($k == 1) {
                            $RowStarter = '<tr class="EvenTableRows">';
                            $k = 0;
                        } else {
                            $RowStarter = '<tr class="OddTableRows">';
                            $k = 1;
                        }

                        echo $RowStarter;

                        $DisplayPrice = locale_number_format($myrow2['fxprice'], 2);
                        $DisplayQty = locale_number_format($myrow2['quantity'], 2);
                        $DisplayNet = locale_number_format($myrow2['fxnet'], 2);

                        if ($myrow2['discountpercent'] == 0) {
                            $DisplayDiscount = '';
                        } else {
                            $DisplayDiscount = locale_number_format($myrow2['discountpercent'] * 100, 2) . '%';
                        }

                        printf('<td>%s</td>
									<td>%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									<td class="number">%s</td>
									</tr>', $myrow2['stockid'], $myrow2['description'], $DisplayQty, $myrow2['units'], $DisplayPrice, $DisplayDiscount, $DisplayNet);

                        if (mb_strlen($myrow2['narrative']) > 1) {
                            echo $RowStarter . '<td></td><td colspan="6">' . $myrow2['narrative'] . '</td></tr>';
                            $LineCounter++;
                        }

                        $LineCounter++;

                        if ($LineCounter == ($_SESSION['PageLength'] - 2)) {

                            /* head up a new invoice/credit note page */

                            $PageNumber++;
                            echo '</table>
								<table class="table1">
								<tr><td valign="top"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
									<td style="background-color:#BBBBBB">';

                            if ($InvOrCredit == 'Invoice') {
                                echo '<h2>' . _('TAX INVOICE') . ' ';
                            } else {
                                echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                            }
                            echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('GST Number') . ' - ' . $_SESSION['CompanyRecord']['gstno'] . '</td></tr></table>';

                            /* Now print out company name and address */
                            echo '<table class="table1"><tr>
						    	<td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                            echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                            echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                            echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                            echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                            echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';
                            echo '</td><td class="number">' . _('Page') . ': ' . $PageNumber . '</td></tr></table>';
                            echo '<table class="table1">
									<tr>
								    	<th>' . _('Item Code') . '</th>
										<th>' . _('Item Description') . '</th>
										<th>' . _('Quantity') . '</th>
										<th>' . _('Unit') . '</th>
										<th>' . _('Price') . '</th>
										<th>' . _('Discount') . '</th>
										<th>' . _('Net') . '</th>
									</tr>';

                            $LineCounter = 10;
                        } //end if need a new page headed up
                    } //end while there are line items to print out
                    echo '</table>';
                } /* end if there are stock movements to show on the invoice or credit note */

                /* check to see enough space left to print the totals/footer */
                $LinesRequiredForText = floor(mb_strlen($myrow['invtext']) / 140);

                if ($LineCounter >= ($_SESSION['PageLength'] - 8 - $LinesRequiredForText)) {

                    /* head up a new invoice/credit note page */
                    $PageNumber++;
                    echo '<table class="table1">
							<tr><td valign="top"><img src="' . $_SESSION['LogoFile'] . '" alt="" /></td>
							<td style="background-color:#BBBBBB">';

                    if ($InvOrCredit == 'Invoice') {
                        echo '<h2>' . _('TAX INVOICE') . ' ';
                    } else {
                        echo '<h2 style="color:red">' . _('TAX CREDIT NOTE') . ' ';
                    }
                    echo _('Number') . ' ' . $FromTransNo . '</h2><br />' . _('GST Number') . ' - ' . $_SESSION['CompanyRecord']['gstno'] . '</td></tr><table>';

                    /* Print out the logo and company name and address */
                    echo '<table class="table1">
							<tr><td><h2>' . $_SESSION['CompanyRecord']['coyname'] . '</h2><br />';
                    echo $_SESSION['CompanyRecord']['regoffice1'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice2'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice3'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice4'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice5'] . '<br />';
                    echo $_SESSION['CompanyRecord']['regoffice6'] . '<br />';
                    echo _('Telephone') . ': ' . $_SESSION['CompanyRecord']['telephone'] . '<br />';
                    echo _('Facsimile') . ': ' . $_SESSION['CompanyRecord']['fax'] . '<br />';
                    echo _('Email') . ': ' . $_SESSION['CompanyRecord']['email'] . '<br />';
                    echo '</td><td class="number">' . _('Page') . ': ' . $PageNumber . '</td></tr></table>';
                    echo '<table class="table1">
							<tr>
								<th>' . _('Item Code') . '</th>
								<th>' . _('Item Description') . '</th>
								<th>' . _('Quantity') . '</th>
								<th>' . _('Unit') . '</th>
								<th>' . _('Price') . '</th>
								<th>' . _('Discount') . '</th>
								<th>' . _('Net') . '</th>
							</tr>';

                    $LineCounter = 10;
                }

                /* Space out the footer to the bottom of the page */

                echo '<br /><br />' . $myrow['invtext'];

                $LineCounter = $LineCounter + 2 + $LinesRequiredForText;
                while ($LineCounter < ($_SESSION['PageLength'] - 6)) {
                    echo '<br />';
                    $LineCounter++;
                }

                /* Now print out the footer and totals */

                if ($InvOrCredit == 'Invoice') {

                    $DisplaySubTot = locale_number_format($myrow['ovamount'], 2);
                    $DisplayFreight = locale_number_format($myrow['ovfreight'], 2);
                    $DisplayTax = locale_number_format($myrow['ovgst'], 2);
                    $DisplayTotal = locale_number_format($myrow['ovfreight'] + $myrow['ovgst'] + $myrow['ovamount'],2);
                } else {
                    $DisplaySubTot = locale_number_format(-$myrow['ovamount'], 2);
                    $DisplayFreight = locale_number_format(-$myrow['ovfreight'], 2);
                    $DisplayTax = locale_number_format(-$myrow['ovgst'], 2);
                    $DisplayTotal = locale_number_format(-$myrow['ovfreight'] - $myrow['ovgst'] - $myrow['ovamount'], 2);
                }


                /* Print out the invoice text entered */
                echo '<table class="table1"><tr>
					<td class="number">' . _('Sub Total') . '</td>
					<td class="number" style="background-color:#EEEEEE;width:15%">' . $DisplaySubTot . '</td></tr>';
                echo '<tr><td class="number">' . _('Freight') . '</td>
					<td class="number" style="background-color:#EEEEEE">' . $DisplayFreight . '</td></tr>';
                echo '<tr><td class="number">' . _('Tax') . '</td>
					<td class="number" style="background-color:#EEEEEE">' . $DisplayTax . '</td></tr>';
                if ($InvOrCredit == 'Invoice') {
                    echo '<tr>
							<td class="number"><b>' . _('TOTAL INVOICE') . '</b></td>
							<td class="number" style="background-color:#EEEEEE"><b>' . $DisplayTotal . '</b></td>
						</tr>';
                } else {
                    echo '<tr>
							<td class="number" style="color:red"><b>' . _('TOTAL CREDIT') . '</b></td>
				     		<td class="number" style="background-color:#EEEEEE;color:red"><b>' . $DisplayTotal . '</b></td>
				     	</tr>';
                }
                echo '</table>';
            } /* end of check to see that there was an invoice record to print */
            $FromTransNo++;
        } /* end loop to print invoices */
    } /* end of if FromTransNo exists */
    include('includes/footer.php');
} /* end of else not PrintPDF */

function PrintLinesToBottom() {

    global $pdf;
    global $PageNumber;
    global $TopOfColHeadings;
    global $Left_Margin;
    global $Bottom_Margin;
    global $line_height;

    /* draw the vertical column lines right to the bottom */
    $pdf->line($Left_Margin + 97, $TopOfColHeadings + 12, $Left_Margin + 97, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 350, $TopOfColHeadings + 12, $Left_Margin + 350, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 450, $TopOfColHeadings + 12, $Left_Margin + 450, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 550, $TopOfColHeadings + 12, $Left_Margin + 550, $Bottom_Margin);

    /* Print a column vertical line */
    $pdf->line($Left_Margin + 587, $TopOfColHeadings + 12, $Left_Margin + 587, $Bottom_Margin);

    $pdf->line($Left_Margin + 640, $TopOfColHeadings + 12, $Left_Margin + 640, $Bottom_Margin);

    $PageNumber++;
}

function getpath($qry) {
    global $xp;
    $prm = array();
    $nodelist = $xp->query($qry);
    foreach ($nodelist as $tmpnode) {
        $prm[] = trim($tmpnode->nodeValue);
    }
    $ret = (sizeof($prm) <= 1) ? $prm[0] : $prm;
    return($ret);
}

function fix_fdoc_arre($fdoc) {
    if (strpos($fdoc, "/") !== FALSE) { // tiene diagonales viene dd/mm/yyyy hh:mm
        list($f, $h) = explode(" ", $fdoc);
        list($d, $m, $y) = explode("/", $f);
        $fdoc = "$y-$m-$d $h";
    }
    return ($fdoc);
}

?>
