﻿Imports FacturacionSDK

Public Class Form1
    Dim sdk As MFSDK = New MFSDK()

    '<summary>
    'Llama la función timbrar y obtiene la respuesta del SDK para mostrarla en pantalla
    '</summary>
    Private Sub timbrarToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles timbrarToolStripMenuItem.Click
        ' Se timbra el CFDI
        'Para agregar varios conceptos con un ciclo ver ejemplo Comercio
        Dim respuesta As SDKRespuesta = sdk.Timbrar("C:\sdk2\timbrar32.bat", "C:\sdk2\timbrados\", "factura", False)
        'Muestra el archivo ini
        textBox1.Text = sdk.Ini
        'Muestra la respuesta de timbrado
        textBox2.Text = respuesta.RespuestaOriginalSDK
        ' Se notifica que el SDK se ejecuto
        Dim mensaje As String = String.Format("Código: {0}" + vbCrLf + "Mensaje: {1}", respuesta.Codigo_MF_Numero, respuesta.Codigo_MF_Texto)
        MessageBox.Show(Me, mensaje, Application.ProductName, MessageBoxButtons.OK, If(respuesta.Codigo_MF_Numero = "0", MessageBoxIcon.Information, MessageBoxIcon.Warning))
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub facturaNormalToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles facturaNormalToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        factura("total") = "1160.00"

        Dim cfdiRelacionados As New MFObject("CfdisRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "XAXX010101000"
        receptor("nombre") = "Público en general"
        receptor("UsoCFDI") = "G01"

        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "700.00"
        concepto0("Importe") = "700.00"
        Dim conimp0 As New MFObject("Impuestos")
        Dim conimp0tras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "700.00"
        contra0("Importe") = "112.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("TipoFactor") = "Tasa"
        conimp0tras.AgregaSubnodo(contra0)
        conimp0.AgregaSubnodo(conimp0tras)
        concepto0.AgregaSubnodo(conimp0)

        Dim concepto1 As New MFObject("1")
        concepto1("ClaveProdServ") = "01010101"
        concepto1("NoIdentificacion") = "COD02"
        concepto1("Cantidad") = "1.00"
        concepto1("ClaveUnidad") = "C81"
        concepto1("Descripcion") = "Producto de prueba 2"
        concepto1("ValorUnitario") = "300.00"
        concepto1("Importe") = "300.00"
        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "300.00"
        contra1("Importe") = "48.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)
        concepto1.AgregaSubnodo(conimp1)

        conceptos.AgregaSubnodo(concepto0)
        conceptos.AgregaSubnodo(concepto1)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "160.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub


    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiNomina12Normal_Click(sender As Object, e As EventArgs) Handles tsmiNomina12Normal.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "500.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "500.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "500.00"
        concepto0("Importe") = "500.00"

        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "500.00"
        nomina("TotalDeducciones") = "250.00"
        nomina("TotalOtrosPagos") = "0.0"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)

        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "546879213"
        nomina.AgregaSubnodo(nemisor)

        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "250.00"
        npercepciones("TotalExento") = "250.00"
        npercepciones("TotalSueldos") = "500.00"

        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "200.00"
        nper0("ImporteExento") = "250.00"
        Dim nper1 As New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "25.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "25.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)

        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiAccionesTitulos_Click(sender As Object, e As EventArgs) Handles tsmiAccionesTitulos.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"

        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nemisor("RfcPatronOrigen") = "LAN7008173R5"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "500.00"
        npercepciones("TotalExento") = "500.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "abc"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "300.00"
        nper0("ImporteExento") = "500.00"
        Dim nper1 As New MFObject("1")
        nper1("TipoPercepcion") = "002"
        nper1("Clave") = "def"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "50.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As New MFObject("2")
        nper2("TipoPercepcion") = "045"
        nper2("Clave") = "ghi"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "150.00"
        nper2("ImporteExento") = "0.00"
        'acciones de nómina
        Dim acciones As New MFObject("AccionesOTitulos")
        acciones("ValorMercado") = "100.00"
        acciones("PrecioAlOtorgarse") = "150.00"
        nper2.AgregaSubnodo(acciones)
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiFiniquito_Click(sender As Object, e As EventArgs) Handles tsmiFiniquito.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "900.00"
        npercepciones("TotalSeparacionIndemnizacion") = "100.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "800.00"
        nper0("ImporteExento") = "100.00"
        Dim nper1 As New MFObject("1")
        nper1("TipoPercepcion") = "023"
        nper1("Clave") = "014"
        nper1("Concepto") = "Separacion"
        nper1("ImporteGravado") = "100.00"
        nper1("ImporteExento") = "0.00"
        'Separación indemnización
        Dim separacion As New MFObject("SeparacionIndemnizacion")
        separacion("TotalPagado") = "10000.00"
        separacion("NumAñosServicio") = "3"
        separacion("UltimoSueldoMensOrd") = "1000.00"
        separacion("IngresoAcumulable") = "100.00"
        separacion("IngresoNoAcumulable") = "9000.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(separacion)
        nomina.AgregaSubnodo(npercepciones)
        'totsueldos+jubpens+sepindem=totgravado+totexcento
        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiGobierno_Click(sender As Object, e As EventArgs) Handles tsmiGobierno.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\SDK2\timbrados\cfdi_ejemplo_factura_nomina_gob" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\SDK2\timbrados\sin_timbrar_ejemplo_factura_nomina_gob" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        'Complemento NominaGobierno
        'MFObject entidad = new MFObject("EntidadSNCF");
        '            entidad["OrigenRecurso"] = "IF";
        '            nemisor.AgregaSubnodo(entidad);

        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "300.00"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "300.00"
        nper1("ImporteExento") = "50.00"
        Dim nper2 As New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "300.00"
        nper2("ImporteExento") = "50.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.0"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiHorasExtra_Click(sender As Object, e As EventArgs) Handles tsmiHorasExtra.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "700.00"
        nper0("ImporteExento") = "100.00"
        Dim nper2 As New MFObject("2")
        nper2("TipoPercepcion") = "019"
        nper2("Clave") = "013"
        nper2("Concepto") = "Horas extra"
        nper2("ImporteGravado") = "200.00"
        nper2("ImporteExento") = "0.00"
        'Horas extra
        Dim horasextra As New MFObject("HorasExtra")
        Dim hora0 As New MFObject("0")
        hora0("Dias") = "2"
        hora0("TipoHoras") = "01"
        hora0("HorasExtra") = "1"
        hora0("ImportePagado") = "200.00"
        horasextra.AgregaSubnodo(hora0)
        nper2.AgregaSubnodo(horasextra)
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nóminas
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiIncapacidad_Click(sender As Object, e As EventArgs) Handles tsmiIncapacidad.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "900.00"
        nper0("ImporteExento") = "100.00"
        npercepciones.AgregaSubnodo(nper0)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        ' Incapacidades
        Dim incapacidades As New MFObject("Incapacidades")
        Dim incapacidad0 As New MFObject("0")
        incapacidad0("DiasIncapacidad") = "2"
        incapacidad0("TipoIncapacidad") = "01"
        incapacidad0("ImporteMonetario") = "300.00"
        incapacidades.AgregaSubnodo(incapacidad0)
        nomina.AgregaSubnodo(incapacidades)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiJubilacion_Click(sender As Object, e As EventArgs) Handles tsmiJubilacion.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "21000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "21000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "21000.00"
        concepto0("Importe") = "21000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "21000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "20900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        npercepciones("TotalJubilacionPensionRetiro") = "20000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "900.00"
        nper0("ImporteExento") = "100.00"
        Dim nper2 As New MFObject("2")
        nper2("TipoPercepcion") = "039"
        nper2("Clave") = "013"
        nper2("Concepto") = "Jubilacion"
        nper2("ImporteGravado") = "20000.00"
        nper2("ImporteExento") = "0.00"
        'Jubilación, pensión, retiro
        Dim jubilacion As New MFObject("JubilacionPensionRetiro")
        jubilacion("IngresoAcumulable") = "1000.00"
        jubilacion("IngresoNoAcumulable") = "3000.00"
        jubilacion("TotalUnaExhibicion") = "16000.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper2)
        npercepciones.AgregaSubnodo(jubilacion)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nómina
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiSubContratacion_Click(sender As Object, e As EventArgs) Handles tsmiSubContratacion.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\SDK2\timbrados\cfdi_ejemplo_factura_nomina_sub" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\SDK2\timbrados\sin_timbrar_ejemplo_factura_nomina_sub" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        'Subcontratación
        Dim subcontratacion As New MFObject("SubContratacion")
        Dim subcontratacion0 As New MFObject("0")
        subcontratacion0("RfcLabora") = "VOC990129I26"
        subcontratacion0("PorcentajeTiempo") = "100.00"
        subcontratacion.AgregaSubnodo(subcontratacion0)
        nreceptor.AgregaSubnodo(subcontratacion)
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "900.00"
        nper0("ImporteExento") = "100.00"
        npercepciones.AgregaSubnodo(nper0)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nóminas
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiSubsidio_Click(sender As Object, e As EventArgs) Handles tsmiSubsidio.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "nomina12")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "99"
        factura("tipocomprobante") = "N"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "6000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "6000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111505"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago de nómina"
        concepto0("ValorUnitario") = "6000.00"
        concepto0("Importe") = "6000.00"
        conceptos.AgregaSubnodo(concepto0)

        Dim nomina As New MFObject("nomina12")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016-10-31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "1000.00"
        nomina("TotalDeducciones") = "250.00"
        nomina("TotalOtrosPagos") = "5000.00"
        'receptor de nómina
        Dim nreceptor As New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As New MFObject("Percepciones")
        npercepciones("TotalGravado") = "900.00"
        npercepciones("TotalExento") = "100.00"
        npercepciones("TotalSueldos") = "1000.00"
        Dim nper0 As New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "900.00"
        nper0("ImporteExento") = "100.00"
        npercepciones.AgregaSubnodo(nper0)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nóminas
        Dim ndeducciones As New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "150.00"
        ndeducciones("TotalImpuestosRetenidos") = "100.00"
        Dim nded0 As New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "100.00"
        Dim nded1 As New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "150.00"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        'Otros pagos
        Dim pagos As New MFObject("OtrosPagos")
        Dim pago0 As New MFObject("0")
        pago0("TipoOtroPago") = "002"
        pago0("Clave") = "012"
        pago0("Concepto") = "Subsidio para el empleo"
        pago0("Importe") = "5000.00"
        'Subsidio al empleo
        Dim subsidio As New MFObject("SubsidioAlEmpleo")
        subsidio("SubsidioCausado") = "5000.00"

        'Compensación saldos a favor
        Dim compensacion As New MFObject("CompensacionSaldosAFavor")
        compensacion("SaldoAFavor") = "300.00"
        compensacion("Año") = "2016"
        compensacion("RemanenteSalFav") = "100.00"
        pago0.AgregaSubnodo(compensacion)
        pago0.AgregaSubnodo(subsidio)
        pagos.AgregaSubnodo(pago0)
        nomina.AgregaSubnodo(pagos)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(nomina)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub escuelaToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles escuelaToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "iedu10")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_escuela" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_escuela" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")


        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("Cantidad") = "1"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Unidad") = "NO APLICA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"

        ' IEDU
        Dim iedu As New MFObject("iedu10")
        iedu("nombreAlumno") = "FULANITO PEREZ OCHOA"
        iedu("CURP") = "MAGC870912HGTRRS06"
        iedu("nivelEducativo") = "Preescolar"
        iedu("autRVOE") = "1234-ABC"
        iedu("rfcPago") = "SOHM7509289MA"

        Dim compl As New MFObject("complemento")
        compl.AgregaSubnodo(iedu)
        concepto0.AgregaSubnodo(compl)
        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "0.00"
        'impuestos["TotalImpuestosRetenidos"] = "0.00";
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "003"
        itra0("Importe") = "0.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        ' Retenciones
        Dim irets As New MFObject("retenidos")
        Dim iret0 As New MFObject("0")
        iret0("Impuesto") = "002"
        iret0("Importe") = "0.00"
        Dim iret1 As New MFObject("1")
        iret1("Impuesto") = "001"
        iret1("Importe") = "0.00"
        irets.AgregaSubnodo(iret0)
        irets.AgregaSubnodo(iret1)
        impuestos.AgregaSubnodo(irets)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub parcialidadToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles parcialidadToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_parcialidades" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_parcialidades" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PPD"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "100.00"
        factura("total") = "116.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "NO APLICA"
        concepto0("ClaveUnidad") = "A90"
        concepto0("descripcion") = "COBRO PARCIALIDAD DE VENTA A90"
        concepto0("valorunitario") = "100.00"
        concepto0("importe") = "100.00"

        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "100.00"
        contra1("Importe") = "16.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)
        concepto0.AgregaSubnodo(conimp1)

        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "16.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "16.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub arrendamientoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles arrendamientoToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_arrendamiento" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_arrendamiento" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "100.00"
        factura("total") = "84.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "NO APLICA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "RENTA DE OFICINA MAYO 2014"
        concepto0("valorunitario") = "100.00"
        concepto0("importe") = "100.00"

        Dim predial As New MFObject("CuentaPredial")
        predial("Numero") = "12345678"
        concepto0.AgregaSubnodo(predial)

        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "100.00"
        contra1("Importe") = "16.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)

        Dim conimp1rets As New MFObject("Retenciones")
        Dim conret1 As New MFObject("0")
        conret1("Base") = "100.00"
        conret1("Importe") = "16.00"
        conret1("Impuesto") = "002"
        conret1("TasaOCuota") = "0.160000"
        conret1("TipoFactor") = "Tasa"
        conimp1rets.AgregaSubnodo(conret1)

        Dim conret2 As New MFObject("1")
        conret2("Base") = "100.00"
        conret2("Importe") = "16.00"
        conret2("Impuesto") = "001"
        conret2("TasaOCuota") = "0.160000"
        conret2("TipoFactor") = "Tasa"
        conimp1rets.AgregaSubnodo(conret2)
        conimp1.AgregaSubnodo(conimp1rets)

        concepto0.AgregaSubnodo(conimp1)

        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "16.00"
        impuestos("TotalImpuestosRetenidos") = "32.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "16.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)

        Dim irets As New MFObject("retenciones")
        Dim ret0 As New MFObject("0")
        ret0("Impuesto") = "002"
        ret0("Importe") = "16.00"
        Dim ret1 As New MFObject("1")
        ret1("Impuesto") = "001"
        ret1("Importe") = "16.00"
        irets.AgregaSubnodo(ret0)
        irets.AgregaSubnodo(ret1)
        impuestos.AgregaSubnodo(itras)
        impuestos.AgregaSubnodo(irets)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub chequeToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles chequeToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "02"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        factura("total") = "1160.00"

        Dim cfdiRelacionados As New MFObject("CfdisRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "XAXX010101000"
        receptor("nombre") = "Público en general"
        receptor("UsoCFDI") = "G01"

        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "700.00"
        concepto0("Importe") = "700.00"
        Dim conimp0 As New MFObject("Impuestos")
        Dim conimp0tras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "700.00"
        contra0("Importe") = "112.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("TipoFactor") = "Tasa"
        conimp0tras.AgregaSubnodo(contra0)
        conimp0.AgregaSubnodo(conimp0tras)
        concepto0.AgregaSubnodo(conimp0)

        Dim concepto1 As New MFObject("1")
        concepto1("ClaveProdServ") = "01010101"
        concepto1("NoIdentificacion") = "COD02"
        concepto1("Cantidad") = "1.00"
        concepto1("ClaveUnidad") = "C81"
        concepto1("Descripcion") = "Producto de prueba 2"
        concepto1("ValorUnitario") = "300.00"
        concepto1("Importe") = "300.00"
        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "300.00"
        contra1("Importe") = "48.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)
        concepto1.AgregaSubnodo(conimp1)

        conceptos.AgregaSubnodo(concepto0)
        conceptos.AgregaSubnodo(concepto1)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "160.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub cancelarToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles cancelarToolStripMenuItem.Click
        ejemplo_cancela_factura()
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub notarioPublicoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles notarioPublicoToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "notariospublicos10")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_notarios" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_notarios" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "PIEZA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        ' Notario Publico
        Dim notario As New MFObject("notariospublicos10")
        Dim datos As New MFObject("DatosNotario")
        datos("CURP") = "AAQM010101HCSMNZ00"
        datos("NumNotaria") = "3"
        datos("EntidadFederativa") = "16"
        datos("Adscripcion") = "Guanajuato"
        notario.AgregaSubnodo(datos)
        ' Descripcion de inmuebles
        Dim inmuebles As New MFObject("DescInmuebles")
        Dim inmueble0 As New MFObject("0")
        inmueble0("Calle") = "Av. Siempre Viva"
        inmueble0("CodigoPostal") = "12345"
        inmueble0("Colonia") = "Bondojito"
        inmueble0("Estado") = "14"
        inmueble0("Localidad") = "Oaxaca"
        inmueble0("Municipio") = "Oaxaca"
        inmueble0("NoExterior") = "123"
        inmueble0("NoInterior") = "B"
        inmueble0("Pais") = "MEX"
        inmueble0("TipoInmueble") = "01"
        inmuebles.AgregaSubnodo(inmueble0)
        notario.AgregaSubnodo(inmuebles)
        'Datos de operación
        Dim datosOperacion As New MFObject("DatosOperacion")
        datosOperacion("NumInstrumentoNotarial") = "12345"
        datosOperacion("FechaInstNotarial") = "2014-04-22"
        datosOperacion("MontoOperacion") = "1234.56"
        datosOperacion("Subtotal") = "1234.56"
        datosOperacion("IVA") = "1234.56"
        notario.AgregaSubnodo(datosOperacion)

        ' Datos de Varios Enajenantes
        '            MFObject enajenantes = new MFObject("NotariosPublicos.DatosEnajenantesCopSC");
        '            MFObject enajenante0 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.0");
        '            enajenante0["Nombre"] = "Enajenante 1";
        '            enajenante0["ApellidoPaterno"] = "Apellido Paterno";
        '            enajenante0["ApellidoMaterno"] = "Apellido Materno";
        '            enajenante0["RFC"] = "HSJ600903MN0";
        '            enajenante0["CURP"] = "OAAJ840102HJCVRN00";
        '            enajenante0["Porcentaje"] = "50";
        '            enajenantes.AgregaSubnodo(enajenante0);
        '
        '            MFObject enajenante1 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.1");
        '            enajenante1["Nombre"] = "Enajenante 2";
        '            enajenante1["ApellidoPaterno"] = "Apellido Paterno";
        '            enajenante1["ApellidoMaterno"] = "Apellido Materno";
        '            enajenante1["RFC"] = "MSB600304KL9";
        '            enajenante1["CURP"] = "OAAJ840102HJCVRN00";
        '            enajenante1["Porcentaje"] = "50";
        '            enajenantes.AgregaSubnodo(enajenante1);
        '
        '            DatosEnajenante datosEnajenante = new DatosEnajenante();
        '            datosEnajenante.CoproSocConyugalE = "Si";
        '            datosEnajenante.DatosEnajenanteCopSC = enajenantes;
        '            

        ' Datos para un Solo Enajenante
        Dim unenajenante As New MFObject("DatosUnEnajenante")
        unenajenante("Nombre") = "Enajenante"
        unenajenante("ApellidoPaterno") = "Apellido Paterno"
        unenajenante("ApellidoMaterno") = "Apellido Materno"
        unenajenante("RFC") = "HSJ600903MN0"
        unenajenante("CURP") = "OAAJ840102HJCVRN00"

        Dim datosEnajenante As New MFObject("DatosEnajenante")
        datosEnajenante("CoproSocConyugalE") = "No"
        datosEnajenante.AgregaSubnodo(unenajenante)
        notario.AgregaSubnodo(datosEnajenante)

        ' Datos de Varios Adquirientes
        '            MFObject adquirientes = new MFObject("DatosAdquirientesCopSC");
        '            MFObject adquiriente0 = new MFObject("0");
        '            adquiriente0["Nombre"] = "Adquiriente 1";
        '            adquiriente0["ApellidoPaterno"] = "Apellido Paterno";
        '            adquiriente0["ApellidoMaterno"] = "Apellido Materno";
        '            adquiriente0["RFC"] = "HSJ600903MN0";
        '            adquiriente0["CURP"] = "OAAJ840102HJCVRN00";
        '            adquiriente0["Porcentaje"] = "50";
        '            adquirientes.AgregaSubnodo(adquiriente0);
        '
        '            MFObject adquiriente1 = new MFObject("1");
        '            adquiriente1["Nombre"] = "Adquiriente 2";
        '            adquiriente1["ApellidoPaterno"] = "Apellido Paterno";
        '            adquiriente1["ApellidoMaterno"] = "Apellido Materno";
        '            adquiriente1["RFC"] = "MSB600304KL9";
        '            adquiriente1["CURP"] = "OAAJ840102HJCVRN00";
        '            adquiriente1["Porcentaje"] = "50";
        '            adquirientes.AgregaSubnodo(adquiriente1);
        '
        '            MFObject datosAdquiriente = new MFObject("DatosAdquiriente");
        '            datosAdquiriente["CoproSocConyugalE"] = "Si";
        '            datosAdquiriente.AgregaSubnodo(adquirientes);
        '            notario.AgregaSubnodo(datosAdquiriente);
        '            


        ' Datos un Solo Adquiriente
        Dim unadquiriente As New MFObject("DatosUnAdquiriente")
        unadquiriente("Nombre") = "Adquiriente"
        unadquiriente("ApellidoPaterno") = "Apellido Paterno"
        unadquiriente("ApellidoMaterno") = "Apellido Materno"
        unadquiriente("RFC") = "HSJ600903MN0"
        unadquiriente("CURP") = "OAAJ840102HJCVRN00"

        Dim datosAdquiriente As New MFObject("DatosAdquiriente")
        datosAdquiriente("CoproSocConyugalE") = "No"
        datosAdquiriente.AgregaSubnodo(unadquiriente)
        notario.AgregaSubnodo(datosAdquiriente)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        'sdk.AgregaObjeto(impuestos);
        sdk.AgregaObjeto(notario)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub doralesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles doralesToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "USD"
        factura("tipocambio") = "18.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        factura("total") = "1160.00"

        Dim cfdiRelacionados As New MFObject("CfdisRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "XAXX010101000"
        receptor("nombre") = "Público en general"
        receptor("UsoCFDI") = "G01"

        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "700.00"
        concepto0("Importe") = "700.00"
        Dim conimp0 As New MFObject("Impuestos")
        Dim conimp0tras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "700.00"
        contra0("Importe") = "112.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("TipoFactor") = "Tasa"
        conimp0tras.AgregaSubnodo(contra0)
        conimp0.AgregaSubnodo(conimp0tras)
        concepto0.AgregaSubnodo(conimp0)

        Dim concepto1 As New MFObject("1")
        concepto1("ClaveProdServ") = "01010101"
        concepto1("NoIdentificacion") = "COD02"
        concepto1("Cantidad") = "1.00"
        concepto1("ClaveUnidad") = "C81"
        concepto1("Descripcion") = "Producto de prueba 2"
        concepto1("ValorUnitario") = "300.00"
        concepto1("Importe") = "300.00"
        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "300.00"
        contra1("Importe") = "48.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)
        concepto1.AgregaSubnodo(conimp1)

        conceptos.AgregaSubnodo(concepto0)
        conceptos.AgregaSubnodo(concepto1)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "160.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub hotelesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles hotelesToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "hoteles")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_hoteles" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_hoteles" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "NO APLICA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "SERVICIO DE HOSPEDAJE 10 AL 25 ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        'Hoteles
        ' Impuestos Locales
        Dim locales As New MFObject("ImpuestosLocales")
        locales("TotaldeRetenciones") = "0.0"
        locales("TotaldeTraslados") = "10.0"
        Dim trasLocales As New MFObject("TrasladoLocal")
        Dim trasLocal0 As New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "ISH"
        trasLocal0("Importe") = "10.00"
        trasLocal0("TasadeTraslado") = "0.03"
        trasLocales.AgregaSubnodo(trasLocal0)
        locales.AgregaSubnodo(trasLocales)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        'sdk.AgregaObjeto(impuestos);
        sdk.AgregaObjeto(locales)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tercerosToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles tercerosToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "terceros11")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_terceros" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_terceros" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "PIEZA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "0.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "0.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        Dim terceros As New MFObject("terceros11")
        terceros("rfc") = "SOHM7509289MA"
        terceros("nombre") = "maria"
        'Domicilio
        Dim domTercero As New MFObject("InformacionFiscalTercero")
        domTercero("Calle") = "JUAREZ"
        domTercero("CodigoPostal") = "64610"
        domTercero("Estado") = "NUEVO LEON"
        domTercero("Municipio") = "MONTERREY"
        domTercero("Localidad") = "MONTERREY"
        domTercero("Pais") = "MEXICO"
        domTercero("NoExterior") = "7"
        domTercero("NoInterior") = "A"
        domTercero("Colonia") = "DEL VALLE"
        domTercero("referencia") = "nuirenfuf"
        terceros.AgregaSubnodo(domTercero)
        'Informaciñon aduanera
        Dim info As New MFObject("InformacionAduanera")
        info("numero") = "2331"
        info("fecha") = "2016-10-31"
        info("aduana") = "miaduana"
        terceros.AgregaSubnodo(info)
        'Partes
        Dim partes As New MFObject("Parte")
        Dim part0 As New MFObject("0")
        part0("cantidad") = "1"
        part0("unidad") = "pieza"
        part0("noIdentificacion") = "56"
        part0("descripcion") = "56vs"
        part0("valorUnitario") = "1000"
        part0("importe") = "1000"
        Dim p0infos As New MFObject("InformacionAduanera")
        Dim p0info0 As New MFObject("0")
        p0info0("numero") = "15"
        p0info0("fecha") = "2017-05-25"
        p0info0("aduana") = "56vs"
        p0infos.AgregaSubnodo(p0info0)
        part0.AgregaSubnodo(p0infos)
        partes.AgregaSubnodo(part0)
        terceros.AgregaSubnodo(partes)
        'Cuenta predial
        Dim predial As New MFObject("CuentaPredial")
        predial("numero") = "56"
        terceros.AgregaSubnodo(predial)
        'Impuestos
        Dim impuestos2 As New MFObject("Impuestos")
        Dim retenciones As New MFObject("Retenciones")
        Dim ret0 As New MFObject("0")
        ret0("impuesto") = "001"
        ret0("importe") = "0.00"
        Dim traslados As New MFObject("Traslados")
        Dim tra0 As New MFObject("0")
        tra0("impuesto") = "003"
        tra0("tasa") = "0.16"
        tra0("importe") = "0.00"
        retenciones.AgregaSubnodo(ret0)
        traslados.AgregaSubnodo(tra0)
        impuestos2.AgregaSubnodo(retenciones)
        impuestos2.AgregaSubnodo(traslados)
        terceros.AgregaSubnodo(impuestos2)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        sdk.AgregaObjeto(terceros)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub impuestosLocalesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles impuestosLocalesToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "implocal10")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_impuestos_locales" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_impuestos_locales" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1160.00"
        '100.00
        Dim emisor As New MFObject("emisor")
        'emisor["rfc"] = "LAN7008173R5";
        'emisor["nombre"] = "General";
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "NA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        Dim conimp1 As New MFObject("Impuestos")
        Dim conimp1tras As New MFObject("Traslados")
        Dim contra1 As New MFObject("0")
        contra1("Base") = "1000.00"
        contra1("Importe") = "160.00"
        contra1("Impuesto") = "002"
        contra1("TasaOCuota") = "0.160000"
        contra1("TipoFactor") = "Tasa"
        conimp1tras.AgregaSubnodo(contra1)
        conimp1.AgregaSubnodo(conimp1tras)
        concepto0.AgregaSubnodo(conimp1)
        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "160.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        ' Impuestos Locales
        Dim locales As New MFObject("implocal10")
        locales("TotaldeRetenciones") = "10"
        locales("TotaldeTraslados") = "10"
        Dim retLocales As New MFObject("RetencionesLocales")
        Dim retLocal0 As New MFObject("0")
        retLocal0("ImpLocRetenido") = "10"
        retLocal0("TasadeRetencion") = "10"
        retLocal0("Importe") = "10"
        'MFObject retLocal1 = new MFObject("1");
        '            retLocal1["ImpLocTrasladado"] = "DEF";
        '            retLocal1["TasadeTraslado"] = "3";
        '            retLocal1["Importe"] = "13";

        retLocales.AgregaSubnodo(retLocal0)
        'retLocales.AgregaSubnodo(retLocal1);
        Dim trasLocales As New MFObject("TrasladosLocales")
        Dim trasLocal0 As New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "10"
        trasLocal0("TasadeTraslado") = "10"
        trasLocal0("Importe") = "10"
        'MFObject trasLocal1 = new MFObject("1");
        '            trasLocal1["ImpLocTrasladado"] = "ASD";
        '            trasLocal1["TasadeTraslado"] = "3";
        '            trasLocal1["Importe"] = "10";

        trasLocales.AgregaSubnodo(trasLocal0)
        'trasLocales.AgregaSubnodo(trasLocal1);
        locales.AgregaSubnodo(retLocales)
        locales.AgregaSubnodo(trasLocales)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        sdk.AgregaObjeto(locales)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub comercioExteriorToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles comercioExteriorToolStripMenuItem.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "comercioexterior11")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_comercio_exterior" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_comercio_exterior" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "300.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "300.00"
        '100.00
        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")

        For i As Integer = 0 To 2
            Dim concepto As New MFObject(i.ToString())
            concepto("ClaveProdServ") = "01010101"
            concepto("ClaveUnidad") = "C81"
            concepto("Cantidad") = "1"
            concepto("Unidad") = "PIEZA"
            concepto("NoIdentificacion") = "COD" + (i + 1).ToString()
            concepto("Descripcion") = "Producto de prueba " + (i + 1).ToString()
            concepto("ValorUnitario") = "100.00"
            concepto("Importe") = "100.00"
            conceptos.AgregaSubnodo(concepto)
        Next

        Dim comercio As New MFObject("comercioexterior11")
        comercio("TipoOperacion") = "2"
        comercio("ClaveDePedimento") = "A1"
        comercio("CertificadoOrigen") = "0"
        'comercio["NumeroExportadorConfiable"] = "0";
        comercio("Incoterm") = "FOB"
        comercio("Subdivision") = "0"
        'comercio["Observaciones"] = "detalles";
        comercio("TipoCambioUSD") = "20.00"
        comercio("TotalUSD") = "15.00"
        'Emisor de comercio
        Dim cemisor As New MFObject("Emisor")
        'creceptor["Curp"] = "BAJS721028MDFMTR05";
        Dim emi_dom As New MFObject("Domicilio")
        emi_dom("Calle") = "Hidalgo"
        emi_dom("NumeroExterior") = "1000"
        emi_dom("Colonia") = "0209"
        'emi_dom["Localidad"] = "11";
        'emi_dom["Referencia"] = "str1234";
        emi_dom("Municipio") = "014"
        emi_dom("Estado") = "QUE"
        emi_dom("Pais") = "MEX"
        emi_dom("CodigoPostal") = "76224"
        cemisor.AgregaSubnodo(emi_dom)
        comercio.AgregaSubnodo(cemisor)
        'Receptor de comercio
        Dim creceptor As New MFObject("Receptor")
        'creceptor["Curp"] = "HEUJ880222HOCTRR04";
        'creceptor["NumRegIdTrib"] = "123456789";
        Dim rec_dom As New MFObject("Domicilio")
        rec_dom("Calle") = "Avenue Sahara"
        rec_dom("NumeroExterior") = "74"
        rec_dom("Colonia") = "BIG DESERT"
        'rec_dom["Localidad"] = "11";
        'rec_dom["Referencia"] = "str1234";
        'rec_dom["Municipio"] = "035";
        rec_dom("Estado") = "NV"
        rec_dom("Pais") = "USA"
        rec_dom("CodigoPostal") = "45678"
        creceptor.AgregaSubnodo(rec_dom)
        comercio.AgregaSubnodo(creceptor)
        'Destinatario de comercio
        '            MFObject cdestinatario = new MFObject("Destinatario");
        '            cdestinatario["NumRegIdTrib"] = "123456789";
        '            cdestinatario["Rfc"] = "ESI920427886";
        '            cdestinatario["Curp"] = "HIOK800212HOCTRR01";
        '            cdestinatario["Nombre"] = "str1234";
        '            //Domicilio
        '            MFObject domicilio = new MFObject("Domicilio");
        '            domicilio["Calle"] = "calle de pruebas";
        '            domicilio["NumeroExterior"] = "1234";
        '            domicilio["Colonia"] = "0995";
        '            domicilio["Localidad"] = "11";
        '            domicilio["Referencia"] = "str1234";
        '            domicilio["Municipio"] = "035";
        '            domicilio["Estado"] = "COA";
        '            domicilio["Pais"] = "MEX";
        '            domicilio["CodigoPostal"] = "27000";
        '            cdestinatario.AgregaSubnodo(domicilio);
        '            comercio.AgregaSubnodo(cdestinatario);

        'Mercancías
        Dim mercancias As New MFObject("Mercancias")
        Dim merc0 As New MFObject("0")
        merc0("NoIdentificacion") = "COD1"
        merc0("FraccionArancelaria") = "94059102"
        merc0("CantidadAduana") = "1"
        merc0("UnidadAduana") = "01"
        merc0("ValorUnitarioAduana") = "5.00"
        merc0("ValorDolares") = "5.00"
        Dim merc1 As New MFObject("1")
        merc1("NoIdentificacion") = "COD2"
        merc1("FraccionArancelaria") = "94059103"
        merc1("CantidadAduana") = "1"
        merc1("UnidadAduana") = "01"
        merc1("ValorUnitarioAduana") = "5.00"
        merc1("ValorDolares") = "5.00"
        Dim merc2 As New MFObject("2")
        merc2("NoIdentificacion") = "COD3"
        merc2("FraccionArancelaria") = "94059104"
        merc2("CantidadAduana") = "1"
        merc2("UnidadAduana") = "01"
        merc2("ValorUnitarioAduana") = "5.00"
        merc2("ValorDolares") = "5.00"
        'Descripciones
        '            MFObject descs = new MFObject("DescripcionesEspecificas");
        '            MFObject desc0 = new MFObject("0");
        '            desc0["Marca"] = "YAMAHA";
        '            desc0["Modelo"] = "DDA - 21";
        '            desc0["SubModelo"] = "DDD1";
        '            desc0["NumeroSerie"] = "3292383823";
        '            MFObject desc1 = new MFObject("1");
        '            desc1["Marca"] = "str12342";
        '            desc1["Modelo"] = "str12342";
        '            desc1["SubModelo"] = "str12342";
        '            desc1["NumeroSerie"] = "3292383823";
        '            descs.AgregaSubnodo(desc0);
        '            descs.AgregaSubnodo(desc1);
        '            merc0.AgregaSubnodo(descs);

        mercancias.AgregaSubnodo(merc0)
        mercancias.AgregaSubnodo(merc1)
        mercancias.AgregaSubnodo(merc2)
        comercio.AgregaSubnodo(mercancias)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(comercio)
        ' Muestras la estructura
        MostrarDatos(sdk)

    End Sub

    'Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
    'Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
    Private Sub tsmiINE_Click(sender As Object, e As EventArgs) Handles tsmiINE.Click
        sdk = New MFSDK()

        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "ine11")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_ine" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_ine" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("subtotal") = "1000.00"
        '100.00
        factura("descuento") = "0.00"
        factura("total") = "1000.00"
        '100.00
        Dim cfdiRelacionados As New MFObject("CfdiRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "PIEZA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "0.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "0.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        Dim ine As New MFObject("ine11")
        ine("TipoProceso") = "Campaña"
        Dim entidad As New MFObject("Entidad")
        Dim entidad0 As New MFObject("0")
        entidad0("ClaveEntidad") = "TAM"
        entidad0("Ambito") = "Local"

        Dim conta As New MFObject("Contabilidad")
        Dim conta0 As New MFObject("0")
        conta0("IdContabilidad") = "010648"
        conta.AgregaSubnodo(conta0)
        entidad0.AgregaSubnodo(conta)
        entidad.AgregaSubnodo(entidad0)
        ine.AgregaSubnodo(entidad)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        sdk.AgregaObjeto(ine)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub cancelarConAcuseToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles cancelarConAcuseToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "pagos10")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\SDK2\timbrados\ejemplo_factura_pagos10.xml")
        sdk.Iniciales.Add("xml_debug", "C:\SDK2\timbrados\debug_ejemplo_pagos10.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim fact As New MFObject("factura")
        fact("serie") = "F"
        fact("folio") = "123"
        fact("fecha_expedicion") = DateTime.Now.ToString("s")
        fact("tipocomprobante") = "P"
        fact("moneda") = "XXX"
        fact("LugarExpedicion") = "27000"
        fact("subtotal") = "0"
        fact("total") = "0"

        Dim emi As New MFObject("emisor")
        emi("rfc") = "LAN7008173R5"
        emi("nombre") = "CINDEMEX SA DE CV"
        emi("RegimenFiscal") = "601"

        Dim recept As New MFObject("receptor")
        recept("rfc") = "SOHM7509289MA"
        recept("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        recept("UsoCFDI") = "P01"

        'Concepto Normal
        Dim concepts As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("Cantidad") = "1"
        concepto0("Descripcion") = "Pago"
        concepto0("ValorUnitario") = "0"
        concepto0("Importe") = "0"
        concepts.AgregaSubnodo(concepto0)

        'Complemento pagos
        Dim Pagos10 As New MFObject("pagos10")
        Dim Pagos As New MFObject("Pagos")
        Dim pago0 As New MFObject("0")
        pago0("FechaPago") = "2017-09-15T11:07:38"
        pago0("FormaDePagoP") = "01"
        pago0("MonedaP") = "MXN"
        pago0("Monto") = "1740.00"
        'Doctos relacionados
        Dim doctos As New MFObject("DoctoRelacionado")
        Dim docto0 As New MFObject("0")
        docto0("IdDocumento") = "2F28D750-688A-43C3-8004-E103086E1D78"
        docto0("Serie") = "F"
        docto0("Folio") = "234"
        docto0("MonedaDR") = "MXN"
        docto0("MetodoDePagoDR") = "PPD"
        docto0("NumParcialidad") = "1"
        docto0("ImpSaldoAnt") = "1740.00"
        docto0("ImpPagado") = "1740.00"
        docto0("ImpSaldoInsoluto") = "0.00"
        doctos.AgregaSubnodo(docto0)
        pago0.AgregaSubnodo(doctos)
        Pagos.AgregaSubnodo(pago0)
        Pagos10.AgregaSubnodo(Pagos)
        'Impuestos
        '            MFObject impuestos = new MFObject("Impuestos");
        '            MFObject imp0 = new MFObject("0");
        '            imp0["TotalImpuestosRetenidos"] = "0.0";
        '            imp0["TotalImpuestosTrasladados"] = "0.0";
        '            MFObject traslados = new MFObject("Traslados");
        '            MFObject tras0 = new MFObject("0");
        '            MFObject retenciones = new MFObject("Retenciones");
        '            MFObject ret0 = new MFObject("0");
        '            tras0["Impuesto"] = "0.0";
        '            tras0["Importe"] = "0.0";
        '            tras0["TipoFactor"] = "0.0";
        '            tras0["TasaOCuota"] = "0.0";
        '            ret0["Importe"] = "0.0";
        '            ret0["Impuesto"] = "0.0";
        '            traslados.AgregaSubnodo(tras0);
        '            retenciones.AgregaSubnodo(ret0);
        '            imp0.AgregaSubnodo(traslados);
        '            imp0.AgregaSubnodo(retenciones);
        '            impuestos.AgregaSubnodo(imp0);
        '            pago0.AgregaSubnodo(impuestos);
        '            Pagos.AgregaSubnodo(pago0);
        '            Pagos10.AgregaSubnodo(Pagos);

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(fact)
        sdk.AgregaObjeto(emi)
        sdk.AgregaObjeto(recept)
        sdk.AgregaObjeto(concepts)
        sdk.AgregaObjeto(Pagos10)
        'Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub consultarSaldoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles consultarSaldoToolStripMenuItem.Click
        ejemplo_consulta_saldo()
    End Sub

    ' <summary>
    'Nodo para la configuración del PAC
    ' </summary>
    Public Function PAC() As MFObject
        Dim p As MFObject = New MFObject("PAC")
        p("usuario") = "DEMO700101XXX"
        p("pass") = "DEMO700101XXX"
        p("produccion") = "NO"
        Return p
    End Function

    ' <summary>
    'Nodo para la configuración del PAC sin campo produccion
    ' </summary>
    Public Function PAC2() As MFObject
        Dim p As MFObject = New MFObject("PAC")
        p("usuario") = "DEMO700101XXX"
        p("pass") = "DEMO700101XXX"
        Return p
    End Function

    ' <summary>
    'Nodo para la configuración de certificados
    ' </summary>
    Public Function Conf() As MFObject
        Dim con As MFObject = New MFObject("conf")
        con("cer") = "C:\SDK2\certificados\lan7008173r5.cer.pem"
        con("key") = "C:\SDK2\certificados\lan7008173r5.key.pem"
        con("pass") = "12345678a"
        Return con
    End Function

    ' <summary>
    'Ejemplo de cancelación de factura
    ' </summary>
    Public Sub ejemplo_cancela_factura()
        sdk = New MFSDK()
        sdk.Iniciales.Add("cfdi", "C:\\SDK2\\timbrados\\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("cancelar", "SI")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    ' <summary>
    'Ejemplo consulta de saldo
    ' </summary>
    Public Sub ejemplo_consulta_saldo()
        sdk = New MFSDK()
        sdk.Iniciales.Add("SALDO", "SI")
        sdk.AgregaObjeto(PAC2())
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    ' <summary>
    'Función que muestra la estructura de la factura en forma de árbol
    'Esta función no necesita ser modificada
    ' </summary>
    Public Sub MostrarDatos(sdk As MFSDK)
        textBox2.Clear()
        treeView1.Nodes.Clear()
        Dim raiz As TreeNode = New TreeNode("Archivo INI") ' Nombre del archivo
        treeView1.Nodes.Add(raiz)
        'Se agregan los campos iniciales a la raíz del árbol
        For Each campo As KeyValuePair(Of String, String) In sdk.Iniciales
            Dim inicia As TreeNode = New TreeNode(campo.Key + "=" + campo.Value)
            raiz.Nodes.Add(inicia)
        Next
        'Se asigna el orden correcto para cada nodo de la factura
        sdk.AsignaValor()
        For Each apa As KeyValuePair(Of String, MFObject) In sdk.Apartados
            Dim nombre As String = apa.Key
            Dim aparta As TreeNode = New TreeNode(nombre)
            For Each dato As KeyValuePair(Of String, String) In apa.Value.Atributos
                Dim info As TreeNode = New TreeNode(dato.Key + "=" + dato.Value)
                aparta.Nodes.Add(info)
            Next
            raiz.Nodes.Add(aparta)
            'Si el apartado tiene subnodos, se recorren
            If apa.Value.Subnodos.Count > 0 Then
                For Each subnodo As KeyValuePair(Of String, MFObject) In apa.Value.Subnodos
                    Dim aps As String = nombre + "." + subnodo.Key
                    recorreSubnodos(aps, subnodo.Value, aparta)
                Next
            End If
        Next
        treeView1.ExpandAll()
    End Sub

    ' <summary>
    'Función recursiva que recorre los subnodos de la factura
    'Esta función no necesita ser modificada
    ' </summary>
    Public Sub recorreSubnodos(apartado As String, subnodo As MFObject, padre As TreeNode)
        'Agrega el nombre y los atributos de los subnodos al árbol
        Dim hijo As TreeNode = New TreeNode(apartado)
        For Each dato As KeyValuePair(Of String, String) In subnodo.Atributos
            Dim info As TreeNode = New TreeNode(dato.Key + "=" + dato.Value)
            hijo.Nodes.Add(info)
        Next
        padre.Nodes.Add(hijo)
        'recorre subnodos del subnodo
        For Each dato As KeyValuePair(Of String, MFObject) In subnodo.Subnodos
            Dim respaldo As String = apartado
            Dim nombre As String = dato.Key
            apartado += "." + nombre
            recorreSubnodos(apartado, dato.Value, hijo)
            apartado = respaldo
        Next
    End Sub

    ' <summary>
    'Nodo complemento de todos los tipos de nómina 
    ' </summary>
    Public Function complementoNominaTodo() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        'receptor de nómina
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nreceptor("Sindicalizado") = ""
        nreceptor("TipoJornada") = ""
        'subcontratación
        Dim subcontratacion As MFObject = New MFObject("SubContratacion")
        subcontratacion("RfcLabora") = "VOC990129I26"
        subcontratacion("PorcentajeTiempo") = "100.00"
        nreceptor.AgregaSubnodo(subcontratacion)
        nomina.AgregaSubnodo(nreceptor)
        'emisor de nómina
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        'Complemento NominaGobierno
        Dim entidad As MFObject = New MFObject("EntidadSNCF")
        entidad("OrigenRecurso") = "IF"
        nemisor.AgregaSubnodo(entidad)
        nomina.AgregaSubnodo(nemisor)
        'percepciones de nómina
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        npercepciones("TotalSeparacionIndemnizacion") = "15000.00"
        npercepciones("TotalJubilacionPensionRetiro") = "21300.00"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        'Complemento horas extra
        Dim horasextra As MFObject = New MFObject("HorasExtra")
        Dim hora0 As MFObject = New MFObject("0")
        hora0("Dias") = "2"
        hora0("TipoHoras") = "01"
        hora0("HorasExtra") = "8"
        hora0("ImportePagado") = "105.70"
        Dim hora1 As MFObject = New MFObject("1")
        hora1("Dias") = "1"
        hora1("TipoHoras") = "02"
        hora1("HorasExtra") = "6"
        hora1("ImportePagado") = "1000.00"
        horasextra.AgregaSubnodo(hora0)
        horasextra.AgregaSubnodo(hora1)
        nper2.AgregaSubnodo(horasextra)
        Dim percepcion3 As MFObject = New MFObject("3")
        percepcion3("TipoPercepcion") = "045"
        percepcion3("Clave") = "045"
        percepcion3("Concepto") = "Premios por puntualidad"
        percepcion3("ImporteGravado") = "3000.00"
        percepcion3("ImporteExento") = "0.00"
        'Complemento acciones
        Dim acciones As MFObject = New MFObject("AccionesOTitulos")
        acciones("ValorMercado") = "1000.00"
        acciones("PrecioAlOtorgarse") = "2000.00"
        percepcion3.AgregaSubnodo(acciones)
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        npercepciones.AgregaSubnodo(percepcion3)
        'Complemento jubilación
        Dim jubilacion As MFObject = New MFObject("JubilacionPensionRetiro")
        jubilacion("IngresoAcumulable") = "1000.00"
        jubilacion("IngresoNoAcumulable") = "300.00"
        jubilacion("TotalUnaExhibicion") = "20000.00"
        npercepciones.AgregaSubnodo(jubilacion)
        'Complemento separación
        Dim separacion As MFObject = New MFObject("SeparacionIndemnizacion")
        separacion("TotalPagado") = "15000.00"
        separacion("NumAñosServicio") = "3"
        separacion("UltimoSueldoMensOrd") = "5000.00"
        separacion("IngresoAcumulable") = "3000.00"
        separacion("IngresoNoAcumulable") = "1000.00"
        npercepciones.AgregaSubnodo(separacion)
        nomina.AgregaSubnodo(npercepciones)
        'deducciones de nómina
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        'Complemento otros pagos
        Dim Pagos As MFObject = New MFObject("OtrosPagos")
        Dim pago0 As MFObject = New MFObject("0")
        pago0("TipoOtroPago") = "002"
        pago0("Clave") = "012"
        pago0("Concepto") = "Subsidio para el empleo"
        pago0("Importe") = "5000.00"
        'Complemento subsidio
        Dim subsidio As MFObject = New MFObject("SubsidioAlEmpleo")
        subsidio("SubsidioCausado") = "5000.00"

        'Compensación saldos a favor
        Dim compensacion As MFObject = New MFObject("CompensacionSaldosAFavor")
        compensacion("SaldoAFavor") = "300.00"
        compensacion("Año") = "2017"
        compensacion("RemanenteSalFav") = "100.00"
        pago0.AgregaSubnodo(compensacion)
        pago0.AgregaSubnodo(subsidio)
        Pagos.AgregaSubnodo(pago0)
        nomina.AgregaSubnodo(Pagos)
        ' Incapacidades
        Dim incapacidades As MFObject = New MFObject("Incapacidades")
        Dim incapacidad0 As MFObject = New MFObject("0")
        incapacidad0("DiasDeIncapacidad") = "2"
        incapacidad0("TipoIncapacidad") = "01"
        incapacidad0("ImporteMonetario") = "300.00"
        incapacidades.AgregaSubnodo(incapacidad0)
        nomina.AgregaSubnodo(incapacidades)
        Return nomina
    End Function

    ' <summary>
    'Nodo complemento de comercio exterior
    ' </summary>
    Public Function complementoComercio() As MFObject
        Dim comercio As MFObject = New MFObject("Comercio")
        comercio("TipoOperacion") = "2"
        comercio("ClaveDePedimento") = "A1"
        comercio("CertificadoOrigen") = "0"
        comercio("NumeroExportadorConfiable") = "0"
        comercio("Incoterm") = "FOB"
        comercio("Subdivision") = "0"
        comercio("Observaciones") = "detalles"
        comercio("TipoCambioUSD") = "10.23"
        comercio("TotalUSD") = "116.00"
        'Receptor de comercio
        Dim creceptor As MFObject = New MFObject("Receptor")
        creceptor("Curp") = "HEUJ880222HOCTRR04"
        creceptor("NumRegIdTrib") = "123456789"
        comercio.AgregaSubnodo(creceptor)
        'Destinatario de comercio
        Dim cdestinatario As MFObject = New MFObject("Destinatario")
        cdestinatario("NumRegIdTrib") = "123456789"
        cdestinatario("Rfc") = "ESI920427886"
        cdestinatario("Curp") = "HIOK800212HOCTRR01"
        cdestinatario("Nombre") = "str1234"
        'Domicilio
        Dim domicilio As MFObject = New MFObject("Domicilio")
        domicilio("Calle") = "calle de pruebas"
        domicilio("NumeroExterior") = "1234"
        domicilio("Colonia") = "0995"
        domicilio("Localidad") = "11"
        domicilio("Referencia") = "str1234"
        domicilio("Municipio") = "035"
        domicilio("Estado") = "COA"
        domicilio("Pais") = "MEX"
        domicilio("CodigoPostal") = "27000"
        cdestinatario.AgregaSubnodo(domicilio)
        comercio.AgregaSubnodo(cdestinatario)
        'Mercancías
        Dim mercancias As MFObject = New MFObject("Mercancias")
        Dim merc0 As MFObject = New MFObject("0")
        merc0("NoIdentificacion") = "A-1215"
        merc0("FraccionArancelaria") = "01011001"
        merc0("CantidadAduana") = "1.0"
        merc0("UnidadAduana") = "1"
        merc0("ValorUnitarioAduana") = "116.00"
        merc0("ValorDolares") = "116.00"
        'Descripciones
        Dim descs As MFObject = New MFObject("DescripcionesEspecificas")
        Dim desc0 As MFObject = New MFObject("0")
        desc0("Marca") = "YAMAHA"
        desc0("Modelo") = "DDA - 21"
        desc0("SubModelo") = "DDD1"
        desc0("NumeroSerie") = "3292383823"
        Dim desc1 As MFObject = New MFObject("1")
        desc1("Marca") = "str12342"
        desc1("Modelo") = "str12342"
        desc1("SubModelo") = "str12342"
        desc1("NumeroSerie") = "3292383823"
        descs.AgregaSubnodo(desc0)
        descs.AgregaSubnodo(desc1)
        merc0.AgregaSubnodo(descs)
        mercancias.AgregaSubnodo(merc0)
        comercio.AgregaSubnodo(mercancias)
        Return comercio
    End Function

    ' <summary>
    'Nodo complemento INE
    ' </summary>
    Public Function complementoINE() As MFObject
        Dim INE As MFObject = New MFObject("INE")
        INE("TipoProceso") = "Campaña"
        Dim entidad As MFObject = New MFObject("Entidad")
        Dim entidad0 As MFObject = New MFObject("0")
        entidad0("ClaveEntidad") = "TAM"
        entidad0("Ambito") = "Local"
        entidad.AgregaSubnodo(entidad0)
        Dim conta As MFObject = New MFObject("Contabilidad")
        Dim conta0 As MFObject = New MFObject("0")
        conta0("idContabilidad") = "010648"
        conta.AgregaSubnodo(conta0)
        entidad.AgregaSubnodo(conta)
        INE.AgregaSubnodo(entidad)
        Return INE
    End Function

    ' <summary>
    'Nodo complemento de notarios públicos
    ' </summary>
    Public Function complementoNotariosPublicos() As MFObject
        ' Notario Publico
        Dim notario As MFObject = New MFObject("NotariosPublicos")
        notario("CURP") = "AAQM010101HCSMNZ00"
        notario("NumNotaria") = "3"
        notario("EntidadFederativa") = "16"
        notario("Adscripcion") = "Guanajuato"
        ' Descripcion de inmuebles
        Dim inmuebles As MFObject = New MFObject("DescInmuebles")
        Dim inmueble0 As MFObject = New MFObject("0")
        inmueble0("Calle") = "Av. Siempre Viva"
        inmueble0("CodigoPostal") = "12345"
        inmueble0("Colonia") = "Bondojito"
        inmueble0("Estado") = "14"
        inmueble0("Localidad") = "Oaxaca"
        inmueble0("Municipio") = "Oaxaca"
        inmueble0("NoExterior") = "123"
        inmueble0("NoInterior") = "B"
        inmueble0("Pais") = "MEX"
        inmueble0("TipoInmueble") = "01"
        inmuebles.AgregaSubnodo(inmueble0)
        notario.AgregaSubnodo(inmuebles)
        'Datos de operación
        Dim datosOperacion As MFObject = New MFObject("DatosOperacion")
        datosOperacion("NumInstrumentoNotarial") = "12345"
        datosOperacion("FechaInstNotarial") = "2014-04-22"
        datosOperacion("MontoOperacion") = "1234.56"
        datosOperacion("Subtotal") = "1234.56"
        datosOperacion("IVA") = "1234.56"
        notario.AgregaSubnodo(datosOperacion)

        ' Datos de Varios Enajenantes
        'Dim enajenantes As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC")
        'Dim enajenante0 As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC.0")
        'enajenante0("Nombre") = "Enajenante 1"
        'enajenante0("ApellidoPaterno") = "Apellido Paterno"
        'enajenante0("ApellidoMaterno") = "Apellido Materno"
        'enajenante0("RFC") = "HSJ600903MN0"
        'enajenante0("CURP") = "OAAJ840102HJCVRN00"
        'enajenante0("Porcentaje") = "50"
        'enajenantes.AgregaSubnodo(enajenante0)

        'Dim enajenante1 As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC.1")
        'enajenante1("Nombre") = "Enajenante 2"
        'enajenante1("ApellidoPaterno") = "Apellido Paterno"
        'enajenante1("ApellidoMaterno") = "Apellido Materno"
        'enajenante1("RFC") = "MSB600304KL9"
        'enajenante1("CURP") = "OAAJ840102HJCVRN00"
        'enajenante1("Porcentaje") = "50"
        'enajenantes.AgregaSubnodo(enajenante1)

        'Dim datosEnajenante As MFObject = New MFObject("DatosEnajenante")
        'datosEnajenante["CoproSocConyugalE"] = "Si"
        'datosEnajenante.AgregaSubnodo(enajenantes)
        ' Datos para un Solo Enajenante
        Dim unenajenante As MFObject = New MFObject("DatosUnEnajenante")
        unenajenante("Nombre") = "Enajenante"
        unenajenante("ApellidoPaterno") = "Apellido Paterno"
        unenajenante("ApellidoMaterno") = "Apellido Materno"
        unenajenante("RFC") = "HSJ600903MN0"
        unenajenante("CURP") = "OAAJ840102HJCVRN00"

        Dim datosEnajenante As MFObject = New MFObject("DatosEnajenante")
        datosEnajenante("CoproSocConyugalE") = "No"
        datosEnajenante.AgregaSubnodo(unenajenante)
        notario.AgregaSubnodo(datosEnajenante)

        ' Datos de Varios Adquirientes
        'Dim As MFObject adquirientes = New MFObject("DatosAdquirientesCopSC")
        'Dim As MFObject adquiriente0 = New MFObject("0")
        'adquiriente0("Nombre") = "Adquiriente 1"
        'adquiriente0("ApellidoPaterno") = "Apellido Paterno"
        'adquiriente0("ApellidoMaterno") = "Apellido Materno"
        'adquiriente0("RFC") = "HSJ600903MN0"
        'adquiriente0("CURP") = "OAAJ840102HJCVRN00"
        'adquiriente0("Porcentaje") = "50"
        'adquirientes.AgregaSubnodo(adquiriente0)

        'Dim As MFObject adquiriente1 = New MFObject("1")
        'adquiriente1("Nombre") = "Adquiriente 2"
        'adquiriente1("ApellidoPaterno") = "Apellido Paterno"
        'adquiriente1("ApellidoMaterno") = "Apellido Materno"
        'adquiriente1("RFC") = "MSB600304KL9"
        'adquiriente1("CURP") = "OAAJ840102HJCVRN00"
        'adquiriente1("Porcentaje") = "50"
        'adquirientes.AgregaSubnodo(adquiriente1)

        'Dim As MFObject datosAdquiriente = New MFObject("DatosAdquiriente")
        'datosAdquiriente("CoproSocConyugalE") = "Si"
        'datosAdquiriente.AgregaSubnodo(adquirientes)
        'notario.AgregaSubnodo(datosAdquiriente)

        ' Datos un Solo Adquiriente
        Dim unadquiriente As MFObject = New MFObject("DatosUnAdquiriente")
        unadquiriente("Nombre") = "Adquiriente"
        unadquiriente("ApellidoPaterno") = "Apellido Paterno"
        unadquiriente("ApellidoMaterno") = "Apellido Materno"
        unadquiriente("RFC") = "HSJ600903MN0"
        unadquiriente("CURP") = "OAAJ840102HJCVRN00"

        Dim datosAdquiriente As MFObject = New MFObject("DatosAdquiriente")
        datosAdquiriente("CoproSocConyugalE") = "No"
        datosAdquiriente.AgregaSubnodo(unadquiriente)
        notario.AgregaSubnodo(datosAdquiriente)
        Return notario
    End Function

    ' <summary>
    'Nodo complemento escuelas
    ' </summary>
    Public Function complementoEscuela() As MFObject
        ' IEDU
        Dim IEDU As MFObject = New MFObject("IEDU")
        IEDU("nombreAlumno") = "FULANITO PEREZ OCHOA"
        IEDU("CURP") = "MAGC870912HGTRRS06"
        IEDU("nivelEducativo") = "Preescolar"
        IEDU("autRVOE") = "1234-ABC"
        IEDU("RFCPago") = "SOHM7509289MA"
        Return IEDU
    End Function

    ' <summary>
    'Nodo complemento hoteles
    ' </summary>
    Public Function complementoHoteles() As MFObject
        'Hoteles
        ' Impuestos Locales
        Dim locales As MFObject = New MFObject("ImpuestosLocales")
        Dim trasLocales As MFObject = New MFObject("TrasladoLocal")
        Dim trasLocal0 As MFObject = New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "ISH"
        trasLocal0("Importe") = "10"
        trasLocal0("TasadeTraslado") = "3"
        trasLocales.AgregaSubnodo(trasLocal0)
        locales.AgregaSubnodo(trasLocales)
        Return locales
    End Function

    ' <summary>
    'Nodo complemento terceros
    ' </summary>
    Public Function complementoTerceros() As MFObject
        Dim terceros As MFObject = New MFObject("terceros11")
        terceros("rfc") = "SOHM7509289MA"
        terceros("nombre") = "maria"
        'Domicilio
        Dim domTercero As MFObject = New MFObject("InformacionFiscalTercero")
        domTercero("Calle") = "JUAREZ"
        domTercero("CodigoPostal") = "64610"
        domTercero("Estado") = "NUEVO LEON"
        domTercero("Municipio") = "MONTERREY"
        domTercero("Localidad") = "MONTERREY"
        domTercero("Pais") = "MEXICO"
        domTercero("NoExterior") = "7"
        domTercero("NoInterior") = "A"
        domTercero("Colonia") = "DEL VALLE"
        domTercero("referencia") = "nuirenfuf"
        terceros.AgregaSubnodo(domTercero)
        'Informaciñon aduanera
        Dim info As MFObject = New MFObject("InformacionAduanera")
        info("numero") = "2331"
        info("fecha") = "2016-10-31"
        info("aduana") = "miaduana"
        terceros.AgregaSubnodo(info)
        'Partes
        Dim partes As MFObject = New MFObject("Parte")
        Dim part0 As MFObject = New MFObject("0")
        part0("cantidad") = "1"
        part0("unidad") = "pieza"
        part0("noIdentificacion") = "56"
        part0("descripcion") = "56vs"
        part0("valorUnitario") = "1000"
        part0("importe") = "1000"
        Dim p0infos As MFObject = New MFObject("InformacionAduanera")
        Dim p0info0 As MFObject = New MFObject("0")
        p0info0("numero") = "15"
        p0info0("fecha") = "2017-05-25"
        p0info0("aduana") = "56vs"
        p0infos.AgregaSubnodo(p0info0)
        part0.AgregaSubnodo(p0infos)
        partes.AgregaSubnodo(part0)
        'Cuenta predial
        terceros.AgregaSubnodo(partes)
        Dim predial As MFObject = New MFObject("CuentaPredial")
        predial("numero") = "56"
        terceros.AgregaSubnodo(predial)
        'Impuestos
        Dim impuestos As MFObject = New MFObject("Impuestos")
        Dim retenciones As MFObject = New MFObject("Retenciones")
        Dim ret0 As MFObject = New MFObject("0")
        ret0("impuesto") = "001"
        ret0("importe") = "0.00"
        Dim traslados As MFObject = New MFObject("Traslados")
        Dim tra0 As MFObject = New MFObject("0")
        tra0("impuesto") = "003"
        tra0("tasa") = "0.16"
        tra0("importe") = "0.00"
        retenciones.AgregaSubnodo(ret0)
        traslados.AgregaSubnodo(tra0)
        impuestos.AgregaSubnodo(retenciones)
        impuestos.AgregaSubnodo(traslados)
        Return terceros
    End Function

    ' <summary>
    'Nodo complemento de impuestos locales
    ' </summary>
    Public Function complementoImpLocales() As MFObject
        ' Impuestos Locales
        Dim locales As MFObject = New MFObject("ImpuestosLocales")
        Dim retLocales As MFObject = New MFObject("RetencionLocal")
        Dim retLocal0 As MFObject = New MFObject("0")
        retLocal0("ImpLocTrasladado") = "ABC"
        retLocal0("TasadeTraslado") = "2"
        retLocal0("Importe") = "11"
        Dim retLocal1 As MFObject = New MFObject("1")
        retLocal1("ImpLocTrasladado") = "DEF"
        retLocal1("TasadeTraslado") = "3"
        retLocal1("Importe") = "13"
        retLocales.AgregaSubnodo(retLocal0)
        retLocales.AgregaSubnodo(retLocal1)
        Dim trasLocales As MFObject = New MFObject("TrasladoLocal")
        Dim trasLocal0 As MFObject = New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "XYZ"
        trasLocal0("TasadeTraslado") = "3"
        trasLocal0("Importe") = "10"
        Dim trasLocal1 As MFObject = New MFObject("1")
        trasLocal1("ImpLocTrasladado") = "ASD"
        trasLocal1("TasadeTraslado") = "3"
        trasLocal1("Importe") = "10"
        trasLocales.AgregaSubnodo(trasLocal0)
        trasLocales.AgregaSubnodo(trasLocal1)
        locales.AgregaSubnodo(retLocales)
        locales.AgregaSubnodo(trasLocales)
        Return locales
    End Function

    ' <summary>
    'Nodo complemento parciales construcción
    ' </summary>
    Public Function complementoParcialesConstruccion() As MFObject
        Dim parciales As MFObject = New MFObject("ParcialesConstruccion")
        parciales("NumPerLicoAut") = "12345678901234567890"
        Dim inmueble As MFObject = New MFObject("Inmueble")
        inmueble("Calle") = "Juarez"
        inmueble("NoExterior") = "1025"
        inmueble("NoInterior") = "5"
        inmueble("Colonia") = "Centro"
        inmueble("Localidad") = "Torreon"
        inmueble("Referencia") = "Entre Hidalgo y Morelos"
        inmueble("Municipio") = "Torreon"
        inmueble("Estado") = "09"
        inmueble("CodigoPostal") = "27054"
        parciales.AgregaSubnodo(inmueble)
        Return parciales
    End Function

    ' <summary>
    'Nodo complemento acreditamiento IEPS
    ' </summary>
    Public Function complementoAcreditamientoIEPS() As MFObject
        Dim acredita As MFObject = New MFObject("AcreditamientoIEPS")
        acredita("TAR") = "690"
        Return acredita
    End Function

    ' <summary>
    'Nodo complemento aerolineas
    ' </summary>
    Public Function complementoAerolineas() As MFObject
        Dim aerolineas As MFObject = New MFObject("Aerolineas")
        aerolineas("TUA") = "2000.00"
        Dim otrosCargos As MFObject = New MFObject("OtrosCargos")
        otrosCargos("TotalCargos") = "2"
        Dim cargo0 As MFObject = New MFObject("0")
        cargo0("CodigoCargo") = "22990"
        cargo0("Importe") = "1000.00"
        Dim cargo1 As MFObject = New MFObject("1")
        cargo1("CodigoCargo") = "14678"
        cargo1("Importe") = "1000.00"
        otrosCargos.AgregaSubnodo(cargo0)
        otrosCargos.AgregaSubnodo(cargo1)
        aerolineas.AgregaSubnodo(otrosCargos)
        Return aerolineas
    End Function

    ' <summary>
    'Nodo complemento certificado de destrucción
    ' </summary>
    Public Function complementoCertificadoDestruccion() As MFObject
        Dim destruccion As MFObject = New MFObject("CertificadoDeDestruccion")
        destruccion("Serie") = "27833"
        destruccion("NumFolDesVeh") = "A1"

        Dim vehiculo As MFObject = New MFObject("VehiculoDestruido")
        vehiculo("Marca") = "ford"
        vehiculo("Año") = "2000"
        vehiculo("Modelo") = "FOB"
        vehiculo("NIV") = "te0"
        vehiculo("NumSerie") = "gera43"
        vehiculo("NumPlacas") = "1034"
        vehiculo("NumMotor") = "116"
        vehiculo("NumFolTarjCir") = "DESO801116HGTLRS08"

        Dim infoa As MFObject = New MFObject("InformacionAduanera")
        infoa("NumPedImp") = "HEUJ880222HOCTRR04"
        infoa("Fecha") = "05-04-2017"
        infoa("Aduana") = "123456789"
        destruccion.AgregaSubnodo(vehiculo)
        destruccion.AgregaSubnodo(infoa)
        Return destruccion
    End Function

    ' <summary>
    'Nodo complemento CFDI Registro fiscal
    ' </summary>
    Public Function complementoCFDIRegistroFiscal() As MFObject
        Dim regfis As MFObject = New MFObject("CFDIRegistroFiscal")
        regfis("Folio") = "29547033879512844"
        Return regfis
    End Function

    ' <summary>
    'Nodo complemento consumo de combustibles
    ' </summary>
    Public Function complementoConsumoCombustibles() As MFObject
        Dim consumo As MFObject = New MFObject("ConsumoDeCombustibles")
        consumo("tipoOperacion") = "gref"
        consumo("numeroDeCuenta") = "908545"
        consumo("subTotal") = "8947.50"
        consumo("total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("identificador") = "123"
        concepto0("fecha") = "05-04-2017"
        concepto0("rfc") = "gaar930830mcl"
        concepto0("claveEstacion") = "8"
        concepto0("cantidad") = "4"
        concepto0("nombreCombustible") = "oil"
        concepto0("folioOperacion") = "243"
        concepto0("valorUnitario") = "35.50"
        concepto0("importe") = "142.00"

        Dim determinados As MFObject = New MFObject("Determinados")
        Dim det0 As MFObject = New MFObject("0")
        det0("impuesto") = "IVA"
        det0("tasa") = "0.16"
        det0("importe") = "130.00"
        Dim det1 As MFObject = New MFObject("1")
        det1("impuesto") = "IEPS"
        det1("tasa") = "0.17"
        det1("importe") = "135.00"
        determinados.AgregaSubnodo(det0)
        determinados.AgregaSubnodo(det1)
        concepto0.AgregaSubnodo(determinados)
        conceptos.AgregaSubnodo(concepto0)

        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("identificador") = "456"
        concepto1("fecha") = "05-04-2017"
        concepto1("rfc") = "gaar930830mcl"
        concepto1("claveEstacion") = "8"
        concepto1("cantidad") = "4"
        concepto1("nombreCombustible") = "oil"
        concepto1("folioOperacion") = "243"
        concepto1("valorUnitario") = "35.50"
        concepto1("importe") = "142.00"

        Dim con1dets As MFObject = New MFObject("Determinados")
        Dim con1det0 As MFObject = New MFObject("0")
        con1det0("impuesto") = "IVA"
        con1det0("tasa") = "0.16"
        con1det0("importe") = "130.00"
        con1dets.AgregaSubnodo(con1det0)
        concepto1.AgregaSubnodo(con1dets)
        conceptos.AgregaSubnodo(concepto1)
        consumo.AgregaSubnodo(conceptos)
        Return consumo
    End Function

    ' <summary>
    'Nodo complemento divisas
    ' </summary>
    Public Function complementoDivisas() As MFObject
        Dim divisas As MFObject = New MFObject("Divisas")
        divisas("tipoOperacion") = "compra"
        Return divisas
    End Function

    ' <summary>
    'Nodo complemento donatarias
    ' </summary>
    Public Function complementoDonatarias() As MFObject
        Dim donat As MFObject = New MFObject("Donatarias")
        donat("noAutorizacion") = "29"
        donat("fechaAutorizacion") = "05-04-2017"
        donat("leyEnd Functiona") = "mileyEnd Functiona"
        Return donat
    End Function

    ' <summary>
    'Nodo complemento estado de cuenta de combustible
    ' </summary>
    Public Function complementoEstadoCuentaComb() As MFObject

        Dim ecc As MFObject = New MFObject("EstadoDeCuentaCombustible")
        ecc("TipoOperacion") = "gref"
        ecc("NumeroDeCuenta") = "908545"
        ecc("SubTotal") = "8947.50"
        ecc("Total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("Identificador") = "123"
        concepto0("Fecha") = "05-04-2017"
        concepto0("Rfc") = "gaar930830mcl"
        concepto0("ClaveEstacion") = "8"
        concepto0("TAR") = "667"
        concepto0("Cantidad") = "4"
        concepto0("NoIdentificacion") = "51"
        concepto0("Unidad") = "32011"
        concepto0("NombreCombustible") = "oil"
        concepto0("FolioOperacion") = "243"
        concepto0("ValorUnitario") = "35.50"
        concepto0("Importe") = "142.00"

        Dim traslados As MFObject = New MFObject("Traslados")
        Dim tras0 As MFObject = New MFObject("0")
        tras0("Impuesto") = "IVA"
        tras0("TasaoCuota") = "0.16"
        tras0("Importe") = "130.00"
        Dim tras1 As MFObject = New MFObject("1")
        tras1("Impuesto") = "IEPS"
        tras1("TasaoCuota") = "0.17"
        tras1("Importe") = "135.00"
        traslados.AgregaSubnodo(tras0)
        traslados.AgregaSubnodo(tras1)
        concepto0.AgregaSubnodo(traslados)
        conceptos.AgregaSubnodo(concepto0)

        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("Identificador") = "456"
        concepto1("Fecha") = "05-04-2017"
        concepto1("Rfc") = "gaar930830mcl"
        concepto1("ClaveEstacion") = "8"
        concepto1("TAR") = "667"
        concepto1("Cantidad") = "4"
        concepto1("NoIdentificacion") = "51"
        concepto1("Unidad") = "32011"
        concepto1("NombreCombustible") = "oil"
        concepto1("FolioOperacion") = "243"
        concepto1("ValorUnitario") = "35.50"
        concepto1("Importe") = "142.00"

        Dim con0tras0 As MFObject = New MFObject("0")
        con0tras0("Impuesto") = "IEPS"
        con0tras0("TasaoCuota") = "0.16"
        con0tras0("Importe") = "130.00"
        concepto0.AgregaSubnodo(con0tras0)
        conceptos.AgregaSubnodo(concepto1)
        ecc.AgregaSubnodo(conceptos)
        Return ecc
    End Function

    ' <summary>
    'Nodo complemento leyendas fiscales
    ' </summary>
    Public Function complementoLeyendasFisc() As MFObject
        Dim leyendas As MFObject = New MFObject("LeyendasFiscales")
        Dim ley0 As MFObject = New MFObject("0")
        Dim ley1 As MFObject = New MFObject("1")
        ley0("disposicionFiscal") = "htr"
        ley0("norma") = "grea"
        ley0("textoLeyEnd Functiona") = "ergtr"

        ley1("disposicionFiscal") = "hrdy"
        ley1("norma") = "dwq"
        ley1("textoLeyEnd Functiona") = "fwe"
        leyendas.AgregaSubnodo(ley0)
        leyendas.AgregaSubnodo(ley1)
        Return leyendas
    End Function

    ' <summary>
    'Nodo complemento obras y antigüedades
    ' </summary>
    Public Function complementoObrasAntiguedades() As MFObject
        Dim arte As MFObject = New MFObject("ObrasArteAntiguedades")
        arte("TipoBien") = "02"
        arte("OtrosTipoBien") = "miarte"
        arte("TituloAdquirido") = "03"
        arte("OtrosTituloAdquirido") = "mititulo"
        arte("Subtotal") = "160.00"
        arte("IVA") = "16.00"
        arte("FechaAdquisicion") = "05-04-2017"
        arte("CaracterísticasDeObraoPieza") = "07"
        Return arte
    End Function

    ' <summary>
    'Nodo complemento pago en especie
    ' </summary>
    Public Function complementoPagoEnEspecie() As MFObject
        Dim pagos As MFObject = New MFObject("PagoEnEspecie")
        pagos("CvePIC") = "X100081000986725341974620" ' (A - ZÑ&)3End Function(0-9)2End Function(0-1)(0-9)(0-3)(0-9)(A-Z0-9)?(A-Z0-9)?(0-9A-Z)-(18|19|20)\d\d(0(1-9)|1(012))(0(1-9)|(12)(0-9)|3(01))-(0-9)3End Function
        pagos("FolioSolDon") = "PE-22-12345" ' PE - (0 - 9)2End Function-(0-9)5End Function
        pagos("PzaArtNombre") = "Las Flores"
        pagos("PzaArtTecn") = "Cubismo al Óleo"
        pagos("PzaArtAProd") = "2013"
        pagos("PzaArtDim") = "50cmx100cm"
        Return pagos
    End Function

    ' <summary>
    'Nodo complemento PF integrante coordinado
    ' </summary>
    Public Function complementoPFintegranteCoordinado() As MFObject
        Dim pfic As MFObject = New MFObject("PFIntegranteCoordinado")
        pfic("ClaveVehicular") = "29547033879512844"
        pfic("Placa") = "456543R"
        pfic("RFCPF") = "FESRGTG43"
        Return pfic
    End Function

    ' <summary>
    'Nodo complemento timbre fiscal digital
    ' </summary>
    Public Function complementoTimbreFiscalDigital() As MFObject
        Dim tfd As MFObject = New MFObject("TimbreFiscalDigital")
        tfd("UUID") = "29547033879512844"
        tfd("FechaTimbrado") = "10-05-2017"
        tfd("selloCFD") = "FESRGTG43"
        tfd("noCertificadoSAT") = "456543R"
        tfd("selloSAT") = "FESRGTG4323"
        Return tfd
    End Function

    ' <summary>
    'Nodo complemento turista, pasajero, extranjero
    ' </summary>
    Public Function complementoTuristaPE() As MFObject
        Dim tpe As MFObject = New MFObject("TuristaPasajeroExtranjero")
        tpe("fechadeTransito") = "gref"
        tpe("tipoTransito") = "908545"

        Dim datosTransito As MFObject = New MFObject("datosTransito")
        datosTransito("Via") = "4"
        datosTransito("TipoId") = "05"
        datosTransito("NumeroId") = "123"
        datosTransito("Nacionalidad") = "Mexicana"
        datosTransito("EmpresaTransporte") = "Chihuahuenses"
        datosTransito("IdTransporte") = "80805"
        tpe.AgregaSubnodo(datosTransito)
        Return tpe
    End Function

    ' <summary>
    'Nodo complemento vales de despensa
    ' </summary>
    Public Function complementoValeDespensa() As MFObject
        Dim vales As MFObject = New MFObject("ValesDeDespensa")
        vales("tipoOperacion") = "gref"
        vales("registroPatronal") = "908545"
        vales("numeroDeCuenta") = "8947.50"
        vales("total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim con0 As MFObject = New MFObject("0")
        Dim con1 As MFObject = New MFObject("1")
        con0("identificador") = "123"
        con0("fecha") = "05-04-2017"
        con0("rfc") = "gaar930830mcl"
        con0("curp") = "8"
        con0("nombre") = "4"
        con0("numSeguridadSocial") = "oil"
        con0("importe") = "142.00"

        con1("identificador") = "456"
        con1("fecha") = "05-04-2017"
        con1("rfc") = "gaar930830mcl"
        con1("curp") = "8"
        con1("nombre") = "4"
        con1("numSeguridadSocial") = "oil"
        con1("importe") = "142.00"
        conceptos.AgregaSubnodo(con0)
        conceptos.AgregaSubnodo(con1)
        vales.AgregaSubnodo(conceptos)
        Return vales
    End Function

    ' <summary>
    'Nodo complemento vehículos usados
    ' </summary>
    Public Function complementoVehiculoUsado() As MFObject
        Dim vehus As MFObject = New MFObject("VehiculoUsado")
        vehus("montoAdquisicion") = "2"
        vehus("montoEnajenacion") = "A1"
        vehus("claveVehicular") = "A1"
        vehus("marca") = "A1"
        vehus("tipo") = "A1"
        vehus("modelo") = "A1"
        vehus("numeroMotor") = "A1"
        vehus("numeroSerie") = "A1"
        vehus("NIV") = "A1"
        vehus("valor") = "A1"
        'Información aduanera
        Dim infoads As MFObject = New MFObject("InformacionAduanera")
        Dim info0 As MFObject = New MFObject("0")
        info0("numero") = "12"
        info0("fecha") = "11-04-2017"
        info0("aduana") = "gtr"
        Dim info1 As MFObject = New MFObject("1")
        info1("numero") = "76"
        info1("fecha") = "11-04-2017"
        info1("aduana") = "oiu"
        infoads.AgregaSubnodo(info0)
        infoads.AgregaSubnodo(info1)
        vehus.AgregaSubnodo(infoads)
        Return vehus
    End Function

    ' <summary>
    'Nodo complemento venta de vehículos
    ' </summary>
    Public Function complementoVentaVehiculos() As MFObject
        Dim veve As MFObject = New MFObject("VentaVehiculos")
        veve("ClaveVehicular") = "2"
        veve("Niv") = "A1"
        'Información aduanera
        Dim infoads As MFObject = New MFObject("InformacionAduanera")
        Dim info0 As MFObject = New MFObject("0")
        info0("numero") = "12"
        info0("fecha") = "11-04-2017"
        info0("aduana") = "gtr"
        Dim info1 As MFObject = New MFObject("1")
        info1("numero") = "76"
        info1("fecha") = "11-04-2017"
        info1("aduana") = "oiu"
        infoads.AgregaSubnodo(info0)
        infoads.AgregaSubnodo(info1)
        veve.AgregaSubnodo(infoads)
        'Partes
        Dim partes As MFObject = New MFObject("Parte")
        Dim part0 As MFObject = New MFObject("0")
        part0("cantidad") = "116.00"
        part0("unidad") = "0"
        part0("noIdentificacion") = "detalles"
        part0("descripcion") = "10.23"
        part0("valorUnitario") = "116.00"
        part0("importe") = "116.00"

        Dim infoads2 As MFObject = New MFObject("InformacionAduanera")
        Dim info02 As MFObject = New MFObject("0")
        info02("numero") = "2"
        info02("fecha") = "10-04-2017"
        info02("aduana") = "wed"
        Dim info12 As MFObject = New MFObject("1")
        info12("numero") = "3"
        info12("fecha") = "05-04-2017"
        info12("aduana") = "ntu"
        infoads2.AgregaSubnodo(info02)
        infoads2.AgregaSubnodo(info12)
        part0.AgregaSubnodo(infoads2)
        Dim part1 As MFObject = New MFObject("1")
        part1("cantidad") = "112"
        part1("unidad") = "76"
        part1("noIdentificacion") = "098"
        part1("descripcion") = "kye"
        part1("valorUnitario") = "119.00"
        part1("importe") = "119.00"
        partes.AgregaSubnodo(part0)
        partes.AgregaSubnodo(part1)
        veve.AgregaSubnodo(partes)
        Return veve
    End Function

    ' <summary>
    'Nodo complemento renovación y sustitución de vehículos
    ' </summary>
    Public Function complementoRenovacionVehiculos() As MFObject
        'Renovación y sustitución de vehículos
        Dim renysv As MFObject = New MFObject("RenovacionYSustitucionVehiculos")
        renysv("TipoDeDecreto") = "2"
        'Decreto de renovación vehicular
        Dim decreto As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular")
        decreto("VehEnaj") = "A1"
        Dim dec0 As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular.0")
        dec0("PrecioVehUsado") = "A1"
        dec0("TipoVeh") = "A1"
        dec0("Marca") = "A1"
        dec0("TipooClase") = "A1"
        dec0("Año") = "A1"
        dec0("Modelo") = "A1"
        dec0("NIV") = "A1"
        dec0("NumSerie") = "A1"
        dec0("NumPlacas") = "A1"
        dec0("NumMotor") = "A1"
        dec0("NumFolTarjCir") = "A1"
        dec0("NumPedIm") = "A1"
        dec0("Aduana") = "A1"
        dec0("FechaRegulVeh") = "A1"
        dec0("Foliofiscal") = "A1"
        decreto.AgregaSubnodo(dec0)
        'Vehículo
        Dim venusenafalperm As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular.VehiculoNuvoSemEnajenadoFabAlPerm")
        venusenafalperm("Año") = "2012"
        venusenafalperm("Modelo") = "fre"
        venusenafalperm("NumPlacas") = "786dfsr"
        venusenafalperm("RFC") = "fg4378gv86t2374"
        decreto.AgregaSubnodo(venusenafalperm)
        renysv.AgregaSubnodo(decreto)
        'Decreto de sustitución vehicular
        Dim decretoSustit As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoSustitVehicular")
        decretoSustit("VehEnaj") = "A1"
        'Vehículo
        Dim veusenpealfa As MFObject = New MFObject("VehiculoUsadoEnajenadoPermAlFab")
        veusenpealfa("PrecioVehUsado") = "A1"
        veusenpealfa("TipoVeh") = "A1"
        veusenpealfa("Marca") = "A1"
        veusenpealfa("TipooClase") = "A1"
        veusenpealfa("Año") = "A1"
        veusenpealfa("Modelo") = "A1"
        veusenpealfa("NIV") = "A1"
        veusenpealfa("NumSerie") = "A1"
        veusenpealfa("NumPlacas") = "A1"
        veusenpealfa("NumMotor") = "A1"
        veusenpealfa("NumFolTarjCir") = "A1"
        veusenpealfa("NumFolAvisoint") = "A1"
        veusenpealfa("NumPedIm") = "A1"
        veusenpealfa("Aduana") = "A1"
        veusenpealfa("FechaRegulVeh") = "A1"
        veusenpealfa("Foliofiscal") = "A1"
        decretoSustit.AgregaSubnodo(veusenpealfa)
        'Vehículo
        Dim venusenafalperm2 As MFObject = New MFObject("VehiculoNuvoSemEnajenadoFabAlPerm")
        venusenafalperm2("Año") = "A1"
        venusenafalperm2("Modelo") = "A1"
        venusenafalperm2("NumPlacas") = "A1"
        venusenafalperm2("RFC") = "A1"
        decretoSustit.AgregaSubnodo(venusenafalperm2)
        renysv.AgregaSubnodo(decretoSustit)
        Return renysv
    End Function

    ' <summary>
    'Nodo complemento SPEI
    ' </summary>
    Public Function complementoSPEI() As MFObject
        Dim SPEI As MFObject = New MFObject("SPEI")
        'Tercero
        Dim sterceros As MFObject = New MFObject("SPEI_Tercero")
        Dim spei0 As MFObject = New MFObject("0")
        spei0("FechaOperacion") = "O"
        spei0("Hora") = "2016-10-31"
        spei0("ClaveSPEI") = "2016-10-16"
        spei0("sello") = "2016-10-31"
        spei0("numeroCertificado") = "15"
        spei0("cadenaCDA") = "15"
        'Ordenante
        Dim ordenante As MFObject = New MFObject("Ordenante")
        ordenante("BancoEmisor") = "O"
        ordenante("Nombre") = "O"
        ordenante("TipoCuenta") = "O"
        ordenante("Cuenta") = "O"
        ordenante("RFC") = "O"
        'Beneficiario
        Dim beneficiario As MFObject = New MFObject("Beneficiario")
        beneficiario("BancoReceptor") = "O"
        beneficiario("Nombre") = "O"
        beneficiario("TipoCuenta") = "O"
        beneficiario("Cuenta") = "O"
        beneficiario("RFC") = "O"
        beneficiario("Concepto") = "O"
        beneficiario("IVA") = "O"
        beneficiario("MontoPago") = "O"
        spei0.AgregaSubnodo(ordenante)
        spei0.AgregaSubnodo(beneficiario)
        sterceros.AgregaSubnodo(spei0)

        Dim spei1 As MFObject = New MFObject("1")
        spei1("FechaOperacion") = "fewO"
        spei1("Hora") = "2016-10-31"
        spei1("ClaveSPEI") = "2016-10-16"
        spei1("sello") = "2016-10-31"
        spei1("numeroCertificado") = "f15"
        spei1("cadenaCDA") = "ef15"

        Dim ordenante2 As MFObject = New MFObject("Ordenante")
        ordenante2("BancoEmisor") = "56O"
        ordenante2("Nombre") = "hytO"
        ordenante2("TipoCuenta") = "hyO"
        ordenante2("Cuenta") = "45O"
        ordenante2("RFC") = "4O"

        Dim beneficiario2 As MFObject = New MFObject("Beneficiario")
        beneficiario2("BancoReceptor") = "hO"
        beneficiario2("Nombre") = "hfO"
        beneficiario2("TipoCuenta") = "hfO"
        beneficiario2("Cuenta") = "hfO"
        beneficiario2("RFC") = "rwtO"
        beneficiario2("Concepto") = "kyiuO"
        beneficiario2("IVA") = "65O"
        beneficiario2("MontoPago") = "gO"
        spei1.AgregaSubnodo(ordenante2)
        spei1.AgregaSubnodo(beneficiario2)
        sterceros.AgregaSubnodo(spei1)
        SPEI.AgregaSubnodo(sterceros)
        Return SPEI
    End Function

    ' <summary>
    'Nodo complemento detallista
    ' </summary>
    Public Function complementoDetallista() As MFObject
        Dim Detallista As MFObject = New MFObject("Detallista")
        Detallista("documentStatus") = "COPY"

        Dim refopaid As MFObject = New MFObject("requestForPaymentIdentification")
        refopaid("entityType") = "INVOICE"
        Detallista.AgregaSubnodo(refopaid)

        Dim spins As MFObject = New MFObject("specialInstruction")
        Dim spin0 As MFObject = New MFObject("0")
        spin0("text") = "hasta15cadenas"
        spin0("text") = "segunda"
        spin0("code") = "ZZZ"
        spins.AgregaSubnodo(spin0)
        Detallista.AgregaSubnodo(spins)

        Dim ordid As MFObject = New MFObject("orderIdentification")
        Dim references As MFObject = New MFObject("referenceIdentification")
        Dim ref0 As MFObject = New MFObject("0")
        ref0("type") = "ON" ' FIJO
        ordid("ReferenceDate") = "2016-10-31"
        references.AgregaSubnodo(ref0)
        ordid.AgregaSubnodo(references)
        Detallista.AgregaSubnodo(ordid)

        Dim adinfo As MFObject = New MFObject("AdditionalInformation")
        Dim references2 As MFObject = New MFObject("referenceIdentification")
        Dim ref02 As MFObject = New MFObject("0")
        ref02("type") = "ON"
        references2.AgregaSubnodo(ref02)
        adinfo.AgregaSubnodo(references2)
        Detallista.AgregaSubnodo(adinfo)

        Dim denote As MFObject = New MFObject("DeliveryNote")
        Dim references3 As MFObject = New MFObject("referenceIdentification")
        Dim ref03 As MFObject = New MFObject("0")
        ref03("referenceIdentification") = "hasta30cadenas"
        denote("ReferenceDate") = "2016-10-31"
        references3.AgregaSubnodo(ref03)
        denote.AgregaSubnodo(references3)
        Detallista.AgregaSubnodo(denote)

        Dim buyer As MFObject = New MFObject("buyer")
        Dim contacto As MFObject = New MFObject("contactInformation")
        Dim pers As MFObject = New MFObject("personOrDepartmentName")
        buyer("gln") = "gthtr"
        pers("text") = "mitexto"
        contacto.AgregaSubnodo(pers)
        buyer.AgregaSubnodo(contacto)
        Detallista.AgregaSubnodo(buyer)

        Dim seller As MFObject = New MFObject("seller")
        Dim altpaid As MFObject = New MFObject("alternatePartyIdentification")
        seller("gln") = "yun"
        altpaid("type") = "IEPS_REFERENCE"
        seller.AgregaSubnodo(altpaid)
        Detallista.AgregaSubnodo(seller)

        Dim shipto As MFObject = New MFObject("shipTo")
        Dim infos As MFObject = New MFObject("nameAndAddress")
        Dim inf0 As MFObject = New MFObject("0")
        shipto("gln") = "kui"
        inf0("name") = "sergio"
        inf0("streetAddressOne") = "torre del redentor"
        inf0("city") = "torreon"
        inf0("postalCode") = "27000"
        infos.AgregaSubnodo(inf0)
        shipto.AgregaSubnodo(infos)
        Detallista.AgregaSubnodo(shipto)

        Dim invoice As MFObject = New MFObject("InvoiceCreator")
        Dim altpaid2 As MFObject = New MFObject("alternatePartyIdentification")
        Dim namedir As MFObject = New MFObject("nameAndAddress")
        invoice("gln") = "jtyuj"
        altpaid2("type") = "VA"
        namedir("name") = "Blanca"
        namedir("streetAddressOne") = "torre blanca"
        namedir("city") = "torreon"
        namedir("postalCode") = "27200"
        invoice.AgregaSubnodo(altpaid2)
        invoice.AgregaSubnodo(namedir)
        Detallista.AgregaSubnodo(invoice)

        Dim clientes As MFObject = New MFObject("Customs")
        Dim client0 As MFObject = New MFObject("0")
        Dim client1 As MFObject = New MFObject("1")
        client0("gln") = "trece"
        client1("gln") = "dos"
        clientes.AgregaSubnodo(client0)
        clientes.AgregaSubnodo(client1)
        Detallista.AgregaSubnodo(clientes)

        Dim Currency As MFObject = New MFObject("currency")
        Dim cur0 As MFObject = New MFObject("0")
        cur0("currencyFunction") = "BILLING_CURRENCY"
        cur0("currencyFunction") = "PRICE_CURRENCY"
        cur0("currencyFunction") = "PAYMENT_CURRENCY"
        cur0("rateOfChange") = "12.8"
        cur0("currencyISOCode") = "USD"
        Currency.AgregaSubnodo(cur0)
        Detallista.AgregaSubnodo(Currency)

        Dim payterms As MFObject = New MFObject("paymentTerms")
        Dim paytime As MFObject = New MFObject("paymentTimePeriod")
        Dim timePeriod As MFObject = New MFObject("timePeriodDue")
        timePeriod("value") = "Ano"
        timePeriod("timePeriod") = "DAYS"
        Dim netpay As MFObject = New MFObject("netPayment")
        Dim dispay As MFObject = New MFObject("discountPayment")
        netpay("netPaymentTermsType") = "DAYS"
        dispay("percentage") = "1%"
        dispay("discountType") = "SANCTION"
        payterms("paymentTermsEvent") = "DATE_OF_INVOICE"
        payterms("PaymentTermsRelationTime") = "REFERENCE_AFTER"
        paytime.AgregaSubnodo(timePeriod)
        payterms.AgregaSubnodo(paytime)
        payterms.AgregaSubnodo(netpay)
        payterms.AgregaSubnodo(dispay)
        Detallista.AgregaSubnodo(payterms)

        Detallista("shipmentDetail") = "LIHHI"
        Dim allowance As MFObject = New MFObject("allowanceCharge")
        allowance("allowanceChargeType") = "ALLOWANCE_GLOBAL"
        allowance("settlementType") = "BILL_BACK"
        allowance("sequenceNumber") = "del1al15"
        allowance("specialServicesType") = "RAA"
        Dim monetary As MFObject = New MFObject("monetaryAmountOrPercentage")
        Dim _rate As MFObject = New MFObject("rate")
        _rate("percentage") = "21.32"
        _rate("base") = "INVOICE_VALUE"
        monetary.AgregaSubnodo(_rate)
        allowance.AgregaSubnodo(monetary)
        Detallista.AgregaSubnodo(allowance)

        Dim lineas As MFObject = New MFObject("lineItem")
        Dim Item As MFObject = New MFObject("0")
        Item("type") = "SimpleInvoiceLineItemType"
        Item("number") = "123"

        Dim trade As MFObject = New MFObject("tradeItemIdentification")
        trade("gtin") = "btyu"
        Item.AgregaSubnodo(trade)
        Dim altern As MFObject = New MFObject("alternateTradeItemIdentification")
        Dim alt0 As MFObject = New MFObject("0")
        alt0("type") = "SERIAL_NUMBER"
        altern.AgregaSubnodo(alt0)
        Item.AgregaSubnodo(altern)
        Dim desc As MFObject = New MFObject("tradeItemDescriptionInformation")
        desc("longText") = "textolargo"
        desc("language") = "ES"
        Item.AgregaSubnodo(desc)
        Dim invoqua As MFObject = New MFObject("invoicedQuantity")
        invoqua("unitOfMeasure") = "ernyt"
        Item.AgregaSubnodo(invoqua)
        Dim aditional As MFObject = New MFObject("aditionalQuantity")
        Dim ad0 As MFObject = New MFObject("0")
        ad0("QuantityType") = "FREE_GOODS"
        aditional.AgregaSubnodo(ad0)
        Item.AgregaSubnodo(aditional)
        Dim gross As MFObject = New MFObject("grossPrice")
        gross("Amount") = "34.4"
        Item.AgregaSubnodo(gross)
        Dim netprice As MFObject = New MFObject("netPrice")
        netprice("Amount") = "23.8"
        Item.AgregaSubnodo(netprice)

        Dim adInformation As MFObject = New MFObject("AdditionalInformation")
        Dim reference As MFObject = New MFObject("referenceIdentification")
        reference("type") = "ON"
        adInformation.AgregaSubnodo(reference)
        Item.AgregaSubnodo(adInformation)
        Dim customs As MFObject = New MFObject("Customs")
        Dim cus0 As MFObject = New MFObject("0")
        Dim alt As MFObject = New MFObject("alternatePartyIdentification")
        cus0("gln") = "hastatrece"
        alt("type") = "TN"
        cus0("ReferenceDate") = "20219"
        cus0("nameAndAddress") = "SERGIO TORRES"
        cus0.AgregaSubnodo(alt)
        customs.AgregaSubnodo(cus0)
        Item.AgregaSubnodo(customs)
        Dim logic As MFObject = New MFObject("LogisticUnits")
        Dim serial As MFObject = New MFObject("serialShippingContainerCode")
        serial("type") = "BJ"
        logic.AgregaSubnodo(serial)
        Item.AgregaSubnodo(logic)
        Dim pallet As MFObject = New MFObject("palletInformation")
        pallet("palletQuantity") = "PAREG"
        Dim pdesc As MFObject = New MFObject("description")
        pdesc("type") = "BOX"
        Dim trans As MFObject = New MFObject("transport")
        trans("methodOfPayment") = "PAID_BY_BUYER"
        pallet.AgregaSubnodo(pdesc)
        pallet.AgregaSubnodo(trans)
        Item.AgregaSubnodo(pallet)
        Dim extended As MFObject = New MFObject("extEnd FunctionedAttributes")
        Dim lotnum As MFObject = New MFObject("lotNumber")
        Dim lot0 As MFObject = New MFObject("0")
        lot0("productionDate") = "098984"
        lotnum.AgregaSubnodo(lot0)
        extended.AgregaSubnodo(lotnum)
        Item.AgregaSubnodo(extended)
        Dim allows As MFObject = New MFObject("allowanceCharge")
        Dim allow0 As MFObject = New MFObject("0")
        allow0("specialServicesType") = "VAB"
        Dim moampe As MFObject = New MFObject("monetaryAmountOrPercentage")
        moampe("percentagePerUnit") = "kjhw"
        Dim rapeun As MFObject = New MFObject("ratePerUnit")
        rapeun("amountPerUnit") = "jyu"
        allow0("allowanceChargeType") = "ALLOWANCE_GLOBAL"
        allow0("settlementType") = "OFF_INVOICE"
        allow0("sequenceNumber") = "ntyyu"
        moampe.AgregaSubnodo(rapeun)
        allow0.AgregaSubnodo(moampe)
        allows.AgregaSubnodo(allow0)
        Item.AgregaSubnodo(allows)
        Dim trades As MFObject = New MFObject("tradeItemTaxInformation")
        Dim trade0 As MFObject = New MFObject("0")
        trade0("taxTypeDescription") = "AAA"
        trade0("referenceNumber") = "kuhywe"
        Dim tradeamo As MFObject = New MFObject("tradeItemTaxAmount")
        tradeamo("taxPercentage") = "76.12"
        tradeamo("taxAmount") = "43.6"
        trade0("taxCategory") = "TRANSFERIDO"
        trade0.AgregaSubnodo(tradeamo)
        trades.AgregaSubnodo(trade0)
        Item.AgregaSubnodo(trades)
        Dim totaline As MFObject = New MFObject("totalLineAmount")
        Dim grossa As MFObject = New MFObject("grossAmount")
        grossa("Amount") = "65.8"
        Dim neta As MFObject = New MFObject("netAmount")
        neta("Amount") = "63.9"
        totaline.AgregaSubnodo(grossa)
        totaline.AgregaSubnodo(neta)
        Item.AgregaSubnodo(totaline)
        lineas.AgregaSubnodo(Item)
        Detallista.AgregaSubnodo(lineas)
        Dim totalamo As MFObject = New MFObject("totalAmount")
        totalamo("Amount") = "12.3"
        Detallista.AgregaSubnodo(totalamo)
        Dim totalallow As MFObject = New MFObject("TotalAllowanceCharge")
        Dim ta0 As MFObject = New MFObject("0")
        ta0("specialServicesType") = "ABZ"
        ta0("Amount") = "54.9"
        ta0("allowanceOrChargeType") = "ALLOWANCE"
        totalallow.AgregaSubnodo(ta0)
        Detallista.AgregaSubnodo(totalallow)
        Return Detallista
    End Function

    Private Sub nómina12ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles nómina12ToolStripMenuItem.Click

    End Sub

    Private Sub OtroComplementoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles OtroComplementoToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("complemento", "detallista10")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        Dim factura As New MFObject("factura")
        factura("serie") = "F"
        factura("folio") = "123"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("condicionesDePago") = "condiciones"
        factura("tipocomprobante") = "I"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"
        factura("subtotal") = "1000.00"
        factura("total") = "1112.00"

        Dim cfdiRelacionados As New MFObject("CfdisRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"
        emisor("RegimenFiscal") = "601"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "XAXX010101000"
        receptor("nombre") = "Público en general"
        receptor("UsoCFDI") = "G01"

        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "700.00"
        concepto0("Importe") = "700.00"
        Dim conimp0 As New MFObject("Impuestos")
        Dim conimp0tras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "700.00"
        contra0("Importe") = "112.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("TipoFactor") = "Tasa"
        conimp0tras.AgregaSubnodo(contra0)
        conimp0.AgregaSubnodo(conimp0tras)
        concepto0.AgregaSubnodo(conimp0)

        conceptos.AgregaSubnodo(concepto0)

        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "112.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "112.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)

        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        sdk.AgregaObjeto(complementoDetallista())

        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub Factura32ToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles Factura32ToolStripMenuItem.Click
        'Datos de factura
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.2")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "timbrados/cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("xml_debug", "timbrados/sin_timbrar_ejemplo_factura.xml")
        sdk.Iniciales.Add("php_openssl", "SI")
        '**********Nota: Verifique los nombres y que los objetos agregados sean correctos**********
        Dim PAC As New MFObject("PAC")
        PAC("usuario") = "DEMO700101XXX"
        PAC("pass") = "DEMO700101XXX"
        PAC("produccion") = "NO"
        Dim conf As New MFObject("conf")
        conf("cer") = "C:/SDK2/certificados/lan7008173r5.cer.pem"
        conf("key") = "C:/SDK2/certificados/lan7008173r5.key.pem"
        conf("pass") = "12345678a"

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "EFECTIVO"
        factura("forma_pago") = "PAGO EN UNA SOLA EXHIBICION"
        factura("tipocomprobante") = "ingreso"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1.0000"
        factura("LugarExpedicion") = "MONTERREY, NUEVO LEON"
        factura("RegimenFiscal") = "MI REGIMEN"
        factura("subtotal") = "1000"
        factura("total") = "1160"
        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "ACCEM SERVICIOS EMPRESARIALES SC"
        Dim emisorDomicilioFiscal As New MFObject("DomicilioFiscal")
        emisorDomicilioFiscal("calle") = "JUAREZ"
        emisorDomicilioFiscal("noExterior") = "100"
        emisorDomicilioFiscal("noInterior") = ""
        emisorDomicilioFiscal("colonia") = "CENTRO"
        emisorDomicilioFiscal("localidad") = "MONTERREY"
        emisorDomicilioFiscal("municipio") = "MONTERREY"
        emisorDomicilioFiscal("estado") = "NUEVO LEON"
        emisorDomicilioFiscal("pais") = "MEXICO"
        emisorDomicilioFiscal("CodigoPostal") = "01234"
        Dim emisorExpedidoEn As New MFObject("ExpedidoEn")
        emisorExpedidoEn("calle") = "HIDALGO"
        emisorExpedidoEn("noExterior") = "240"
        emisorExpedidoEn("noInterior") = ""
        emisorExpedidoEn("colonia") = "LAS CUMBRES 3 SECTOR"
        emisorExpedidoEn("localidad") = "MONTERREY"
        emisorExpedidoEn("municipio") = "MONTERREY"
        emisorExpedidoEn("estado") = "NUEVO LEON"
        emisorExpedidoEn("pais") = "MEXICO"
        emisorExpedidoEn("CodigoPostal") = "64610"
        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "SOHM7509289MA"
        receptor("nombre") = "MIGUEL ANGEL SOSA HERNANDEZ"
        Dim receptorDomicilio As New MFObject("Domicilio")
        receptorDomicilio("calle") = "PERIFERICO"
        receptorDomicilio("noExterior") = "1024"
        receptorDomicilio("noInterior") = "B"
        receptorDomicilio("colonia") = "SAN ANGEL"
        receptorDomicilio("localidad") = "CIUDAD DE MÉXICO"
        receptorDomicilio("municipio") = "ALVARO OBREGON"
        receptorDomicilio("estado") = "DISTRITO FEDERAL"
        receptorDomicilio("pais") = "MEXICO"
        receptorDomicilio("CodigoPostal") = "23010"
        Dim conceptos As New MFObject("conceptos")
        Dim conceptos0 As New MFObject("0")
        conceptos0("unidad") = "PIEZA"
        conceptos0("cantidad") = "1"
        conceptos0("ID") = "COD"
        conceptos0("descripcion") = "PRODUCTO PRUEBA"
        conceptos0("valorunitario") = "1000.00"
        conceptos0("importe") = "1000.00"
        conceptos0("numero") = "123434755001456"
        conceptos0("fecha") = "2015-09-25"
        conceptos0("aduana") = "NUEVO LAREDO"

        Dim impuestos As New MFObject("impuestos")
        Dim translados As New MFObject("translados")
        Dim tra0 As New MFObject("0")
        tra0("importe") = "160.00"
        tra0("impuesto") = "IVA"
        tra0("tasa") = "0.16"
        translados.AgregaSubnodo(tra0)
        impuestos.AgregaSubnodo(translados)

        emisor.AgregaSubnodo(emisorDomicilioFiscal)
        emisor.AgregaSubnodo(emisorExpedidoEn)
        receptor.AgregaSubnodo(receptorDomicilio)
        conceptos.AgregaSubnodo(conceptos0)
        sdk.AgregaObjeto(PAC)
        sdk.AgregaObjeto(conf)
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        MostrarDatos(sdk)
        ' Muestra la estructura
    End Sub

    Private Sub ejemplo_nota_credito()
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_nota_credito" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_nota_credito" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim cfdiRelacionados As New MFObject("CfdisRelacionados")
        Dim cfdirel As New MFObject("UUID")
        cfdiRelacionados("TipoRelacion") = "01"
        'Se pueden agregar varios relacionados con UUID
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdiRelacionados.AgregaSubnodo(cfdirel)

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "E"
        factura("subtotal") = "1000.00"
        factura("descuento") = "0.00"
        factura("total") = "1160.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "AAA010101AAA"
        receptor("nombre") = "Accem Servicios Empresariales"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "PIEZA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "PRODUCTO PRUEBA 1"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"

        Dim conimps As New MFObject("Impuestos")
        Dim contras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "1000.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("Importe") = "160.00"
        contra0("TipoFactor") = "Tasa"
        contras.AgregaSubnodo(contra0)
        conimps.AgregaSubnodo(contras)
        concepto0.AgregaSubnodo(conimps)
        conceptos.AgregaSubnodo(concepto0)
        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("TasaOCuota") = "0.160000"
        itra0("Importe") = "160.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(cfdiRelacionados)
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub ejemplo_factura_aduana()
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_aduana" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_aduana" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "1000.00"
        factura("descuento") = "0.00"
        factura("total") = "1160.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "AAA010101AAA"
        receptor("nombre") = "Accem Servicios Empresariales"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        Dim info As New MFObject("InformacionAduanera")
        info("NumeroPedimento") = "123434755001456"
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "PIEZA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "PRODUCTO PRUEBA 1"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"

        Dim conimps As New MFObject("Impuestos")
        Dim contras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "1000.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("Importe") = "160.00"
        contra0("TipoFactor") = "Tasa"
        contras.AgregaSubnodo(contra0)
        conimps.AgregaSubnodo(contras)
        concepto0.AgregaSubnodo(info)
        concepto0.AgregaSubnodo(conimps)
        conceptos.AgregaSubnodo(concepto0)
        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("TasaOCuota") = "0.160000"
        itra0("Importe") = "160.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub ejemplo_factura_condiciones_pago()
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_condiciones_pago" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_condiciones_pago" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "1000.00"
        factura("descuento") = "100.00"
        factura("total") = "1060.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "AAA010101AAA"
        receptor("nombre") = "Accem Servicios Empresariales"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "PIEZA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "PRODUCTO PRUEBA 1"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"
        concepto0("Descuento") = "100.00"
        Dim conimps As New MFObject("Impuestos")
        Dim contras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "1000.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("Importe") = "160.00"
        contra0("TipoFactor") = "Tasa"
        contras.AgregaSubnodo(contra0)
        conimps.AgregaSubnodo(contras)
        concepto0.AgregaSubnodo(conimps)
        conceptos.AgregaSubnodo(concepto0)
        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("TasaOCuota") = "0.160000"
        itra0("Importe") = "160.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub ejemplo_factura_motivo_descuento()
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_motivo_descuento" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_motivo_descuento" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "1000.00"
        factura("descuento") = "500.00"
        factura("total") = "660.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "AAA010101AAA"
        receptor("nombre") = "Accem Servicios Empresariales"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "PIEZA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "PRODUCTO PRUEBA 1"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"
        concepto0("Descuento") = "500.00"
        Dim conimps As New MFObject("Impuestos")
        Dim contras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "1000.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("Importe") = "160.00"
        contra0("TipoFactor") = "Tasa"
        contras.AgregaSubnodo(contra0)
        conimps.AgregaSubnodo(contras)
        concepto0.AgregaSubnodo(conimps)
        conceptos.AgregaSubnodo(concepto0)
        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("TasaOCuota") = "0.160000"
        itra0("Importe") = "160.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub ejemplo_honorarios()
        sdk = New MFSDK()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "DIVISOR")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_honorarios" + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_honorarios" + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")

        Dim factura As New MFObject("factura")
        factura("serie") = "A"
        factura("folio") = "100"
        factura("fecha_expedicion") = DateTime.Now.ToString("s")
        factura("metodo_pago") = "PUE"
        factura("forma_pago") = "01"
        factura("moneda") = "MXN"
        factura("tipocambio") = "1"
        factura("tipocomprobante") = "I"
        factura("subtotal") = "1000.00"
        factura("descuento") = "0.00"
        factura("total") = "840.00"
        factura("LugarExpedicion") = "27000"
        factura("RegimenFiscal") = "601"

        Dim emisor As New MFObject("emisor")
        emisor("rfc") = "LAN7008173R5"
        emisor("nombre") = "CINDEMEX SA DE CV"

        Dim receptor As New MFObject("receptor")
        receptor("rfc") = "AAA010101AAA"
        receptor("nombre") = "Accem Servicios Empresariales"
        receptor("UsoCFDI") = "P01"

        ' Concepto Normal
        Dim conceptos As New MFObject("conceptos")
        Dim concepto0 As New MFObject("0")
        concepto0("ClaveProdServ") = "84111506"
        concepto0("cantidad") = "1"
        concepto0("unidad") = "NO APLICA"
        concepto0("ClaveUnidad") = "ACT"
        concepto0("descripcion") = "SERVICIO DE MANTENIMIENTO"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"
        Dim conimps As New MFObject("Impuestos")
        Dim contras As New MFObject("Traslados")
        Dim contra0 As New MFObject("0")
        contra0("Base") = "1000.00"
        contra0("Impuesto") = "002"
        contra0("TasaOCuota") = "0.160000"
        contra0("Importe") = "160.00"
        contra0("TipoFactor") = "Tasa"
        contras.AgregaSubnodo(contra0)
        conimps.AgregaSubnodo(contras)
        Dim conrets As New MFObject("Retenciones")
        Dim conret0 As New MFObject("0")
        conret0("Base") = "1000.00"
        conret0("Impuesto") = "002"
        conret0("TasaOCuota") = "0.160000"
        conret0("Importe") = "160.00"
        conret0("TipoFactor") = "Tasa"
        Dim conret1 As New MFObject("1")
        conret1("Base") = "1000.00"
        conret1("Impuesto") = "001"
        conret1("TasaOCuota") = "0.160000"
        conret1("Importe") = "160.00"
        conret1("TipoFactor") = "Tasa"
        conrets.AgregaSubnodo(conret0)
        conrets.AgregaSubnodo(conret1)
        conimps.AgregaSubnodo(conrets)
        concepto0.AgregaSubnodo(conimps)
        conceptos.AgregaSubnodo(concepto0)
        ' Impuestos
        Dim impuestos As New MFObject("impuestos")
        impuestos("TotalImpuestosTrasladados") = "160.00"
        impuestos("TotalImpuestosRetenidos") = "320.00"
        ' Traslados
        Dim itras As New MFObject("translados")
        Dim itra0 As New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("TasaOCuota") = "0.160000"
        itra0("Importe") = "160.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        Dim irets As New MFObject("retenciones")
        Dim iret0 As New MFObject("0")
        iret0("Impuesto") = "002"
        iret0("Importe") = "160.00"
        Dim iret1 As New MFObject("1")
        iret1("Impuesto") = "001"
        iret1("Importe") = "160.00"
        irets.AgregaSubnodo(iret0)
        irets.AgregaSubnodo(iret1)
        impuestos.AgregaSubnodo(irets)
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura)
        sdk.AgregaObjeto(emisor)
        sdk.AgregaObjeto(receptor)
        sdk.AgregaObjeto(conceptos)
        sdk.AgregaObjeto(impuestos)
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub CancelarToolStripMenuItem1_Click(sender As Object, e As EventArgs) Handles CancelarToolStripMenuItem1.Click
        sdk = New MFSDK()
        sdk.AgregaObjeto(PAC2())
        sdk.Iniciales.Add("modulo", "cancelacion2018")
        sdk.Iniciales.Add("accion", "cancelar")
        sdk.Iniciales.Add("produccion", "NO")
        sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d")
        sdk.Iniciales.Add("rfc", "LAN7008173R5")
        sdk.Iniciales.Add("password", "12345678a")
        sdk.Iniciales.Add("b64Cer", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer")
        sdk.Iniciales.Add("b64Key", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key")

        sdk.AgregaObjeto(Conf())
        ' Muestras la estructura
        MostrarDatos(sdk)
    End Sub

    Private Sub ConsultarToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles ConsultarToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.AgregaObjeto(PAC2())
        sdk.Iniciales.Add("modulo", "cancelacion2018")
        sdk.Iniciales.Add("accion", "consultar")
        sdk.Iniciales.Add("produccion", "NO")
        sdk.Iniciales.Add("rfc", "LAN7008173R5")
        sdk.Iniciales.Add("password", "12345678a")
        MostrarDatos(sdk)
    End Sub

    Private Sub AceptarCancelacionToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles AceptarCancelacionToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("modulo", "cancelacion2018")
        sdk.Iniciales.Add("accion", "aceptar")
        sdk.Iniciales.Add("produccion", "NO")
        sdk.Iniciales.Add("rfc", "LAN7008173R5")
        sdk.Iniciales.Add("password", "12345678a")
        sdk.Iniciales.Add("xml", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d")
        sdk.Iniciales.Add("b64Cer", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer")
        sdk.Iniciales.Add("b64Key", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key")
        MostrarDatos(sdk)
    End Sub

    Private Sub RechazarCancelacionToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles RechazarCancelacionToolStripMenuItem.Click
        sdk = New MFSDK()
        sdk.Iniciales.Add("modulo", "cancelacion2018")
        sdk.Iniciales.Add("accion", "rechazar")
        sdk.Iniciales.Add("produccion", "NO")
        sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d")
        sdk.Iniciales.Add("password", "12345678a")
        sdk.Iniciales.Add("rfc", "LAN7008173R5")
        sdk.Iniciales.Add("xml", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("b64Cer", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer")
        sdk.Iniciales.Add("b64Key", "C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key")

        MostrarDatos(sdk)
    End Sub
End Class
