﻿Imports DemoMFSDKNew
Imports DemoMFSDKNew.MFObject
Public Class Form1
    Dim sdk As MFSDK = New MFSDK()
    Private Sub timbrarToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles timbrarToolStripMenuItem.Click
        ' Se timbra el CFDI
        Dim respuesta As SDKRespuesta = sdk.Timbrar("C:\sdk2\timbrados\", "factura", False)
        'pgRespuesta.SelectedObject = respuesta
        textBox2.Text = respuesta.RespuestaOriginalSDK
        ' Se notifica que el SDK se ejecuto
        Dim mensaje As String = String.Format("Código: {0}\r\nMensaje: {1}", respuesta.Codigo_MF_Numero, respuesta.Codigo_MF_Texto)
        MessageBox.Show(Me, mensaje, Application.ProductName, MessageBoxButtons.OK, If(respuesta.Codigo_MF_Numero = "0", MessageBoxIcon.Information, MessageBoxIcon.Warning))
    End Sub

    Private Sub facturaNormalToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles facturaNormalToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura()
    End Sub

    Private Sub tsmiNomina12Normal_Click(sender As Object, e As EventArgs) Handles tsmiNomina12Normal.Click
        textBox1.Text = ejemplo_nomina()
    End Sub

    Private Sub tsmiAccionesTitulos_Click(sender As Object, e As EventArgs) Handles tsmiAccionesTitulos.Click
        textBox1.Text = ejemplo_nomina_acciones()
    End Sub

    Private Sub tsmiFiniquito_Click(sender As Object, e As EventArgs) Handles tsmiFiniquito.Click
        textBox1.Text = ejemplo_nomina_finiquito()
    End Sub

    Private Sub tsmiGobierno_Click(sender As Object, e As EventArgs) Handles tsmiGobierno.Click
        textBox1.Text = ejemplo_nomina_gobierno()
    End Sub

    Private Sub tsmiHorasExtra_Click(sender As Object, e As EventArgs) Handles tsmiHorasExtra.Click
        textBox1.Text = ejemplo_nomina_horasextra()
    End Sub

    Private Sub tsmiIncapacidad_Click(sender As Object, e As EventArgs) Handles tsmiIncapacidad.Click
        textBox1.Text = ejemplo_nomina_incapacidades()
    End Sub

    Private Sub tsmiJubilacion_Click(sender As Object, e As EventArgs) Handles tsmiJubilacion.Click
        textBox1.Text = ejemplo_nomina_jubilacion()
    End Sub

    Private Sub tsmiSubContratacion_Click(sender As Object, e As EventArgs) Handles tsmiSubContratacion.Click
        textBox1.Text = ejemplo_nomina_subcontratacion()
    End Sub

    Private Sub tsmiSubsidio_Click(sender As Object, e As EventArgs) Handles tsmiSubsidio.Click
        textBox1.Text = ejemplo_nomina_subsidio()
    End Sub

    Private Sub escuelaToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles escuelaToolStripMenuItem.Click
        textBox1.Text = ejemplo_escuelas()
    End Sub

    Private Sub parcialidadToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles parcialidadToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_parcialidades()
    End Sub

    Private Sub arrendamientoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles arrendamientoToolStripMenuItem.Click
        textBox1.Text = ejemplo_arrendamiento()
    End Sub

    Private Sub chequeToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles chequeToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_cheque()
    End Sub

    Private Sub cancelarToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles cancelarToolStripMenuItem.Click
        textBox1.Text = ejemplo_cancela_factura()
    End Sub

    Private Sub notarioPublicoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles notarioPublicoToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_notarios()
    End Sub

    Private Sub doralesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles doralesToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_dolar()
    End Sub

    Private Sub hotelesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles hotelesToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_hoteles()
    End Sub

    Private Sub tercerosToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles tercerosToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_terceros()
    End Sub

    Private Sub impuestosLocalesToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles impuestosLocalesToolStripMenuItem.Click
        textBox1.Text = ejemplo_impuestos_locales()
    End Sub

    Private Sub comercioExteriorToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles comercioExteriorToolStripMenuItem.Click
        textBox1.Text = ejemplo_factura_comercio()
    End Sub

    Private Sub tsmiINE_Click(sender As Object, e As EventArgs) Handles tsmiINE.Click
        textBox1.Text = ejemplo_factura_ine()
    End Sub

    Private Sub cancelarConAcuseToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles cancelarConAcuseToolStripMenuItem.Click
        textBox1.Text = ejemplo_cancela_factura()
    End Sub

    Private Sub consultarSaldoToolStripMenuItem_Click(sender As Object, e As EventArgs) Handles consultarSaldoToolStripMenuItem.Click
        textBox1.Text = ejemplo_consulta_saldo()
    End Sub

    Public Function CfdiRelacionados() As MFObject
        Dim CfdiRels As MFObject = New MFObject("CfdiRelacionados")
        Dim cfdirel As MFObject = New MFObject("UUID")
        CfdiRels("TipoRelacion") = "01"
        cfdirel("0") = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894"
        cfdirel("1") = "4329C28A-FEDB-9016-754A-FACEB0041996"
        CfdiRels.AgregaSubnodo(cfdirel)
        Return CfdiRels
    End Function

    Public Function Factura() As MFObject
        Dim fact As MFObject = New MFObject("Factura")
        fact("serie") = "F"
        fact("folio") = "123"
        fact("fecha_expedicion") = DateTime.Now.ToString("s")
        fact("metodo_pago") = "PUE"
        fact("forma_pago") = "01"
        fact("condicionesDePago") = "condiciones"
        fact("tipocomprobante") = "I"
        fact("moneda") = "MXN"
        fact("tipocambio") = "1.00"
        fact("LugarExpedicion") = "27000"
        fact("RegimenFiscal") = "601"
        fact("subtotal") = "1000.00" ' 100.0
        fact("descuento") = "0.00"
        fact("total") = "1000.00" ' 100.0
        Return fact
    End Function
    Public Function factura_dolar() As MFObject
        Dim fact As MFObject = New MFObject("Factura")
        fact("serie") = "F"
        fact("folio") = "123"
        fact("fecha_expedicion") = DateTime.Now.ToString("s")
        fact("metodo_pago") = "01"
        fact("forma_pago") = "PUE"
        fact("moneda") = "USD"
        fact("tipocambio") = "13.5200"
        fact("tipocomprobante") = "ingreso"
        fact("subtotal") = "100.00"
        fact("descuento") = "0.00"
        fact("total") = "100.00"
        fact("LugarExpedicion") = "27000"
        fact("RegimenFiscal") = "MI REGIMEN"
        Return fact
    End Function

    Public Function factura_cheque() As MFObject
        Dim fact As MFObject = New MFObject("Factura")
        fact("serie") = "F"
        fact("folio") = "123"
        fact("fecha_expedicion") = DateTime.Now.ToString("s")
        fact("metodo_pago") = "02"
        fact("forma_pago") = "PUE"
        fact("NumCtaPAgo") = "1234"
        fact("moneda") = "MXN"
        fact("tipocambio") = "1.00"
        fact("tipocomprobante") = "ingreso"
        fact("subtotal") = "100.00"
        fact("descuento") = "0.00"
        fact("total") = "100.00"
        fact("LugarExpedicion") = "27000"
        fact("RegimenFiscal") = "MI REGIMEN"
        Return fact
    End Function

    Public Function factura_parcialidad() As MFObject
        Dim fact As MFObject = New MFObject("Factura")
        fact("serie") = "A"
        fact("folio") = "100"
        fact("fecha_expedicion") = DateTime.Now.ToString("s")
        fact("metodo_pago") = "01"
        fact("forma_pago") = "PUE"
        fact("moneda") = "MXN"
        fact("tipocambio") = "1.00"
        fact("tipocomprobante") = "ingreso"
        fact("subtotal") = "100.00"
        fact("descuento") = "0.00"
        fact("total") = "100.00"
        fact("LugarExpedicion") = "27000"
        fact("RegimenFiscal") = "MI REGIMEN"
        'Parcialidad
        fact("FolioFiscalOrig") = "3B985D09-26CD-4643-B39D-6D4F54E7D046"
        fact("SerieFolioFiscalOrig") = "A90"
        fact("FechaFolioFiscalOrig") = "2015-09-27T02:12:58"
        fact("MontoFolioFiscalOrig") = "12345.67"
        Return fact
    End Function

    Public Function emisor_old() As MFObject
        Dim emi As MFObject = New MFObject("Emisor")
        emi("rfc") = "LAN7008173R5"
        emi("nombre") = "CINDEMEX SA DE CV"
        Dim dom As MFObject = New MFObject("DomicilioFiscal")
        dom("calle") = "JUAREZ"
        dom("noExterior") = "100"
        dom("noInterior") = "2"
        dom("colonia") = "CENTRO"
        dom("localidad") = "MONTERREY"
        dom("municipio") = "MONTERREY"
        dom("estado") = "NUEVO LEON"
        dom("pais") = "MEXICO"
        dom("CodigoPostal") = "01234"
        Dim exp As MFObject = New MFObject("ExpedidoEn")
        exp("calle") = "HIDALGO"
        exp("noExterior") = "240"
        exp("noInterior") = "2"
        exp("colonia") = "LAS CUMBRES 3 SECTOR"
        exp("localidad") = "MONTERREY"
        exp("municipio") = "MONTERREY"
        exp("estado") = "NUEVO LEON"
        exp("pais") = "MEXICO"
        exp("CodigoPostal") = "64610"
        emi.AgregaSubnodo(dom)
        emi.AgregaSubnodo(exp)
        Return emi
    End Function

    Public Function Emisor() As MFObject
        Dim emi As MFObject = New MFObject("Emisor")
        'emi("rfc") = "AAA010101AAA"
        'emi("nombre") = "General"
        emi("rfc") = "LAN7008173R5"
        emi("nombre") = "CINDEMEX SA DE CV"
        emi("RegimenFiscal") = "601"
        Return emi
    End Function

    Public Function Receptor() As MFObject
        Dim recept As MFObject = New MFObject("Receptor")
        recept("rfc") = "AAA010101AAA"
        recept("nombre") = "Accem Servicios Empresariales"
        recept("UsoCFDI") = "G01"
        Return recept
    End Function

    Public Function receptor_old() As MFObject
        Dim recept As MFObject = New MFObject("Receptor")
        recept("rfc") = "AAA010101AAA"
        recept("nombre") = "Accem Servicios Empresariales"
        Dim dom As MFObject = New MFObject("Domicilio")
        dom("calle") = "PERIFERICO"
        dom("noExterior") = "1024"
        dom("noInterior") = "B"
        dom("colonia") = "SAN ANGEL"
        dom("localidad") = "ALVARO OBREGON"
        dom("municipio") = "MONTERREY"
        dom("estado") = "DISTRITO FEDERAL"
        dom("pais") = "MEXICO"
        dom("CodigoPostal") = "23010"
        recept.AgregaSubnodo(dom)
        Return recept
    End Function

    Public Function concepto_normal() As MFObject
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("cantidad") = "1"
        concepto0("unidad") = "Pieza"
        concepto0("ClaveUnidad") = "C81"
        concepto0("ID") = "COD01"
        concepto0("ClaveProdServ") = "01010101"
        concepto0("descripcion") = "Producto de prueba 1"
        concepto0("valorunitario") = "1000.00"
        concepto0("importe") = "1000.00"
        concepts.AgregaSubnodo(concepto0)
        Return concepts
    End Function

    Public Function conceptos_escuelas() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("Cantidad") = "1"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Unidad") = "NO APLICA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        concepts.AgregaSubnodo(concepto0)
        Return concepts
    End Function

    Public Function Conceptos3() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Cantidad") = "1"
        concepto0("Unidad") = "PIEZA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "MENSUALIDAD ENERO 2014"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"
        concepts.AgregaSubnodo(concepto0)
        Return concepts
    End Function

    Public Function conceptos_aduana() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("Cantidad") = "1"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Unidad") = "PIEZA"
        concepto0("NoIdentificacion") = "COD1"
        concepto0("Descripcion") = "PRODUCTO PRUEBA 1"
        concepto0("ValorUnitario") = "1100.00"
        concepto0("Importe") = "1000.00"
        concepto0("Fecha") = "2015 - 09 - 25"
        concepto0("Aduana") = "NUEVO LAREDO"
        concepto0("Numero") = "123434755001456"
        concepts.AgregaSubnodo(concepto0)
        Return concepts
    End Function

    Public Function Conceptos() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Unidad") = "Pieza"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "100.00"
        concepto0("Importe") = "100.00"
        concepto0("Descuento") = "5.00"
        ' Concpetos con Impuestos
        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("ClaveProdServ") = "01010101"
        concepto1("NoIdentificacion") = "COD02"
        concepto1("Cantidad") = "1.00"
        concepto1("ClaveUnidad") = "C81"
        concepto1("Unidad") = "Pieza"
        concepto1("Descripcion") = "Producto de prueba 2"
        concepto1("ValorUnitario") = "100.00"
        Dim conimp As MFObject = New MFObject("Impuestos")
        Dim contras As MFObject = New MFObject("Traslados")
        Dim contra0 As MFObject = New MFObject("0")
        contra0("Base") = "1.00"
        contra0("Impuesto") = "IVA"
        contra0("TipoFactor") = "Tasa"
        contra0("TasaOCuota") = "0.000000"
        contra0("Importe") = "0.00"
        Dim conrets As MFObject = New MFObject("Retenciones")
        Dim conret0 As MFObject = New MFObject("0")
        conret0("Base") = "1.00"
        conret0("Impuesto") = "IVA"
        conret0("TipoFactor") = "Tasa"
        conret0("TasaOCuota") = "0.000000"
        conret0("Importe") = "0.00"
        contras.AgregaSubnodo(contra0)
        conimp.AgregaSubnodo(contras)
        conrets.AgregaSubnodo(conret0)
        conimp.AgregaSubnodo(conrets)
        concepto1.AgregaSubnodo(conimp)
        ' Conceptos con Información Aduanera
        Dim concepto2 As MFObject = New MFObject("2")
        concepto2("ClaveProdServ") = "01010101"
        concepto2("NoIdentificacion") = "COD03"
        concepto2("Cantidad") = "1.00"
        concepto2("ClaveUnidad") = "C81"
        concepto2("Unidad") = "Pieza"
        concepto2("Descripcion") = "Producto de prueba 3"
        concepto2("ValorUnitario") = "100.00"
        Dim infoads As MFObject = New MFObject("InformacionAduanera")
        Dim infoad0 As MFObject = New MFObject("0")
        infoad0("NumeroPedimento") = "0987654321"
        Dim infoad1 As MFObject = New MFObject("1")
        infoad1("NumeroPedimento") = "7896541230"
        infoads.AgregaSubnodo(infoad0)
        infoads.AgregaSubnodo(infoad1)
        concepto2.AgregaSubnodo(infoads)
        ' Conceptos con Cuenta Predial
        Dim concepto3 As MFObject = New MFObject("3")
        Dim cuentap As MFObject = New MFObject("CuentaPredial")
        concepto3("ClaveProdServ") = "01010101"
        concepto3("NoIdentificacion") = "COD04"
        concepto3("Cantidad") = "1.00"
        concepto3("ClaveUnidad") = "C81"
        concepto3("Unidad") = "Pieza"
        concepto3("Descripcion") = "Producto de prueba 4"
        concepto3("ValorUnitario") = "100.00"
        cuentap("Numero") = "1234567890"
        concepto3.AgregaSubnodo(cuentap)
        ' Conceptos con Parte
        Dim concepto4 As MFObject = New MFObject("4")
        concepto4("ClaveProdServ") = "01010101"
        concepto4("NoIdentificacion") = "COD05"
        concepto4("Cantidad") = "1.00"
        concepto4("ClaveUnidad") = "C81"
        concepto4("Unidad") = "Pieza"
        concepto4("Descripcion") = "Producto de prueba 5"
        concepto4("ValorUnitario") = "100.00"
        Dim partes As MFObject = New MFObject("Parte")
        Dim parte0 As MFObject = New MFObject("0")
        parte0("ClaveProdServ") = "0101010101"
        parte0("NoIdentificacion") = "COD05"
        parte0("Cantidad") = "1.00"
        parte0("Unidad") = "Pieza"
        parte0("Descripcion") = "Parte 1"
        parte0("ValorUnitario") = "100.00"
        parte0("Importe") = "100.00"
        Dim partinfos As MFObject = New MFObject("InformacionAduanera")
        Dim partinfo0 As MFObject = New MFObject("0")
        partinfo0("NumeroPedimento") = "1234567890"
        partinfos.AgregaSubnodo(partinfo0)
        parte0.AgregaSubnodo(partinfos)
        partes.AgregaSubnodo(parte0)
        concepto4.AgregaSubnodo(partes)
        concepts.AgregaSubnodo(concepto0)
        concepts.AgregaSubnodo(concepto1)
        concepts.AgregaSubnodo(concepto2)
        concepts.AgregaSubnodo(concepto3)
        concepts.AgregaSubnodo(concepto4)
        Return concepts
    End Function

    Public Function Conceptos2() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("ClaveProdServ") = "01010101"
        concepto0("NoIdentificacion") = "COD01"
        concepto0("Cantidad") = "1.00"
        concepto0("ClaveUnidad") = "C81"
        concepto0("Descripcion") = "Producto de prueba 1"
        concepto0("ValorUnitario") = "1000.00"
        concepto0("Importe") = "1000.00"

        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("ClaveProdServ") = "01010101"
        concepto1("NoIdentificacion") = "COD02"
        concepto1("Cantidad") = "1.00"
        concepto1("ClaveUnidad") = "C81"
        concepto1("Descripcion") = "Producto de prueba 2"
        concepto1("ValorUnitario") = "1000.00"
        concepto1("Importe") = "1000.00"

        Dim concepto2 As MFObject = New MFObject("2")
        concepto2("ClaveProdServ") = "01010101"
        concepto2("NoIdentificacion") = "COD03"
        concepto2("Cantidad") = "1.00"
        concepto2("ClaveUnidad") = "C81"
        concepto2("Descripcion") = "Producto de prueba 3"
        concepto2("ValorUnitario") = "1000.00"
        concepto2("Importe") = "1000.00"

        Dim concepto3 As MFObject = New MFObject("3")
        concepto3("ClaveProdServ") = "01010101"
        concepto3("NoIdentificacion") = "COD04"
        concepto3("Cantidad") = "1.00"
        concepto3("ClaveUnidad") = "C81"
        concepto3("Descripcion") = "Producto de prueba 4"
        concepto3("ValorUnitario") = "1000.00"
        concepto3("Importe") = "1000.00"

        Dim concepto4 As MFObject = New MFObject("4")
        concepto4("ClaveProdServ") = "01010101"
        concepto4("NoIdentificacion") = "COD05"
        concepto4("Cantidad") = "1.00"
        concepto4("ClaveUnidad") = "C81"
        concepto4("Descripcion") = "Producto de prueba 5"
        concepto4("ValorUnitario") = "1000.00"
        concepto4("Importe") = "1000.00"

        Dim concepto5 As MFObject = New MFObject("5")
        concepto5("ClaveProdServ") = "01010101"
        concepto5("NoIdentificacion") = "COD06"
        concepto5("Cantidad") = "1.00"
        concepto5("ClaveUnidad") = "C81"
        concepto5("Descripcion") = "Producto de prueba 6"
        concepto5("ValorUnitario") = "1000.00"
        concepto5("Importe") = "1000.00"

        Dim concepto6 As MFObject = New MFObject("6")
        concepto6("ClaveProdServ") = "01010101"
        concepto6("NoIdentificacion") = "COD07"
        concepto6("Cantidad") = "1.00"
        concepto6("ClaveUnidad") = "C81"
        concepto6("Descripcion") = "Producto de prueba 7"
        concepto6("ValorUnitario") = "1000.00"
        concepto6("Importe") = "1000.00"

        Dim concepto7 As MFObject = New MFObject("7")
        concepto7("ClaveProdServ") = "01010101"
        concepto7("NoIdentificacion") = "COD08"
        concepto7("Cantidad") = "1.00"
        concepto7("ClaveUnidad") = "C81"
        concepto7("Descripcion") = "Producto de prueba 8"
        concepto7("ValorUnitario") = "1000.00"
        concepto7("Importe") = "1000.00"

        Dim concepto8 As MFObject = New MFObject("8")
        concepto8("ClaveProdServ") = "01010101"
        concepto8("NoIdentificacion") = "COD09"
        concepto8("Cantidad") = "1.00"
        concepto8("ClaveUnidad") = "C81"
        concepto8("Descripcion") = "Producto de prueba 9"
        concepto8("ValorUnitario") = "1000.00"
        concepto8("Importe") = "1000.00"

        Dim concepto9 As MFObject = New MFObject("9")
        concepto9("ClaveProdServ") = "01010101"
        concepto9("NoIdentificacion") = "COD10"
        concepto9("Cantidad") = "1.00"
        concepto9("ClaveUnidad") = "C81"
        concepto9("Descripcion") = "Producto de prueba 10"
        concepto9("ValorUnitario") = "1000.00"
        concepto9("Importe") = "1000.00"

        concepts.AgregaSubnodo(concepto0)
        concepts.AgregaSubnodo(concepto1)
        concepts.AgregaSubnodo(concepto2)
        concepts.AgregaSubnodo(concepto3)
        concepts.AgregaSubnodo(concepto4)
        concepts.AgregaSubnodo(concepto5)
        concepts.AgregaSubnodo(concepto6)
        concepts.AgregaSubnodo(concepto7)
        concepts.AgregaSubnodo(concepto8)
        concepts.AgregaSubnodo(concepto9)
        Return concepts
    End Function

    Public Function conceptos_old() As MFObject
        ' Concepto Normal
        Dim concepts As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("cantidad") = "1"
        concepto0("unidad") = "NO APLICA"
        concepto0("ID") = "COD1"
        concepto0("descripcion") = "COBRO PARCIALIDAD DE VENTA A90"
        concepto0("valorunitario") = "100.00"
        concepto0("importe") = "100.00"
        concepts.AgregaSubnodo(concepto0)
        Return concepts
    End Function

    Public Function impuestos_old() As MFObject
        ' Impuestos
        Dim impuestos As MFObject = New MFObject("Impuestos")
        ' Traslados
        Dim itras As MFObject = New MFObject("translados")
        Dim itra0 As MFObject = New MFObject("0")
        itra0("impuesto") = "IVA"
        itra0("tasa") = "0.160000"
        itra0("importe") = "0.00"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        Return impuestos
    End Function

    Public Function Impuestos() As MFObject
        ' Impuestos
        Dim imp As MFObject = New MFObject("Impuestos")
        imp("TotalImpuestosTrasladados") = "0.00"
        ' Traslados
        Dim itras As MFObject = New MFObject("translados")
        Dim itra0 As MFObject = New MFObject("0")
        itra0("impuesto") = "003"
        itra0("tasa") = "0.160000"
        itra0("importe") = "0.00"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        imp.AgregaSubnodo(itras)
        Return imp
    End Function

    Public Function Impuestos2() As MFObject
        ' Impuestos
        Dim impuestos As MFObject = New MFObject("Impuestos")
        impuestos("TotalImpuestosTrasladados") = "0.00"
        'impuestos("TotalImpuestosRetenidos") = "0.00"
        ' Traslados
        Dim itras As MFObject = New MFObject("translados")
        Dim itra0 As MFObject = New MFObject("0")
        itra0("Impuesto") = "003"
        itra0("Importe") = "0.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        ' Retenciones
        Dim irets As MFObject = New MFObject("retenidos")
        Dim iret0 As MFObject = New MFObject("0")
        iret0("Impuesto") = "002"
        iret0("Importe") = "0.00"
        Dim iret1 As MFObject = New MFObject("1")
        iret1("Impuesto") = "001"
        iret1("Importe") = "0.00"
        irets.AgregaSubnodo(iret0)
        irets.AgregaSubnodo(iret1)
        impuestos.AgregaSubnodo(irets)
        Return impuestos
    End Function

    Public Function Impuestos3() As MFObject
        ' Impuestos
        Dim impuestos As MFObject = New MFObject("Impuestos")
        impuestos("TotalImpuestosTrasladados") = "0.00"
        ' Traslados
        Dim itras As MFObject = New MFObject("translados")
        Dim itra0 As MFObject = New MFObject("0")
        itra0("Impuesto") = "002"
        itra0("Importe") = "0.00"
        itra0("TasaOCuota") = "0.160000"
        itra0("TipoFactor") = "Tasa"
        itras.AgregaSubnodo(itra0)
        impuestos.AgregaSubnodo(itras)
        Return impuestos
    End Function

    Public Function PAC() As MFObject
        Dim p As MFObject = New MFObject("PAC")
        p("usuario") = "DEMO700101XXX"
        p("pass") = "DEMO700101XXX"
        p("produccion") = "NO"
        Return p
    End Function

    Public Function PAC2() As MFObject
        Dim p As MFObject = New MFObject("PAC")
        p("usuario") = "DEMO700101XXX"
        p("pass") = "DEMO700101XXX"
        Return p
    End Function

    Public Function Conf() As MFObject
        Dim con As MFObject = New MFObject("conf")
        con("cer") = "C:\sdk2\certificados\CSD_Pruebas_CFDI_LAN7008173R5.cer.pem"
        con("key") = "C:\sdk2\certificados\CSD_Pruebas_CFDI_LAN7008173R5.key.pem"
        con("pass") = "12345678a"
        Return con
    End Function

    Public Function ContaC() As MFObject
        Dim conta As MFObject = New MFObject("CC")
        conta("Ejercicio") = "2015"
        conta("Periodo") = "01"
        Return conta
    End Function

    Public Function ejemplo_arrendamiento() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\\multifacturas_sdk\\timbrados\\cfdi_ejemplo_arrendamiento.xml")
        sdk.Iniciales.Add("xml_debug", "C:\\multifacturas_sdk\\timbrados\\sin_timbrar_ejemplo_arrendamiento.xml")
        'sdk.Iniciales.Add("php_openssl", "SI")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(CfdiRelacionados()) 'opcional
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(concepto_normal())
        sdk.AgregaObjeto(Impuestos())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_banxico() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("modulo", "banxico")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.AgregaObjeto(PAC())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\sdk2\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_cancela_factura() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("cfdi", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("cancelar", "SI")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_consulta_saldo() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("SALDO", "SI")
        sdk.AgregaObjeto(PAC2())
        Dim myIni As String = sdk.GeneraINI("")
        Return myIni
    End Function

    Public Function ejemplo_contabilidad_electronica_balanza() As String
        Dim factura As MFObject = New MFObject("Factura")
        Dim balanza As MFObject = New MFObject("Balanza")
        balanza("Anio") = "2015"
        balanza("Mes") = "01"
        balanza("RFC") = "FJC780315E91"
        balanza("TipoEnvio") = "N"
        Dim cuentas As MFObject = New MFObject("Ctas")
        Dim cta0 As MFObject = New MFObject("0")
        cta0("Debe") = "1000.00"
        cta0("Haber") = "990.00"
        cta0("NumCta") = "1000"
        cta0("SaldoFin") = "10.00"
        cta0("SaldoIni") = "0.00"
        Dim cta1 As MFObject = New MFObject("1")
        cta1("Debe") = "1000.00"
        cta1("Haber") = "1000.00"
        cta1("NumCta") = "2100"
        cta1("SaldoFin") = "2000.00"
        cta1("SaldoIni") = "2000.00"
        cta1("tipo") = "balanza"
        cuentas.AgregaSubnodo(cta0)
        cuentas.AgregaSubnodo(cta1)
        balanza.AgregaSubnodo(cuentas)
        factura.AgregaSubnodo(balanza)
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("modulo", "contabilidad")
        sdk.Iniciales.Add("tipo", "balanza")
        sdk.Iniciales.Add("archivo", "timbrados/ejemplo_contabilida_electronica_balanza.xml")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(ContaC())
        sdk.AgregaObjeto(Factura)
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_contabilidad_electronica_catalogos() As String
        Dim factura As MFObject = New MFObject("Factura")
        Dim catalogo As MFObject = New MFObject("Catalogo")
        catalogo("Anio") = "2015"
        catalogo("Mes") = "01"
        catalogo("RFC") = "FJC780315E91"
        Dim cuentas As MFObject = New MFObject("Ctas")
        Dim cta0 As MFObject = New MFObject("0")
        cta0("CodAgrup") = "101.01"
        cta0("Desc") = "Caja"
        cta0("Natur") = "D"
        cta0("Nivel") = "1"
        cta0("NumCta") = "1000"
        Dim cta1 As MFObject = New MFObject("1")
        cta1("CodAgrup") = "201.01"
        cta1("Desc") = "Proveedores"
        cta1("Natur") = "A"
        cta1("Nivel") = "1"
        cta1("NumCta") = "2100"
        cuentas.AgregaSubnodo(cta0)
        cuentas.AgregaSubnodo(cta1)
        catalogo.AgregaSubnodo(cuentas)
        factura.AgregaSubnodo(catalogo)
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("modulo", "contabilidad")
        sdk.Iniciales.Add("tipo", "catalogo")
        sdk.Iniciales.Add("archivo", "timbrados/ejemplo_contabilida_electronica_catalogos.xml")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(ContaC())
        sdk.AgregaObjeto(Factura)
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_contabilidad_electronica_polizas() As String
        Dim factura As MFObject = New MFObject("Factura")
        Dim polizas As MFObject = New MFObject("Polizas")
        polizas("Anio") = "2015"
        polizas("Mes") = "07"
        polizas("RFC") = "AAA010101AAA"
        polizas("TipoSolicitud") = "AF"
        polizas("NumOrden") = "AAA0000000 / 00"
        Dim poliza As MFObject = New MFObject("Poliza")
        Dim pol0 As MFObject = New MFObject("0")
        pol0("NumUnIdenPol") = "1968"
        pol0("Fecha") = "2014 - 12 - 06"
        pol0("Concepto") = "Póliza de ingresos 1"
        Dim transaccion As MFObject = New MFObject("Transaccion")
        Dim tran0 As MFObject = New MFObject("0")
        tran0("NumCta") = "00010001"
        tran0("DesCta") = "XXXX"
        tran0("Concepto") = "Venta de mercancía"
        tran0("Debe") = "0.00"
        tran0("Haber") = "400.50"
        Dim cheques As MFObject = New MFObject("Cheque")
        Dim che0 As MFObject = New MFObject("0")
        che0("Num") = "123456"
        che0("BanEmisNal") = "106"
        che0("BanEmisExt") = "Banco Emisor Extranjero"
        che0("CtaOri") = "12345678910"
        che0("Fecha") = "2014 - 12 - 06"
        che0("Benef") = "Empresa"
        che0("RFC") = "AAA010101AAA"
        che0("Monto") = "200.50"
        che0("Moneda") = "MXN"
        che0("TipCamb") = "1.0"
        cheques.AgregaSubnodo(che0)
        tran0.AgregaSubnodo(cheques)
        transaccion.AgregaSubnodo(tran0)
        pol0.AgregaSubnodo(transaccion)
        poliza.AgregaSubnodo(pol0)

        Dim pol1 As MFObject = New MFObject("1")
        pol1("NumUnIdenPol") = "1969"
        pol1("Fecha") = "2014 - 12 - 07"
        pol1("Concepto") = "Póliza de ingresos 2"
        Dim transaccion2 As MFObject = New MFObject("Transaccion")
        Dim tran02 As MFObject = New MFObject("0")
        tran02("NumCta") = "00010001"
        tran02("DesCta") = "XXXX"
        tran02("Concepto") = "Venta de mercancía"
        tran02("Debe") = "0.00"
        tran02("Haber") = "400.50"
        Dim cheques2 As MFObject = New MFObject("Cheque")
        Dim che02 As MFObject = New MFObject("0")
        che02("Num") = "123456"
        che02("BanEmisNal") = "106"
        che02("BanEmisExt") = "Banco Emisor Extranjero"
        che02("CtaOri") = "12345678910"
        che02("Fecha") = "2014 - 12 - 06"
        che02("Benef") = "Empresa"
        che02("RFC") = "AAA010101AAA"
        che02("Monto") = "200.50"
        che02("Moneda") = "MXN"
        che02("TipCamb") = "1.0"
        che02("Tipo") = "poliza"
        cheques2.AgregaSubnodo(che02)
        tran02.AgregaSubnodo(cheques2)
        transaccion2.AgregaSubnodo(tran02)
        pol1.AgregaSubnodo(transaccion2)
        poliza.AgregaSubnodo(pol1)
        polizas.AgregaSubnodo(poliza)
        Factura.AgregaSubnodo(polizas)
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("modulo", "contabilidad")
        sdk.Iniciales.Add("tipo", "poliza")
        sdk.Iniciales.Add("archivo", "timbrados/ejemplo_contabilida_electronica_polizas.xml")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(ContaC())
        sdk.AgregaObjeto(Factura)
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_escuelas() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "iedu10")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(conceptos_escuelas())
        sdk.AgregaObjeto(Impuestos2())
        sdk.AgregaObjeto(complementoEscuela())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(CfdiRelacionados())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos2())
        sdk.AgregaObjeto(Impuestos3())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_aduana() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "aduana")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_aduana.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_aduana.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(conceptos_aduana())
        sdk.AgregaObjeto(Impuestos3())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_dolar() As String
        sdk = New MFSDK()
        PreparaArbol()
        'sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_dolar.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_dolar.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura_dolar())
        sdk.AgregaObjeto(emisor_old())
        sdk.AgregaObjeto(receptor_old())
        sdk.AgregaObjeto(conceptos_old())
        sdk.AgregaObjeto(impuestos_old())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_cheque() As String
        sdk = New MFSDK()
        PreparaArbol()
        'sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_cheque.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura_cheque())
        sdk.AgregaObjeto(emisor_old())
        sdk.AgregaObjeto(receptor_old())
        sdk.AgregaObjeto(conceptos_old())
        sdk.AgregaObjeto(impuestos_old())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function algunos_ejemplos(complemento As MFObject, nombre As String) As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", nombre)
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_" + nombre + ".xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_" + nombre + ".xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(CfdiRelacionados())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos3())
        sdk.AgregaObjeto(Impuestos3())
        sdk.AgregaObjeto(complemento)
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_comercio() As String
        Return algunos_ejemplos(complementoComercio(), "comercio_exterior11")
    End Function

    Public Function ejemplo_factura_notarios() As String
        Return algunos_ejemplos(complementoNotariosPublicos(), "notariosPublicos10")
    End Function

    Public Function ejemplo_factura_hoteles() As String
        Return algunos_ejemplos(complementoHoteles(), "hoteles10")
    End Function

    Public Function ejemplo_factura_ine() As String
        Return algunos_ejemplos(complementoINE(), "ine11")
    End Function

    Public Function ejemplo_factura_parciales_construccion() As String
        Return algunos_ejemplos(complementoParcialesConstruccion(), "parcialesconstruccion10")
    End Function

    Public Function ejemplo_factura_parcialidades() As String
        sdk = New MFSDK()
        PreparaArbol()
        'sdk.Iniciales.Add("version_cfdi", "3.3")
        'sdk.Iniciales.Add("complemento", "parcialidades")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_parcialidades.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_parcialidades.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(factura_parcialidad())
        sdk.AgregaObjeto(emisor_old())
        sdk.AgregaObjeto(receptor_old())
        sdk.AgregaObjeto(conceptos_old())
        sdk.AgregaObjeto(impuestos_old())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_terceros() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "terceros11")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_terceros.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_terceros.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos3())
        sdk.AgregaObjeto(Impuestos3())
        sdk.AgregaObjeto(complementoTerceros())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_factura_honorarios() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "honorarios")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_honorarios.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_honorarios.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos3())
        sdk.AgregaObjeto(Impuestos2())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_impuestos_todos() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.Iniciales.Add("version_cfdi", "3.3")
        sdk.Iniciales.Add("complemento", "implocal10")
        sdk.Iniciales.Add("MODOINI", "INI")
        sdk.Iniciales.Add("cfdi", "C:\sdk2\timbrados\cfdi_ejemplo_factura_implocal10.xml")
        sdk.Iniciales.Add("xml_debug", "C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_implocal10.xml")
        sdk.Iniciales.Add("remueve_acentos", "NO")
        sdk.Iniciales.Add("RESPUESTA_UTF8", "SI")
        sdk.Iniciales.Add("html_a_txt", "NO")
        sdk.AgregaObjeto(PAC())
        sdk.AgregaObjeto(Conf())
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos3())
        sdk.AgregaObjeto(Impuestos2())
        sdk.AgregaObjeto(complementoImpLocales())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_impuestos_locales() As String
        Return algunos_ejemplos(complementoImpLocales(), "implocal10")
    End Function

    Public Function ejemplo_nomina() As String
        Return algunos_ejemplos(complementoNomina(), "nomina12")
    End Function

    Public Function ejemplo_nomina_acciones() As String
        Return algunos_ejemplos(complementoNominaAcciones(), "nomina12")
    End Function

    Public Function ejemplo_nomina_finiquito() As String
        Return algunos_ejemplos(complementoNominaFiniquito(), "nomina12")
    End Function

    Public Function ejemplo_nomina_gobierno() As String
        Return algunos_ejemplos(complementoNominaGobierno(), "nomina12")
    End Function

    Public Function ejemplo_nomina_horasextra() As String
        Return algunos_ejemplos(complementoNominaHorasExtra(), "nomina12")
    End Function

    Public Function ejemplo_nomina_incapacidades() As String
        Return algunos_ejemplos(complementoNominaIncapacidades(), "nomina12")
    End Function

    Public Function ejemplo_nomina_jubilacion() As String
        Return algunos_ejemplos(complementoNominaJubilacion(), "nomina12")
    End Function

    Public Function ejemplo_nomina_subcontratacion() As String
        Return algunos_ejemplos(complementoNominaSubcontratacion(), "nomina12")
    End Function

    Public Function ejemplo_nomina_subsidio() As String
        Return algunos_ejemplos(complementoNominaSubsidio(), "nomina12")
    End Function

    Public Function ejemplo_nomina_todo() As String
        Return algunos_ejemplos(complementoNominaTodo(), "nomina12")
    End Function

    Public Function ejemplo_ticket_factura() As String
        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim con0 As MFObject = New MFObject("0")
        con0("pcantidad") = "2"
        con0("punidad") = "PIEZA"
        con0("pcodigo") = "COD1"
        con0("pdescripcion") = "PRODUCTO PRUEBA 1"
        con0("punitario") = "110.00"
        con0("psubtotal") = "220.00"
        Dim con1 As MFObject = New MFObject("1")
        con1("pcantidad") = "2"
        con1("punidad") = "PIEZA"
        con1("pcodigo") = "COD2"
        con1("pdescripcion") = "PRODUCTO PRUEBA 2"
        con1("punitario") = "110.00"
        con1("psubtotal") = "220.00"
        Dim con2 As MFObject = New MFObject("2")
        con2("pcantidad") = "2"
        con2("punidad") = "PIEZA"
        con2("pcodigo") = "COD3"
        con2("pdescripcion") = "PRODUCTO PRUEBA 3"
        con2("punitario") = "110.00"
        con2("psubtotal") = "220.00"
        Dim con3 As MFObject = New MFObject("3")
        con3("pcantidad") = "2"
        con3("punidad") = "PIEZA"
        con3("pcodigo") = "COD4"
        con3("pdescripcion") = "PRODUCTO PRUEBA 4"
        con3("punitario") = "110.00"
        con3("psubtotal") = "220.00"
        Dim con4 As MFObject = New MFObject("4")
        con4("pcantidad") = "2"
        con4("punidad") = "PIEZA"
        con4("pcodigo") = "COD5"
        con4("pdescripcion") = "PRODUCTO PRUEBA 5"
        con4("punitario") = "110.00"
        con4("psubtotal") = "220.00"
        Dim con5 As MFObject = New MFObject("5")
        con5("pcantidad") = "2"
        con5("punidad") = "PIEZA"
        con5("pcodigo") = "COD6"
        con5("pdescripcion") = "PRODUCTO PRUEBA 6"
        con5("punitario") = "110.00"
        con5("psubtotal") = "220.00"
        Dim con6 As MFObject = New MFObject("6")
        con6("pcantidad") = "2"
        con6("punidad") = "PIEZA"
        con6("pcodigo") = "COD7"
        con6("pdescripcion") = "PRODUCTO PRUEBA 7"
        con6("punitario") = "110.00"
        con6("psubtotal") = "220.00"
        Dim con7 As MFObject = New MFObject("7")
        con7("pcantidad") = "2"
        con7("punidad") = "PIEZA"
        con7("pcodigo") = "COD8"
        con7("pdescripcion") = "PRODUCTO PRUEBA 8"
        con7("punitario") = "110.00"
        con7("psubtotal") = "220.00"
        Dim con8 As MFObject = New MFObject("8")
        con8("pcantidad") = "2"
        con8("punidad") = "PIEZA"
        con8("pcodigo") = "COD9"
        con8("pdescripcion") = "PRODUCTO PRUEBA 9"
        con8("punitario") = "110.00"
        con8("psubtotal") = "220.00"
        Dim con9 As MFObject = New MFObject("9")
        con9("pcantidad") = "2"
        con9("punidad") = "PIEZA"
        con9("pcodigo") = "COD10"
        con9("pdescripcion") = "PRODUCTO PRUEBA 10"
        con9("punitario") = "110.00"
        con9("psubtotal") = "220.00"
        Conceptos.AgregaSubnodo(con0)
        Conceptos.AgregaSubnodo(con1)
        Conceptos.AgregaSubnodo(con2)
        Conceptos.AgregaSubnodo(con3)
        Conceptos.AgregaSubnodo(con4)
        Conceptos.AgregaSubnodo(con5)
        Conceptos.AgregaSubnodo(con6)
        Conceptos.AgregaSubnodo(con7)
        Conceptos.AgregaSubnodo(con8)
        Conceptos.AgregaSubnodo(con9)
        sdk = New MFSDK()
        PreparaArbol()
        sdk.AgregaObjeto(Conceptos)
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemploTodo() As String
        sdk = New MFSDK()
        PreparaArbol()
        sdk.AgregaObjeto(Factura())
        sdk.AgregaObjeto(CfdiRelacionados())
        sdk.AgregaObjeto(Emisor())
        sdk.AgregaObjeto(Receptor())
        sdk.AgregaObjeto(Conceptos())
        sdk.AgregaObjeto(Impuestos())
        sdk.AgregaObjeto(complementoNominaTodo())
        'sdk.AgregaObjeto(complementoComercio())    
        'sdk.AgregaObjeto(complementoINE())
        'sdk.AgregaObjeto(complementoEscuela())
        'sdk.AgregaObjeto(complementoTerceros())
        'sdk.AgregaObjeto(complementoImpLocales())
        'sdk.AgregaObjeto(complementoAcreditamientoIEPS())
        'sdk.AgregaObjeto(complementoAerolineas())
        'sdk.AgregaObjeto(complementoCertificadoDestruccion())
        'sdk.AgregaObjeto(complementoCFDIRegistroFiscal())
        'sdk.AgregaObjeto(complementoConsumoCombustibles())
        'sdk.AgregaObjeto(complementoDetallista())
        'sdk.AgregaObjeto(complementoDivisas())
        'sdk.AgregaObjeto(complementoDonatarias())
        'sdk.AgregaObjeto(complementoEstadoCuentaComb())
        'sdk.AgregaObjeto(complementoHoteles())
        'sdk.AgregaObjeto(complementoLeyendasFisc())
        'sdk.AgregaObjeto(complementoNotariosPublic Functionos())
        'sdk.AgregaObjeto(complementoObrasAntiguedades())
        'sdk.AgregaObjeto(complementoPagoEnEspecie())
        'sdk.AgregaObjeto(complementoPagos())
        'sdk.AgregaObjeto(complementoParcialesConstruccion())
        'sdk.AgregaObjeto(complementoPFintegranteCoordinado())
        'sdk.AgregaObjeto(complementoRenovacionVehiculos())
        'sdk.AgregaObjeto(complementoSPEI())
        'sdk.AgregaObjeto(complementoTimbreFiscalDigital())
        'sdk.AgregaObjeto(complementoTuristaPE())
        'sdk.AgregaObjeto(complementoValeDespensa())
        'sdk.AgregaObjeto(complementoVehiculoUsado())
        'sdk.AgregaObjeto(complementoVentaVehiculos())
        Dim myIni As String = sdk.GeneraINI("") ' "C:\\multifacturas_sdk\\aimeemia")
        Return myIni
    End Function

    Public Function ejemplo_detallista() As String
        Return algunos_ejemplos(complementoDetallista(), "detallista131")
    End Function

    Public Function complementoNomina() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"

        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"

        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"

        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaTodo() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nreceptor("Sindicalizado") = ""
        nreceptor("TipoJornada") = ""
        Dim subcontratacion As MFObject = New MFObject("SubContratacion")
        subcontratacion("RfcLabora") = "VOC990129I26"
        subcontratacion("PorcentajeTiempo") = "100.00"
        nreceptor.AgregaSubnodo(subcontratacion)
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        'Complemento NominaGobierno
        Dim entidad As MFObject = New MFObject("EntidadSNCF")
        entidad("OrigenRecurso") = "IF"
        nemisor.AgregaSubnodo(entidad)
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        npercepciones("TotalSeparacionIndemnizacion") = "15000.00"
        npercepciones("TotalJubilacionPensionRetiro") = "21300.00"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        Dim horasextra As MFObject = New MFObject("HorasExtra")
        Dim hora0 As MFObject = New MFObject("0")
        hora0("Dias") = "2"
        hora0("TipoHoras") = "01"
        hora0("HorasExtra") = "8"
        hora0("ImportePagado") = "105.70"
        Dim hora1 As MFObject = New MFObject("1")
        hora1("Dias") = "1"
        hora1("TipoHoras") = "02"
        hora1("HorasExtra") = "6"
        hora1("ImportePagado") = "1000.00"
        horasextra.AgregaSubnodo(hora0)
        horasextra.AgregaSubnodo(hora1)
        nper2.AgregaSubnodo(horasextra)
        Dim percepcion3 As MFObject = New MFObject("3")
        percepcion3("TipoPercepcion") = "045"
        percepcion3("Clave") = "045"
        percepcion3("Concepto") = "Premios por puntualidad"
        percepcion3("ImporteGravado") = "3000.00"
        percepcion3("ImporteExento") = "0.00"
        Dim acciones As MFObject = New MFObject("AccionesOTitulos")
        acciones("ValorMercado") = "1000.00"
        acciones("PrecioAlOtorgarse") = "2000.00"
        percepcion3.AgregaSubnodo(acciones)
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        npercepciones.AgregaSubnodo(percepcion3)
        Dim jubilacion As MFObject = New MFObject("JubilacionPensionRetiro")
        jubilacion("IngresoAcumulable") = "1000.00"
        jubilacion("IngresoNoAcumulable") = "300.00"
        jubilacion("TotalUnaExhibicion") = "20000.00"
        npercepciones.AgregaSubnodo(jubilacion)
        Dim separacion As MFObject = New MFObject("SeparacionIndemnizacion")
        separacion("TotalPagado") = "15000.00"
        separacion("NumAñosServicio") = "3"
        separacion("UltimoSueldoMensOrd") = "5000.00"
        separacion("IngresoAcumulable") = "3000.00"
        separacion("IngresoNoAcumulable") = "1000.00"
        npercepciones.AgregaSubnodo(separacion)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Dim Pagos As MFObject = New MFObject("OtrosPagos")
        Dim pago0 As MFObject = New MFObject("0")
        pago0("TipoOtroPago") = "002"
        pago0("Clave") = "012"
        pago0("Concepto") = "Subsidio para el empleo"
        pago0("Importe") = "5000.00"
        Dim subsidio As MFObject = New MFObject("SubsidioAlEmpleo")
        subsidio("SubsidioCausado") = "5000.00"

        'Compensación saldos a favor
        Dim compensacion As MFObject = New MFObject("CompensacionSaldosAFavor")
        compensacion("SaldoAFavor") = "300.00"
        compensacion("Año") = "2017"
        compensacion("RemanenteSalFav") = "100.00"
        pago0.AgregaSubnodo(compensacion)
        pago0.AgregaSubnodo(subsidio)
        Pagos.AgregaSubnodo(pago0)
        nomina.AgregaSubnodo(Pagos)
        ' Incapacidades
        Dim incapacidades As MFObject = New MFObject("Incapacidades")
        Dim incapacidad0 As MFObject = New MFObject("0")
        incapacidad0("DiasDeIncapacidad") = "2"
        incapacidad0("TipoIncapacidad") = "01"
        incapacidad0("ImporteMonetario") = "300.00"
        incapacidades.AgregaSubnodo(incapacidad0)
        nomina.AgregaSubnodo(incapacidades)
        Return nomina
    End Function

    Public Function complementoNominaAcciones() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"

        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"

        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"

        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        Dim percepcion3 As MFObject = New MFObject("3")
        percepcion3("TipoPercepcion") = "045"
        percepcion3("Clave") = "045"
        percepcion3("Concepto") = "Premios por puntualidad"
        percepcion3("ImporteGravado") = "3000.00"
        percepcion3("ImporteExento") = "0.00"
        Dim acciones As MFObject = New MFObject("AccionesOTitulos")
        acciones("ValorMercado") = "1000.00"
        acciones("PrecioAlOtorgarse") = "2000.00"
        percepcion3.AgregaSubnodo(acciones)
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        npercepciones.AgregaSubnodo(percepcion3)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaFiniquito() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        Dim subcontratacion As MFObject = New MFObject("SubContratacion")
        subcontratacion("RfcLabora") = "VOC990129I26"
        subcontratacion("PorcentajeTiempo") = "100.00"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        npercepciones("TotalSeparacionIndemnizacion") = "15000.00"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        Dim separacion As MFObject = New MFObject("SeparacionIndemnizacion")
        separacion("TotalPagado") = "15000.00"
        separacion("NumAñosServicio") = "3"
        separacion("UltimoSueldoMensOrd") = "5000.00"
        separacion("IngresoAcumulable") = "3000.00"
        separacion("IngresoNoAcumulable") = "1000.00"
        npercepciones.AgregaSubnodo(separacion)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaGobierno() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        'Complemento NominaGobierno
        Dim entidad As MFObject = New MFObject("EntidadSNCF")
        entidad("OrigenRecurso") = "IF"
        nemisor.AgregaSubnodo(entidad)
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaHorasExtra() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        Dim horasextra As MFObject = New MFObject("HorasExtra")
        Dim hora0 As MFObject = New MFObject("0")
        hora0("Dias") = "2"
        hora0("TipoHoras") = "01"
        hora0("HorasExtra") = "8"
        hora0("ImportePagado") = "105.70"
        Dim hora1 As MFObject = New MFObject("1")
        hora1("Dias") = "1"
        hora1("TipoHoras") = "02"
        hora1("HorasExtra") = "6"
        hora1("ImportePagado") = "1000.00"
        horasextra.AgregaSubnodo(hora0)
        horasextra.AgregaSubnodo(hora1)
        nper2.AgregaSubnodo(horasextra)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaJubilacion() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        npercepciones("TotalJubilacionPensionRetiro") = "21300.00"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        Dim jubilacion As MFObject = New MFObject("JubilacionPensionRetiro")
        jubilacion("IngresoAcumulable") = "1000.00"
        jubilacion("IngresoNoAcumulable") = "300.00"
        jubilacion("TotalUnaExhibicion") = "20000.00"
        npercepciones.AgregaSubnodo(jubilacion)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaSubcontratacion() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        Dim subcontratacion As MFObject = New MFObject("SubContratacion")
        subcontratacion("RfcLabora") = "VOC990129I26"
        subcontratacion("PorcentajeTiempo") = "100.00"
        nreceptor.AgregaSubnodo(subcontratacion)
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Return nomina
    End Function

    Public Function complementoNominaSubsidio() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        Dim Pagos As MFObject = New MFObject("OtrosPagos")
        Dim pago0 As MFObject = New MFObject("0")
        pago0("TipoOtroPago") = "002"
        pago0("Clave") = "012"
        pago0("Concepto") = "Subsidio para el empleo"
        pago0("Importe") = "5000.00"
        Dim subsidio As MFObject = New MFObject("SubsidioAlEmpleo")
        subsidio("SubsidioCausado") = "5000.00"

        'Compensación saldos a favor
        Dim compensacion As MFObject = New MFObject("CompensacionSaldosAFavor")
        compensacion("SaldoAFavor") = "300.00"
        compensacion("Año") = "2017"
        compensacion("RemanenteSalFav") = "100.00"
        pago0.AgregaSubnodo(compensacion)
        pago0.AgregaSubnodo(subsidio)
        Pagos.AgregaSubnodo(pago0)
        nomina.AgregaSubnodo(Pagos)
        Return nomina
    End Function

    Public Function complementoNominaIncapacidades() As MFObject
        Dim nomina As MFObject = New MFObject("Nomina")
        nomina("TipoNomina") = "O"
        nomina("FechaPago") = "2016 - 10 - 31"
        nomina("FechaInicialPago") = "2016-10-16"
        nomina("FechaFinalPago") = "2016-10-31"
        nomina("NumDiasPagados") = "15"
        nomina("TotalPercepciones") = "7500.05"
        nomina("TotalDeducciones") = "1234.09"
        nomina("TotalOtrosPagos") = "0.0"
        Dim nreceptor As MFObject = New MFObject("Receptor")
        nreceptor("ClaveEntFed") = "JAL"
        nreceptor("Curp") = "CACF880922HJCMSR03"
        nreceptor("NumEmpleado") = "060"
        nreceptor("PeriodicidadPago") = "04"
        nreceptor("TipoContrato") = "01"
        nreceptor("TipoRegimen") = "02"
        nreceptor("Antigüedad") = "P21W"
        nreceptor("Banco") = "021"
        nreceptor("CuentaBancaria") = "1234567890"
        nreceptor("Departamento") = ""
        nreceptor("FechaInicioRelLaboral") = "2016-06-01"
        nreceptor("NumSeguridadSocial") = "04078873454"
        nreceptor("Puesto") = "Desarrollador"
        nreceptor("RiesgoPuesto") = "2"
        nreceptor("SalarioBaseCotApor") = "435.50"
        nreceptor("SalarioDiarioIntegrado") = "435.50"
        nomina.AgregaSubnodo(nreceptor)
        Dim nemisor As MFObject = New MFObject("Emisor")
        nemisor("RegistroPatronal") = "5525665412"
        nomina.AgregaSubnodo(nemisor)
        Dim npercepciones As MFObject = New MFObject("Percepciones")
        npercepciones("TotalGravado") = "7500.05"
        npercepciones("TotalExento") = "0.00"
        npercepciones("TotalSueldos") = "7500.05"
        Dim nper0 As MFObject = New MFObject("0")
        nper0("TipoPercepcion") = "001"
        nper0("Clave") = "001"
        nper0("Concepto") = "Sueldos, Salarios Rayas y Jornales"
        nper0("ImporteGravado") = "6250.05"
        nper0("ImporteExento") = "0.00"
        Dim nper1 As MFObject = New MFObject("1")
        nper1("TipoPercepcion") = "049"
        nper1("Clave") = "014"
        nper1("Concepto") = "Premios de asistencia"
        nper1("ImporteGravado") = "625.00"
        nper1("ImporteExento") = "0.00"
        Dim nper2 As MFObject = New MFObject("2")
        nper2("TipoPercepcion") = "010"
        nper2("Clave") = "013"
        nper2("Concepto") = "Premios por puntualidad"
        nper2("ImporteGravado") = "625.00"
        nper2("ImporteExento") = "0.00"
        npercepciones.AgregaSubnodo(nper0)
        npercepciones.AgregaSubnodo(nper1)
        npercepciones.AgregaSubnodo(nper2)
        nomina.AgregaSubnodo(npercepciones)
        Dim ndeducciones As MFObject = New MFObject("Deducciones")
        ndeducciones("TotalOtrasDeducciones") = "179.34"
        ndeducciones("TotalImpuestosRetenidos") = "1054.75"
        Dim nded0 As MFObject = New MFObject("Nomina.Deducciones.0")
        nded0("TipoDeduccion") = "002"
        nded0("Clave") = "001"
        nded0("Concepto") = "ISR"
        nded0("Importe") = "1054.75"
        Dim nded1 As MFObject = New MFObject("1")
        nded1("TipoDeduccion") = "001"
        nded1("Clave") = "012"
        nded1("Concepto") = "Seguridad social"
        nded1("Importe") = "179.34"
        ndeducciones.AgregaSubnodo(nded0)
        ndeducciones.AgregaSubnodo(nded1)
        nomina.AgregaSubnodo(ndeducciones)
        ' Incapacidades
        Dim incapacidades As MFObject = New MFObject("Incapacidades")
        Dim incapacidad0 As MFObject = New MFObject("0")
        incapacidad0("DiasDeIncapacidad") = "2"
        incapacidad0("TipoIncapacidad") = "01"
        incapacidad0("ImporteMonetario") = "300.00"
        incapacidades.AgregaSubnodo(incapacidad0)
        nomina.AgregaSubnodo(incapacidades)
        Return nomina
    End Function

    Public Function complementoComercio() As MFObject
        Dim comercio As MFObject = New MFObject("Comercio")
        comercio("TipoOperacion") = "2"
        comercio("ClaveDePedimento") = "A1"
        comercio("CertificadoOrigen") = "0"
        comercio("NumeroExportadorConfiable") = "0"
        comercio("Incoterm") = "FOB"
        comercio("Subdivision") = "0"
        comercio("Observaciones") = "detalles"
        comercio("TipoCambioUSD") = "10.23"
        comercio("TotalUSD") = "116.00"
        Dim creceptor As MFObject = New MFObject("Receptor")
        creceptor("Curp") = "HEUJ880222HOCTRR04"
        creceptor("NumRegIdTrib") = "123456789"
        comercio.AgregaSubnodo(creceptor)
        Dim cdestinatario As MFObject = New MFObject("Destinatario")
        cdestinatario("NumRegIdTrib") = "123456789"
        cdestinatario("Rfc") = "ESI920427886"
        cdestinatario("Curp") = "HIOK800212HOCTRR01"
        cdestinatario("Nombre") = "str1234"
        Dim domicilio As MFObject = New MFObject("Domicilio")
        domicilio("Calle") = "calle de pruebas"
        domicilio("NumeroExterior") = "1234"
        domicilio("Colonia") = "0995"
        domicilio("Localidad") = "11"
        domicilio("Referencia") = "str1234"
        domicilio("Municipio") = "035"
        domicilio("Estado") = "COA"
        domicilio("Pais") = "MEX"
        domicilio("CodigoPostal") = "27000"
        cdestinatario.AgregaSubnodo(domicilio)
        comercio.AgregaSubnodo(cdestinatario)
        Dim mercancias As MFObject = New MFObject("Mercancias")
        Dim merc0 As MFObject = New MFObject("0")
        merc0("NoIdentificacion") = "A-1215"
        merc0("FraccionArancelaria") = "01011001"
        merc0("CantidadAduana") = "1.0"
        merc0("UnidadAduana") = "1"
        merc0("ValorUnitarioAduana") = "116.00"
        merc0("ValorDolares") = "116.00"
        Dim descs As MFObject = New MFObject("DescripcionesEspecificas")
        Dim desc0 As MFObject = New MFObject("0")
        desc0("Marca") = "YAMAHA"
        desc0("Modelo") = "DDA - 21"
        desc0("SubModelo") = "DDD1"
        desc0("NumeroSerie") = "3292383823"
        Dim desc1 As MFObject = New MFObject("1")
        desc1("Marca") = "str12342"
        desc1("Modelo") = "str12342"
        desc1("SubModelo") = "str12342"
        desc1("NumeroSerie") = "3292383823"
        descs.AgregaSubnodo(desc0)
        descs.AgregaSubnodo(desc1)
        merc0.AgregaSubnodo(descs)
        mercancias.AgregaSubnodo(merc0)
        comercio.AgregaSubnodo(mercancias)
        Return comercio
    End Function

    Public Function complementoINE() As MFObject
        Dim INE As MFObject = New MFObject("INE")
        INE("TipoProceso") = "Campaña"
        Dim entidad As MFObject = New MFObject("Entidad")
        Dim entidad0 As MFObject = New MFObject("0")
        entidad0("ClaveEntidad") = "TAM"
        entidad0("Ambito") = "Local"
        entidad.AgregaSubnodo(entidad0)
        Dim conta As MFObject = New MFObject("Contabilidad")
        Dim conta0 As MFObject = New MFObject("0")
        conta0("idContabilidad") = "010648"
        conta.AgregaSubnodo(conta0)
        entidad.AgregaSubnodo(conta)
        INE.AgregaSubnodo(entidad)
        Return INE
    End Function

    Public Function complementoNotariosPublicos() As MFObject
        ' Notario Publico
        Dim notario As MFObject = New MFObject("NotariosPublicos")
        notario("CURP") = "AAQM010101HCSMNZ00"
        notario("NumNotaria") = "3"
        notario("EntidadFederativa") = "16"
        notario("Adscripcion") = "Guanajuato"
        ' Descripcion de inmuebles
        Dim inmuebles As MFObject = New MFObject("DescInmuebles")
        Dim inmueble0 As MFObject = New MFObject("0")
        inmueble0("Calle") = "Av. Siempre Viva"
        inmueble0("CodigoPostal") = "12345"
        inmueble0("Colonia") = "Bondojito"
        inmueble0("Estado") = "14"
        inmueble0("Localidad") = "Oaxaca"
        inmueble0("Municipio") = "Oaxaca"
        inmueble0("NoExterior") = "123"
        inmueble0("NoInterior") = "B"
        inmueble0("Pais") = "MEX"
        inmueble0("TipoInmueble") = "01"
        inmuebles.AgregaSubnodo(inmueble0)
        notario.AgregaSubnodo(inmuebles)
        Dim datosOperacion As MFObject = New MFObject("DatosOperacion")
        datosOperacion("NumInstrumentoNotarial") = "12345"
        datosOperacion("FechaInstNotarial") = "2014-04-22"
        datosOperacion("MontoOperacion") = "1234.56"
        datosOperacion("Subtotal") = "1234.56"
        datosOperacion("IVA") = "1234.56"
        notario.AgregaSubnodo(datosOperacion)

        ' Datos de Varios Enajenantes
        'Dim enajenantes As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC")
        'Dim enajenante0 As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC.0")
        'enajenante0("Nombre") = "Enajenante 1"
        'enajenante0("ApellidoPaterno") = "Apellido Paterno"
        'enajenante0("ApellidoMaterno") = "Apellido Materno"
        'enajenante0("RFC") = "HSJ600903MN0"
        'enajenante0("CURP") = "OAAJ840102HJCVRN00"
        'enajenante0("Porcentaje") = "50"
        'enajenantes.AgregaSubnodo(enajenante0)

        'Dim enajenante1 As MFObject  = New MFObject("NotariosPublic Functionos.DatosEnajenantesCopSC.1")
        'enajenante1("Nombre") = "Enajenante 2"
        'enajenante1("ApellidoPaterno") = "Apellido Paterno"
        'enajenante1("ApellidoMaterno") = "Apellido Materno"
        'enajenante1("RFC") = "MSB600304KL9"
        'enajenante1("CURP") = "OAAJ840102HJCVRN00"
        'enajenante1("Porcentaje") = "50"
        'enajenantes.AgregaSubnodo(enajenante1)

        'Dim datosEnajenante As MFObject = New MFObject("DatosEnajenante")
        'datosEnajenante["CoproSocConyugalE"] = "Si"
        'datosEnajenante.AgregaSubnodo(enajenantes)
        ' Datos para un Solo Enajenante
        Dim unenajenante As MFObject = New MFObject("DatosUnEnajenante")
        unenajenante("Nombre") = "Enajenante"
        unenajenante("ApellidoPaterno") = "Apellido Paterno"
        unenajenante("ApellidoMaterno") = "Apellido Materno"
        unenajenante("RFC") = "HSJ600903MN0"
        unenajenante("CURP") = "OAAJ840102HJCVRN00"

        Dim datosEnajenante As MFObject = New MFObject("DatosEnajenante")
        datosEnajenante("CoproSocConyugalE") = "No"
        datosEnajenante.AgregaSubnodo(unenajenante)
        notario.AgregaSubnodo(datosEnajenante)

        ' Datos de Varios Adquirientes
        'Dim As MFObject adquirientes = New MFObject("DatosAdquirientesCopSC")
        'Dim As MFObject adquiriente0 = New MFObject("0")
        'adquiriente0("Nombre") = "Adquiriente 1"
        'adquiriente0("ApellidoPaterno") = "Apellido Paterno"
        'adquiriente0("ApellidoMaterno") = "Apellido Materno"
        'adquiriente0("RFC") = "HSJ600903MN0"
        'adquiriente0("CURP") = "OAAJ840102HJCVRN00"
        'adquiriente0("Porcentaje") = "50"
        'adquirientes.AgregaSubnodo(adquiriente0)

        'Dim As MFObject adquiriente1 = New MFObject("1")
        'adquiriente1("Nombre") = "Adquiriente 2"
        'adquiriente1("ApellidoPaterno") = "Apellido Paterno"
        'adquiriente1("ApellidoMaterno") = "Apellido Materno"
        'adquiriente1("RFC") = "MSB600304KL9"
        'adquiriente1("CURP") = "OAAJ840102HJCVRN00"
        'adquiriente1("Porcentaje") = "50"
        'adquirientes.AgregaSubnodo(adquiriente1)

        'Dim As MFObject datosAdquiriente = New MFObject("DatosAdquiriente")
        'datosAdquiriente("CoproSocConyugalE") = "Si"
        'datosAdquiriente.AgregaSubnodo(adquirientes)
        'notario.AgregaSubnodo(datosAdquiriente)

        ' Datos un Solo Adquiriente
        Dim unadquiriente As MFObject = New MFObject("DatosUnAdquiriente")
        unadquiriente("Nombre") = "Adquiriente"
        unadquiriente("ApellidoPaterno") = "Apellido Paterno"
        unadquiriente("ApellidoMaterno") = "Apellido Materno"
        unadquiriente("RFC") = "HSJ600903MN0"
        unadquiriente("CURP") = "OAAJ840102HJCVRN00"

        Dim datosAdquiriente As MFObject = New MFObject("DatosAdquiriente")
        datosAdquiriente("CoproSocConyugalE") = "No"
        datosAdquiriente.AgregaSubnodo(unadquiriente)
        notario.AgregaSubnodo(datosAdquiriente)
        Return notario
    End Function

    Public Function complementoEscuela() As MFObject
        ' IEDU
        Dim IEDU As MFObject = New MFObject("IEDU")
        IEDU("nombreAlumno") = "FULANITO PEREZ OCHOA"
        IEDU("CURP") = "MAGC870912HGTRRS06"
        IEDU("nivelEducativo") = "Preescolar"
        IEDU("autRVOE") = "1234-ABC"
        IEDU("RFCPago") = "SOHM7509289MA"
        Return IEDU
    End Function

    Public Function complementoHoteles() As MFObject
        'Hoteles
        ' Impuestos Locales
        Dim locales As MFObject = New MFObject("ImpuestosLocales")
        Dim trasLocales As MFObject = New MFObject("TrasladoLocal")
        Dim trasLocal0 As MFObject = New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "ISH"
        trasLocal0("Importe") = "10"
        trasLocal0("TasadeTraslado") = "3"
        trasLocales.AgregaSubnodo(trasLocal0)
        locales.AgregaSubnodo(trasLocales)
        Return locales
    End Function

    Public Function complementoTerceros() As MFObject
        Dim terceros As MFObject = New MFObject("terceros11")
        terceros("rfc") = "SOHM7509289MA"
        terceros("nombre") = "maria"
        Dim domTercero As MFObject = New MFObject("InformacionFiscalTercero")
        domTercero("Calle") = "JUAREZ"
        domTercero("CodigoPostal") = "64610"
        domTercero("Estado") = "NUEVO LEON"
        domTercero("Municipio") = "MONTERREY"
        domTercero("Localidad") = "MONTERREY"
        domTercero("Pais") = "MEXICO"
        domTercero("NoExterior") = "7"
        domTercero("NoInterior") = "A"
        domTercero("Colonia") = "DEL VALLE"
        domTercero("referencia") = "nuirenfuf"
        terceros.AgregaSubnodo(domTercero)
        Dim info As MFObject = New MFObject("InformacionAduanera")
        info("numero") = "2331"
        info("fecha") = "2016-10-31"
        info("aduana") = "miaduana"
        terceros.AgregaSubnodo(info)
        Dim partes As MFObject = New MFObject("Parte")
        Dim part0 As MFObject = New MFObject("0")
        part0("cantidad") = "1"
        part0("unidad") = "pieza"
        part0("noIdentificacion") = "56"
        part0("descripcion") = "56vs"
        part0("valorUnitario") = "1000"
        part0("importe") = "1000"
        Dim p0infos As MFObject = New MFObject("InformacionAduanera")
        Dim p0info0 As MFObject = New MFObject("0")
        p0info0("numero") = "15"
        p0info0("fecha") = "2017-05-25"
        p0info0("aduana") = "56vs"
        p0infos.AgregaSubnodo(p0info0)
        part0.AgregaSubnodo(p0infos)
        partes.AgregaSubnodo(part0)
        terceros.AgregaSubnodo(partes)
        Dim predial As MFObject = New MFObject("CuentaPredial")
        predial("numero") = "56"
        terceros.AgregaSubnodo(predial)
        Dim impuestos As MFObject = New MFObject("Impuestos")
        Dim retenciones As MFObject = New MFObject("Retenciones")
        Dim ret0 As MFObject = New MFObject("0")
        ret0("impuesto") = "001"
        ret0("importe") = "0.00"
        Dim traslados As MFObject = New MFObject("Traslados")
        Dim tra0 As MFObject = New MFObject("0")
        tra0("impuesto") = "003"
        tra0("tasa") = "0.16"
        tra0("importe") = "0.00"
        retenciones.AgregaSubnodo(ret0)
        traslados.AgregaSubnodo(tra0)
        impuestos.AgregaSubnodo(retenciones)
        impuestos.AgregaSubnodo(traslados)
        Return terceros
    End Function

    Public Function complementoImpLocales() As MFObject
        ' Impuestos Locales
        Dim locales As MFObject = New MFObject("ImpuestosLocales")
        Dim retLocales As MFObject = New MFObject("RetencionLocal")
        Dim retLocal0 As MFObject = New MFObject("0")
        retLocal0("ImpLocTrasladado") = "ABC"
        retLocal0("TasadeTraslado") = "2"
        retLocal0("Importe") = "11"
        Dim retLocal1 As MFObject = New MFObject("1")
        retLocal1("ImpLocTrasladado") = "DEF"
        retLocal1("TasadeTraslado") = "3"
        retLocal1("Importe") = "13"
        retLocales.AgregaSubnodo(retLocal0)
        retLocales.AgregaSubnodo(retLocal1)
        Dim trasLocales As MFObject = New MFObject("TrasladoLocal")
        Dim trasLocal0 As MFObject = New MFObject("0")
        trasLocal0("ImpLocTrasladado") = "XYZ"
        trasLocal0("TasadeTraslado") = "3"
        trasLocal0("Importe") = "10"
        Dim trasLocal1 As MFObject = New MFObject("1")
        trasLocal1("ImpLocTrasladado") = "ASD"
        trasLocal1("TasadeTraslado") = "3"
        trasLocal1("Importe") = "10"
        trasLocales.AgregaSubnodo(trasLocal0)
        trasLocales.AgregaSubnodo(trasLocal1)
        locales.AgregaSubnodo(retLocales)
        locales.AgregaSubnodo(trasLocales)
        Return locales
    End Function

    Public Function complementoParcialesConstruccion() As MFObject
        Dim parciales As MFObject = New MFObject("ParcialesConstruccion")
        parciales("NumPerLicoAut") = "12345678901234567890"
        Dim inmueble As MFObject = New MFObject("Inmueble")
        inmueble("Calle") = "Juarez"
        inmueble("NoExterior") = "1025"
        inmueble("NoInterior") = "5"
        inmueble("Colonia") = "Centro"
        inmueble("Localidad") = "Torreon"
        inmueble("Referencia") = "Entre Hidalgo y Morelos"
        inmueble("Municipio") = "Torreon"
        inmueble("Estado") = "09"
        inmueble("CodigoPostal") = "27054"
        parciales.AgregaSubnodo(inmueble)
        Return parciales
    End Function

    Public Function complementoAcreditamientoIEPS() As MFObject
        Dim acredita As MFObject = New MFObject("AcreditamientoIEPS")
        acredita("TAR") = "690"
        Return acredita
    End Function

    Public Function complementoAerolineas() As MFObject
        Dim aerolineas As MFObject = New MFObject("Aerolineas")
        aerolineas("TUA") = "2000.00"
        Dim otrosCargos As MFObject = New MFObject("OtrosCargos")
        otrosCargos("TotalCargos") = "2"
        Dim cargo0 As MFObject = New MFObject("0")
        cargo0("CodigoCargo") = "22990"
        cargo0("Importe") = "1000.00"
        Dim cargo1 As MFObject = New MFObject("1")
        cargo1("CodigoCargo") = "14678"
        cargo1("Importe") = "1000.00"
        otrosCargos.AgregaSubnodo(cargo0)
        otrosCargos.AgregaSubnodo(cargo1)
        aerolineas.AgregaSubnodo(otrosCargos)
        Return aerolineas
    End Function

    Public Function complementoCertificadoDestruccion() As MFObject
        Dim destruccion As MFObject = New MFObject("CertificadoDeDestruccion")
        destruccion("Serie") = "27833"
        destruccion("NumFolDesVeh") = "A1"

        Dim vehiculo As MFObject = New MFObject("VehiculoDestruido")
        vehiculo("Marca") = "ford"
        vehiculo("Año") = "2000"
        vehiculo("Modelo") = "FOB"
        vehiculo("NIV") = "te0"
        vehiculo("NumSerie") = "gera43"
        vehiculo("NumPlacas") = "1034"
        vehiculo("NumMotor") = "116"
        vehiculo("NumFolTarjCir") = "DESO801116HGTLRS08"

        Dim infoa As MFObject = New MFObject("InformacionAduanera")
        infoa("NumPedImp") = "HEUJ880222HOCTRR04"
        infoa("Fecha") = "05-04-2017"
        infoa("Aduana") = "123456789"
        destruccion.AgregaSubnodo(vehiculo)
        destruccion.AgregaSubnodo(infoa)
        Return destruccion
    End Function

    Public Function complementoCFDIRegistroFiscal() As MFObject
        Dim regfis As MFObject = New MFObject("CFDIRegistroFiscal")
        regfis("Folio") = "29547033879512844"
        Return regfis
    End Function

    Public Function complementoConsumoCombustibles() As MFObject
        Dim consumo As MFObject = New MFObject("ConsumoDeCombustibles")
        consumo("tipoOperacion") = "gref"
        consumo("numeroDeCuenta") = "908545"
        consumo("subTotal") = "8947.50"
        consumo("total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("identificador") = "123"
        concepto0("fecha") = "05-04-2017"
        concepto0("rfc") = "gaar930830mcl"
        concepto0("claveEstacion") = "8"
        concepto0("cantidad") = "4"
        concepto0("nombreCombustible") = "oil"
        concepto0("folioOperacion") = "243"
        concepto0("valorUnitario") = "35.50"
        concepto0("importe") = "142.00"

        Dim determinados As MFObject = New MFObject("Determinados")
        Dim det0 As MFObject = New MFObject("0")
        det0("impuesto") = "IVA"
        det0("tasa") = "0.16"
        det0("importe") = "130.00"
        Dim det1 As MFObject = New MFObject("1")
        det1("impuesto") = "IEPS"
        det1("tasa") = "0.17"
        det1("importe") = "135.00"
        determinados.AgregaSubnodo(det0)
        determinados.AgregaSubnodo(det1)
        concepto0.AgregaSubnodo(determinados)
        conceptos.AgregaSubnodo(concepto0)

        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("identificador") = "456"
        concepto1("fecha") = "05-04-2017"
        concepto1("rfc") = "gaar930830mcl"
        concepto1("claveEstacion") = "8"
        concepto1("cantidad") = "4"
        concepto1("nombreCombustible") = "oil"
        concepto1("folioOperacion") = "243"
        concepto1("valorUnitario") = "35.50"
        concepto1("importe") = "142.00"
        Dim con1dets As MFObject = New MFObject("Determinados")
        Dim con1det0 As MFObject = New MFObject("0")
        con1det0("impuesto") = "IVA"
        con1det0("tasa") = "0.16"
        con1det0("importe") = "130.00"
        con1dets.AgregaSubnodo(con1det0)
        concepto1.AgregaSubnodo(con1dets)
        Conceptos.AgregaSubnodo(concepto1)
        consumo.AgregaSubnodo(Conceptos)
        Return consumo
    End Function

    Public Function complementoDivisas() As MFObject
        Dim divisas As MFObject = New MFObject("Divisas")
        divisas("tipoOperacion") = "compra"
        Return divisas
    End Function

    Public Function complementoDonatarias() As MFObject
        Dim donat As MFObject = New MFObject("Donatarias")
        donat("noAutorizacion") = "29"
        donat("fechaAutorizacion") = "05-04-2017"
        donat("leyEnd Functiona") = "mileyEnd Functiona"
        Return donat
    End Function

    Public Function complementoEstadoCuentaComb() As MFObject

        Dim ecc As MFObject = New MFObject("EstadoDeCuentaCombustible")
        ecc("TipoOperacion") = "gref"
        ecc("NumeroDeCuenta") = "908545"
        ecc("SubTotal") = "8947.50"
        ecc("Total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim concepto0 As MFObject = New MFObject("0")
        concepto0("Identificador") = "123"
        concepto0("Fecha") = "05-04-2017"
        concepto0("Rfc") = "gaar930830mcl"
        concepto0("ClaveEstacion") = "8"
        concepto0("TAR") = "667"
        concepto0("Cantidad") = "4"
        concepto0("NoIdentificacion") = "51"
        concepto0("Unidad") = "32011"
        concepto0("NombreCombustible") = "oil"
        concepto0("FolioOperacion") = "243"
        concepto0("ValorUnitario") = "35.50"
        concepto0("Importe") = "142.00"

        Dim traslados As MFObject = New MFObject("Traslados")
        Dim tras0 As MFObject = New MFObject("0")
        tras0("Impuesto") = "IVA"
        tras0("TasaoCuota") = "0.16"
        tras0("Importe") = "130.00"
        Dim tras1 As MFObject = New MFObject("1")
        tras1("Impuesto") = "IEPS"
        tras1("TasaoCuota") = "0.17"
        tras1("Importe") = "135.00"
        traslados.AgregaSubnodo(tras0)
        traslados.AgregaSubnodo(tras1)
        concepto0.AgregaSubnodo(traslados)
        conceptos.AgregaSubnodo(concepto0)

        Dim concepto1 As MFObject = New MFObject("1")
        concepto1("Identificador") = "456"
        concepto1("Fecha") = "05-04-2017"
        concepto1("Rfc") = "gaar930830mcl"
        concepto1("ClaveEstacion") = "8"
        concepto1("TAR") = "667"
        concepto1("Cantidad") = "4"
        concepto1("NoIdentificacion") = "51"
        concepto1("Unidad") = "32011"
        concepto1("NombreCombustible") = "oil"
        concepto1("FolioOperacion") = "243"
        concepto1("ValorUnitario") = "35.50"
        concepto1("Importe") = "142.00"

        Dim con0tras0 As MFObject = New MFObject("0")
        con0tras0("Impuesto") = "IEPS"
        con0tras0("TasaoCuota") = "0.16"
        con0tras0("Importe") = "130.00"
        concepto0.AgregaSubnodo(con0tras0)
        conceptos.AgregaSubnodo(concepto1)
        ecc.AgregaSubnodo(conceptos)
        Return ecc
    End Function

    Public Function complementoLeyendasFisc() As MFObject
        Dim leyendas As MFObject = New MFObject("LeyendasFiscales")
        Dim ley0 As MFObject = New MFObject("0")
        Dim ley1 As MFObject = New MFObject("1")
        ley0("disposicionFiscal") = "htr"
        ley0("norma") = "grea"
        ley0("textoLeyEnd Functiona") = "ergtr"

        ley1("disposicionFiscal") = "hrdy"
        ley1("norma") = "dwq"
        ley1("textoLeyEnd Functiona") = "fwe"
        leyendas.AgregaSubnodo(ley0)
        leyendas.AgregaSubnodo(ley1)
        Return leyendas
    End Function

    Public Function complementoObrasAntiguedades() As MFObject
        Dim arte As MFObject = New MFObject("ObrasArteAntiguedades")
        arte("TipoBien") = "02"
        arte("OtrosTipoBien") = "miarte"
        arte("TituloAdquirido") = "03"
        arte("OtrosTituloAdquirido") = "mititulo"
        arte("Subtotal") = "160.00"
        arte("IVA") = "16.00"
        arte("FechaAdquisicion") = "05-04-2017"
        arte("CaracterísticasDeObraoPieza") = "07"
        Return arte
    End Function

    Public Function complementoPagoEnEspecie() As MFObject
        Dim pagos As MFObject = New MFObject("PagoEnEspecie")
        pagos("CvePIC") = "X100081000986725341974620" ' (A - ZÑ&)3End Function(0-9)2End Function(0-1)(0-9)(0-3)(0-9)(A-Z0-9)?(A-Z0-9)?(0-9A-Z)-(18|19|20)\d\d(0(1-9)|1(012))(0(1-9)|(12)(0-9)|3(01))-(0-9)3End Function
        pagos("FolioSolDon") = "PE-22-12345" ' PE - (0 - 9)2End Function-(0-9)5End Function
        pagos("PzaArtNombre") = "Las Flores"
        pagos("PzaArtTecn") = "Cubismo al Óleo"
        pagos("PzaArtAProd") = "2013"
        pagos("PzaArtDim") = "50cmx100cm"
        Return pagos
    End Function

    Public Function complementoPFintegranteCoordinado() As MFObject
        Dim pfic As MFObject = New MFObject("PFIntegranteCoordinado")
        pfic("ClaveVehicular") = "29547033879512844"
        pfic("Placa") = "456543R"
        pfic("RFCPF") = "FESRGTG43"
        Return pfic
    End Function

    Public Function complementoTimbreFiscalDigital() As MFObject
        Dim tfd As MFObject = New MFObject("TimbreFiscalDigital")
        tfd("UUID") = "29547033879512844"
        tfd("FechaTimbrado") = "10-05-2017"
        tfd("selloCFD") = "FESRGTG43"
        tfd("noCertificadoSAT") = "456543R"
        tfd("selloSAT") = "FESRGTG4323"
        Return tfd
    End Function

    Public Function complementoTuristaPE() As MFObject
        Dim tpe As MFObject = New MFObject("TuristaPasajeroExtranjero")
        tpe("fechadeTransito") = "gref"
        tpe("tipoTransito") = "908545"

        Dim datosTransito As MFObject = New MFObject("datosTransito")
        datosTransito("Via") = "4"
        datosTransito("TipoId") = "05"
        datosTransito("NumeroId") = "123"
        datosTransito("Nacionalidad") = "Mexicana"
        datosTransito("EmpresaTransporte") = "Chihuahuenses"
        datosTransito("IdTransporte") = "80805"
        tpe.AgregaSubnodo(datosTransito)
        Return tpe
    End Function

    Public Function complementoValeDespensa() As MFObject
        Dim vales As MFObject = New MFObject("ValesDeDespensa")
        vales("tipoOperacion") = "gref"
        vales("registroPatronal") = "908545"
        vales("numeroDeCuenta") = "8947.50"
        vales("total") = "12345.50"

        Dim conceptos As MFObject = New MFObject("Conceptos")
        Dim con0 As MFObject = New MFObject("0")
        Dim con1 As MFObject = New MFObject("1")
        con0("identificador") = "123"
        con0("fecha") = "05-04-2017"
        con0("rfc") = "gaar930830mcl"
        con0("curp") = "8"
        con0("nombre") = "4"
        con0("numSeguridadSocial") = "oil"
        con0("importe") = "142.00"

        con1("identificador") = "456"
        con1("fecha") = "05-04-2017"
        con1("rfc") = "gaar930830mcl"
        con1("curp") = "8"
        con1("nombre") = "4"
        con1("numSeguridadSocial") = "oil"
        con1("importe") = "142.00"
        conceptos.AgregaSubnodo(con0)
        conceptos.AgregaSubnodo(con1)
        vales.AgregaSubnodo(conceptos)
        Return vales
    End Function

    Public Function complementoVehiculoUsado() As MFObject
        Dim vehus As MFObject = New MFObject("VehiculoUsado")
        vehus("montoAdquisicion") = "2"
        vehus("montoEnajenacion") = "A1"
        vehus("claveVehicular") = "A1"
        vehus("marca") = "A1"
        vehus("tipo") = "A1"
        vehus("modelo") = "A1"
        vehus("numeroMotor") = "A1"
        vehus("numeroSerie") = "A1"
        vehus("NIV") = "A1"
        vehus("valor") = "A1"

        Dim infoads As MFObject = New MFObject("InformacionAduanera")
        Dim info0 As MFObject = New MFObject("0")
        info0("numero") = "12"
        info0("fecha") = "11-04-2017"
        info0("aduana") = "gtr"
        Dim info1 As MFObject = New MFObject("1")
        info1("numero") = "76"
        info1("fecha") = "11-04-2017"
        info1("aduana") = "oiu"
        infoads.AgregaSubnodo(info0)
        infoads.AgregaSubnodo(info1)
        vehus.AgregaSubnodo(infoads)
        Return vehus
    End Function

    Public Function complementoVentaVehiculos() As MFObject

        Dim veve As MFObject = New MFObject("VentaVehiculos")
        veve("ClaveVehicular") = "2"
        veve("Niv") = "A1"

        Dim infoads As MFObject = New MFObject("InformacionAduanera")
        Dim info0 As MFObject = New MFObject("0")
        info0("numero") = "12"
        info0("fecha") = "11-04-2017"
        info0("aduana") = "gtr"
        Dim info1 As MFObject = New MFObject("1")
        info1("numero") = "76"
        info1("fecha") = "11-04-2017"
        info1("aduana") = "oiu"
        infoads.AgregaSubnodo(info0)
        infoads.AgregaSubnodo(info1)
        veve.AgregaSubnodo(infoads)
        Dim partes As MFObject = New MFObject("Parte")
        Dim part0 As MFObject = New MFObject("0")
        part0("cantidad") = "116.00"
        part0("unidad") = "0"
        part0("noIdentificacion") = "detalles"
        part0("descripcion") = "10.23"
        part0("valorUnitario") = "116.00"
        part0("importe") = "116.00"

        Dim infoads2 As MFObject = New MFObject("InformacionAduanera")
        Dim info02 As MFObject = New MFObject("0")
        info02("numero") = "2"
        info02("fecha") = "10-04-2017"
        info02("aduana") = "wed"
        Dim info12 As MFObject = New MFObject("1")
        info12("numero") = "3"
        info12("fecha") = "05-04-2017"
        info12("aduana") = "ntu"
        infoads2.AgregaSubnodo(info02)
        infoads2.AgregaSubnodo(info12)
        part0.AgregaSubnodo(infoads2)
        Dim part1 As MFObject = New MFObject("1")
        part1("cantidad") = "112"
        part1("unidad") = "76"
        part1("noIdentificacion") = "098"
        part1("descripcion") = "kye"
        part1("valorUnitario") = "119.00"
        part1("importe") = "119.00"
        partes.AgregaSubnodo(part0)
        partes.AgregaSubnodo(part1)
        veve.AgregaSubnodo(partes)
        Return veve
    End Function

    Public Function complementoPagos() As MFObject
        Dim Pagos As MFObject = New MFObject("Pagos")
        Dim pago0 As MFObject = New MFObject("0")
        pago0("FechaPago") = "0.0"
        pago0("FormaDePagoP") = "0.0"
        pago0("MonedaP") = "0.0"
        pago0("TipoCambioP") = "0.0"
        pago0("Monto") = "0.0"
        pago0("NumOperacion") = "0.0"
        pago0("RfcEmisorCtaOrd") = "0.0"
        pago0("NomBancoOrdExt") = "0.0"
        pago0("CtaOrdenante") = "0.0"
        pago0("RfcEmisorCtaBen") = "0.0"
        pago0("CtaBeneficiario") = "0.0"
        pago0("TipoCadPago") = "0.0"
        pago0("CertPago") = "0.0"
        pago0("CadPago") = "0.0"
        pago0("SelloPago") = "0.0"

        Dim doctos As MFObject = New MFObject("DoctoRelacionado")
        Dim docto0 As MFObject = New MFObject("0")
        docto0("IdDocumento") = "O"
        docto0("Serie") = "2016-10-31"
        docto0("Folio") = "2016-10-16"
        docto0("MonedaDR") = "2016-10-31"
        docto0("TipoCambioDR") = "15"
        docto0("MetodoDePagoDR") = "7500.05"
        docto0("NumParcialidad") = "1234.09"
        docto0("ImpSaldoAnt") = "0.0"
        docto0("ImpPagado") = "7500.05"
        docto0("ImpSaldoInsoluto") = "1234.09"
        doctos.AgregaSubnodo(docto0)
        pago0.AgregaSubnodo(doctos)

        Dim impuestos As MFObject = New MFObject("Impuestos")
        Dim imp0 As MFObject = New MFObject("0")
        imp0("TotalImpuestosRetenidos") = "0.0"
        imp0("TotalImpuestosTrasladados") = "0.0"
        Dim traslados As MFObject = New MFObject("Traslados")
        Dim tras0 As MFObject = New MFObject("0")
        Dim retenciones As MFObject = New MFObject("Retenciones")
        Dim ret0 As MFObject = New MFObject("0")
        tras0("Impuesto") = "0.0"
        tras0("Importe") = "0.0"
        tras0("TipoFactor") = "0.0"
        tras0("TasaOCuota") = "0.0"
        ret0("Importe") = "0.0"
        ret0("Impuesto") = "0.0"
        traslados.AgregaSubnodo(tras0)
        retenciones.AgregaSubnodo(ret0)
        imp0.AgregaSubnodo(traslados)
        imp0.AgregaSubnodo(retenciones)
        impuestos.AgregaSubnodo(imp0)
        pago0.AgregaSubnodo(impuestos)
        Pagos.AgregaSubnodo(pago0)
        Return Pagos
    End Function

    Public Function complementoRenovacionVehiculos() As MFObject
        Dim renysv As MFObject = New MFObject("RenovacionYSustitucionVehiculos")
        renysv("TipoDeDecreto") = "2"
        Dim decreto As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular")
        decreto("VehEnaj") = "A1"
        Dim dec0 As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular.0")
        dec0("PrecioVehUsado") = "A1"
        dec0("TipoVeh") = "A1"
        dec0("Marca") = "A1"
        dec0("TipooClase") = "A1"
        dec0("Año") = "A1"
        dec0("Modelo") = "A1"
        dec0("NIV") = "A1"
        dec0("NumSerie") = "A1"
        dec0("NumPlacas") = "A1"
        dec0("NumMotor") = "A1"
        dec0("NumFolTarjCir") = "A1"
        dec0("NumPedIm") = "A1"
        dec0("Aduana") = "A1"
        dec0("FechaRegulVeh") = "A1"
        dec0("Foliofiscal") = "A1"
        decreto.AgregaSubnodo(dec0)

        Dim venusenafalperm As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoRenovVehicular.VehiculoNuvoSemEnajenadoFabAlPerm")
        venusenafalperm("Año") = "2012"
        venusenafalperm("Modelo") = "fre"
        venusenafalperm("NumPlacas") = "786dfsr"
        venusenafalperm("RFC") = "fg4378gv86t2374"
        decreto.AgregaSubnodo(venusenafalperm)
        renysv.AgregaSubnodo(decreto)

        Dim decretoSustit As MFObject = New MFObject("RenovacionYSustitucionVehiculos.DecretoSustitVehicular")
        decretoSustit("VehEnaj") = "A1"
        Dim veusenpealfa As MFObject = New MFObject("VehiculoUsadoEnajenadoPermAlFab")
        veusenpealfa("PrecioVehUsado") = "A1"
        veusenpealfa("TipoVeh") = "A1"
        veusenpealfa("Marca") = "A1"
        veusenpealfa("TipooClase") = "A1"
        veusenpealfa("Año") = "A1"
        veusenpealfa("Modelo") = "A1"
        veusenpealfa("NIV") = "A1"
        veusenpealfa("NumSerie") = "A1"
        veusenpealfa("NumPlacas") = "A1"
        veusenpealfa("NumMotor") = "A1"
        veusenpealfa("NumFolTarjCir") = "A1"
        veusenpealfa("NumFolAvisoint") = "A1"
        veusenpealfa("NumPedIm") = "A1"
        veusenpealfa("Aduana") = "A1"
        veusenpealfa("FechaRegulVeh") = "A1"
        veusenpealfa("Foliofiscal") = "A1"
        decretoSustit.AgregaSubnodo(veusenpealfa)

        Dim venusenafalperm2 As MFObject = New MFObject("VehiculoNuvoSemEnajenadoFabAlPerm")
        venusenafalperm2("Año") = "A1"
        venusenafalperm2("Modelo") = "A1"
        venusenafalperm2("NumPlacas") = "A1"
        venusenafalperm2("RFC") = "A1"
        decretoSustit.AgregaSubnodo(venusenafalperm2)
        renysv.AgregaSubnodo(decretoSustit)
        Return renysv
    End Function

    Public Function complementoSPEI() As MFObject
        Dim SPEI As MFObject = New MFObject("SPEI")
        Dim sterceros As MFObject = New MFObject("SPEI_Tercero")
        Dim spei0 As MFObject = New MFObject("0")
        spei0("FechaOperacion") = "O"
        spei0("Hora") = "2016-10-31"
        spei0("ClaveSPEI") = "2016-10-16"
        spei0("sello") = "2016-10-31"
        spei0("numeroCertificado") = "15"
        spei0("cadenaCDA") = "15"

        Dim ordenante As MFObject = New MFObject("Ordenante")
        ordenante("BancoEmisor") = "O"
        ordenante("Nombre") = "O"
        ordenante("TipoCuenta") = "O"
        ordenante("Cuenta") = "O"
        ordenante("RFC") = "O"

        Dim beneficiario As MFObject = New MFObject("Beneficiario")
        beneficiario("BancoReceptor") = "O"
        beneficiario("Nombre") = "O"
        beneficiario("TipoCuenta") = "O"
        beneficiario("Cuenta") = "O"
        beneficiario("RFC") = "O"
        beneficiario("Concepto") = "O"
        beneficiario("IVA") = "O"
        beneficiario("MontoPago") = "O"
        spei0.AgregaSubnodo(ordenante)
        spei0.AgregaSubnodo(beneficiario)
        sterceros.AgregaSubnodo(spei0)

        Dim spei1 As MFObject = New MFObject("1")
        spei1("FechaOperacion") = "fewO"
        spei1("Hora") = "2016-10-31"
        spei1("ClaveSPEI") = "2016-10-16"
        spei1("sello") = "2016-10-31"
        spei1("numeroCertificado") = "f15"
        spei1("cadenaCDA") = "ef15"

        Dim ordenante2 As MFObject = New MFObject("Ordenante")
        ordenante2("BancoEmisor") = "56O"
        ordenante2("Nombre") = "hytO"
        ordenante2("TipoCuenta") = "hyO"
        ordenante2("Cuenta") = "45O"
        ordenante2("RFC") = "4O"

        Dim beneficiario2 As MFObject = New MFObject("Beneficiario")
        beneficiario2("BancoReceptor") = "hO"
        beneficiario2("Nombre") = "hfO"
        beneficiario2("TipoCuenta") = "hfO"
        beneficiario2("Cuenta") = "hfO"
        beneficiario2("RFC") = "rwtO"
        beneficiario2("Concepto") = "kyiuO"
        beneficiario2("IVA") = "65O"
        beneficiario2("MontoPago") = "gO"
        spei1.AgregaSubnodo(ordenante2)
        spei1.AgregaSubnodo(beneficiario2)
        sterceros.AgregaSubnodo(spei1)
        SPEI.AgregaSubnodo(sterceros)
        Return SPEI
    End Function

    Public Function complementoDetallista() As MFObject

        Dim Detallista As MFObject = New MFObject("Detallista")
        Detallista("documentStatus") = "COPY"

        Dim refopaid As MFObject = New MFObject("requestForPaymentIdentification")
        refopaid("entityType") = "INVOICE"
        Detallista.AgregaSubnodo(refopaid)

        Dim spins As MFObject = New MFObject("specialInstruction")
        Dim spin0 As MFObject = New MFObject("0")
        spin0("text") = "hasta15cadenas"
        spin0("text") = "segunda"
        spin0("code") = "ZZZ"
        spins.AgregaSubnodo(spin0)
        Detallista.AgregaSubnodo(spins)

        Dim ordid As MFObject = New MFObject("orderIdentification")
        Dim references As MFObject = New MFObject("referenceIdentification")
        Dim ref0 As MFObject = New MFObject("0")
        ref0("type") = "ON" ' FIJO
        ordid("ReferenceDate") = "2016-10-31"
        references.AgregaSubnodo(ref0)
        ordid.AgregaSubnodo(references)
        Detallista.AgregaSubnodo(ordid)

        Dim adinfo As MFObject = New MFObject("AdditionalInformation")
        Dim references2 As MFObject = New MFObject("referenceIdentification")
        Dim ref02 As MFObject = New MFObject("0")
        ref02("type") = "ON"
        references2.AgregaSubnodo(ref02)
        adinfo.AgregaSubnodo(references2)
        Detallista.AgregaSubnodo(adinfo)

        Dim denote As MFObject = New MFObject("DeliveryNote")
        Dim references3 As MFObject = New MFObject("referenceIdentification")
        Dim ref03 As MFObject = New MFObject("0")
        ref03("referenceIdentification") = "hasta30cadenas"
        denote("ReferenceDate") = "2016-10-31"
        references3.AgregaSubnodo(ref03)
        denote.AgregaSubnodo(references3)
        Detallista.AgregaSubnodo(denote)

        Dim buyer As MFObject = New MFObject("buyer")
        Dim contacto As MFObject = New MFObject("contactInformation")
        Dim pers As MFObject = New MFObject("personOrDepartmentName")
        buyer("gln") = "gthtr"
        pers("text") = "mitexto"
        contacto.AgregaSubnodo(pers)
        buyer.AgregaSubnodo(contacto)
        Detallista.AgregaSubnodo(buyer)

        Dim seller As MFObject = New MFObject("seller")
        Dim altpaid As MFObject = New MFObject("alternatePartyIdentification")
        seller("gln") = "yun"
        altpaid("type") = "IEPS_REFERENCE"
        seller.AgregaSubnodo(altpaid)
        Detallista.AgregaSubnodo(seller)

        Dim shipto As MFObject = New MFObject("shipTo")
        Dim infos As MFObject = New MFObject("nameAndAddress")
        Dim inf0 As MFObject = New MFObject("0")
        shipto("gln") = "kui"
        inf0("name") = "sergio"
        inf0("streetAddressOne") = "torre del redentor"
        inf0("city") = "torreon"
        inf0("postalCode") = "27000"
        infos.AgregaSubnodo(inf0)
        shipto.AgregaSubnodo(infos)
        Detallista.AgregaSubnodo(shipto)

        Dim invoice As MFObject = New MFObject("InvoiceCreator")
        Dim altpaid2 As MFObject = New MFObject("alternatePartyIdentification")
        Dim namedir As MFObject = New MFObject("nameAndAddress")
        invoice("gln") = "jtyuj"
        altpaid2("type") = "VA"
        namedir("name") = "Blanca"
        namedir("streetAddressOne") = "torre blanca"
        namedir("city") = "torreon"
        namedir("postalCode") = "27200"
        invoice.AgregaSubnodo(altpaid2)
        invoice.AgregaSubnodo(namedir)
        Detallista.AgregaSubnodo(invoice)

        Dim clientes As MFObject = New MFObject("Customs")
        Dim client0 As MFObject = New MFObject("0")
        Dim client1 As MFObject = New MFObject("1")
        client0("gln") = "trece"
        client1("gln") = "dos"
        clientes.AgregaSubnodo(client0)
        clientes.AgregaSubnodo(client1)
        Detallista.AgregaSubnodo(clientes)

        Dim Currency As MFObject = New MFObject("currency")
        Dim cur0 As MFObject = New MFObject("0")
        cur0("currencyFunction") = "BILLING_CURRENCY"
        cur0("currencyFunction") = "PRICE_CURRENCY"
        cur0("currencyFunction") = "PAYMENT_CURRENCY"
        cur0("rateOfChange") = "12.8"
        cur0("currencyISOCode") = "USD"
        Currency.AgregaSubnodo(cur0)
        Detallista.AgregaSubnodo(Currency)

        Dim payterms As MFObject = New MFObject("paymentTerms")
        Dim paytime As MFObject = New MFObject("paymentTimePeriod")
        Dim timePeriod As MFObject = New MFObject("timePeriodDue")
        timePeriod("value") = "Ano"
        timePeriod("timePeriod") = "DAYS"
        Dim netpay As MFObject = New MFObject("netPayment")
        Dim dispay As MFObject = New MFObject("discountPayment")
        netpay("netPaymentTermsType") = "DAYS"
        dispay("percentage") = "1%"
        dispay("discountType") = "SANCTION"
        payterms("paymentTermsEvent") = "DATE_OF_INVOICE"
        payterms("PaymentTermsRelationTime") = "REFERENCE_AFTER"
        paytime.AgregaSubnodo(timePeriod)
        payterms.AgregaSubnodo(paytime)
        payterms.AgregaSubnodo(netpay)
        payterms.AgregaSubnodo(dispay)
        Detallista.AgregaSubnodo(payterms)

        Detallista("shipmentDetail") = "LIHHI"
        Dim allowance As MFObject = New MFObject("allowanceCharge")
        allowance("allowanceChargeType") = "ALLOWANCE_GLOBAL"
        allowance("settlementType") = "BILL_BACK"
        allowance("sequenceNumber") = "del1al15"
        allowance("specialServicesType") = "RAA"
        Dim monetary As MFObject = New MFObject("monetaryAmountOrPercentage")
        Dim _rate As MFObject = New MFObject("rate")
        _rate("percentage") = "21.32"
        _rate("base") = "INVOICE_VALUE"
        monetary.AgregaSubnodo(_rate)
        allowance.AgregaSubnodo(monetary)
        Detallista.AgregaSubnodo(allowance)

        Dim lineas As MFObject = New MFObject("lineItem")
        Dim Item As MFObject = New MFObject("0")
        Item("type") = "SimpleInvoiceLineItemType"
        Item("number") = "123"

        Dim trade As MFObject = New MFObject("tradeItemIdentification")
        trade("gtin") = "btyu"
        Item.AgregaSubnodo(trade)
        Dim altern As MFObject = New MFObject("alternateTradeItemIdentification")
        Dim alt0 As MFObject = New MFObject("0")
        alt0("type") = "SERIAL_NUMBER"
        altern.AgregaSubnodo(alt0)
        Item.AgregaSubnodo(altern)
        Dim desc As MFObject = New MFObject("tradeItemDescriptionInformation")
        desc("longText") = "textolargo"
        desc("language") = "ES"
        Item.AgregaSubnodo(desc)
        Dim invoqua As MFObject = New MFObject("invoicedQuantity")
        invoqua("unitOfMeasure") = "ernyt"
        Item.AgregaSubnodo(invoqua)
        Dim aditional As MFObject = New MFObject("aditionalQuantity")
        Dim ad0 As MFObject = New MFObject("0")
        ad0("QuantityType") = "FREE_GOODS"
        aditional.AgregaSubnodo(ad0)
        Item.AgregaSubnodo(aditional)
        Dim gross As MFObject = New MFObject("grossPrice")
        gross("Amount") = "34.4"
        Item.AgregaSubnodo(gross)
        Dim netprice As MFObject = New MFObject("netPrice")
        netprice("Amount") = "23.8"
        Item.AgregaSubnodo(netprice)

        Dim adInformation As MFObject = New MFObject("AdditionalInformation")
        Dim reference As MFObject = New MFObject("referenceIdentification")
        reference("type") = "ON"
        adInformation.AgregaSubnodo(reference)
        Item.AgregaSubnodo(adInformation)
        Dim customs As MFObject = New MFObject("Customs")
        Dim cus0 As MFObject = New MFObject("0")
        Dim alt As MFObject = New MFObject("alternatePartyIdentification")
        cus0("gln") = "hastatrece"
        alt("type") = "TN"
        cus0("ReferenceDate") = "20219"
        cus0("nameAndAddress") = "SERGIO TORRES"
        cus0.AgregaSubnodo(alt)
        customs.AgregaSubnodo(cus0)
        Item.AgregaSubnodo(customs)
        Dim logic As MFObject = New MFObject("LogisticUnits")
        Dim serial As MFObject = New MFObject("serialShippingContainerCode")
        serial("type") = "BJ"
        logic.AgregaSubnodo(serial)
        Item.AgregaSubnodo(logic)
        Dim pallet As MFObject = New MFObject("palletInformation")
        pallet("palletQuantity") = "PAREG"
        Dim pdesc As MFObject = New MFObject("description")
        pdesc("type") = "BOX"
        Dim trans As MFObject = New MFObject("transport")
        trans("methodOfPayment") = "PAID_BY_BUYER"
        pallet.AgregaSubnodo(pdesc)
        pallet.AgregaSubnodo(trans)
        Item.AgregaSubnodo(pallet)
        Dim extended As MFObject = New MFObject("extEnd FunctionedAttributes")
        Dim lotnum As MFObject = New MFObject("lotNumber")
        Dim lot0 As MFObject = New MFObject("0")
        lot0("productionDate") = "098984"
        lotnum.AgregaSubnodo(lot0)
        extended.AgregaSubnodo(lotnum)
        Item.AgregaSubnodo(extended)
        Dim allows As MFObject = New MFObject("allowanceCharge")
        Dim allow0 As MFObject = New MFObject("0")
        allow0("specialServicesType") = "VAB"
        Dim moampe As MFObject = New MFObject("monetaryAmountOrPercentage")
        moampe("percentagePerUnit") = "kjhw"
        Dim rapeun As MFObject = New MFObject("ratePerUnit")
        rapeun("amountPerUnit") = "jyu"
        allow0("allowanceChargeType") = "ALLOWANCE_GLOBAL"
        allow0("settlementType") = "OFF_INVOICE"
        allow0("sequenceNumber") = "ntyyu"
        moampe.AgregaSubnodo(rapeun)
        allow0.AgregaSubnodo(moampe)
        allows.AgregaSubnodo(allow0)
        Item.AgregaSubnodo(allows)
        Dim trades As MFObject = New MFObject("tradeItemTaxInformation")
        Dim trade0 As MFObject = New MFObject("0")
        trade0("taxTypeDescription") = "AAA"
        trade0("referenceNumber") = "kuhywe"
        Dim tradeamo As MFObject = New MFObject("tradeItemTaxAmount")
        tradeamo("taxPercentage") = "76.12"
        tradeamo("taxAmount") = "43.6"
        trade0("taxCategory") = "TRANSFERIDO"
        trade0.AgregaSubnodo(tradeamo)
        trades.AgregaSubnodo(trade0)
        Item.AgregaSubnodo(trades)
        Dim totaline As MFObject = New MFObject("totalLineAmount")
        Dim grossa As MFObject = New MFObject("grossAmount")
        grossa("Amount") = "65.8"
        Dim neta As MFObject = New MFObject("netAmount")
        neta("Amount") = "63.9"
        totaline.AgregaSubnodo(grossa)
        totaline.AgregaSubnodo(neta)
        Item.AgregaSubnodo(totaline)
        lineas.AgregaSubnodo(Item)
        Detallista.AgregaSubnodo(lineas)
        Dim totalamo As MFObject = New MFObject("totalAmount")
        totalamo("Amount") = "12.3"
        Detallista.AgregaSubnodo(totalamo)
        Dim totalallow As MFObject = New MFObject("TotalAllowanceCharge")
        Dim ta0 As MFObject = New MFObject("0")
        ta0("specialServicesType") = "ABZ"
        ta0("Amount") = "54.9"
        ta0("allowanceOrChargeType") = "ALLOWANCE"
        totalallow.AgregaSubnodo(ta0)
        Detallista.AgregaSubnodo(totalallow)
        Return Detallista
    End Function

    Public Sub PreparaArbol()
        treeView1.Nodes.Clear()
        sdk.Arbol = treeView1
    End Sub
End Class
